/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.timeseries.cargobydriver.requests;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CargoByDriverLastSeenPublicV1Request {
    private final String cargoId;
    private final String taskGroupId;
    private final Map<String, Object> additionalProperties;

    private CargoByDriverLastSeenPublicV1Request(String cargoId, String taskGroupId, Map<String, Object> additionalProperties) {
        this.cargoId = cargoId;
        this.taskGroupId = taskGroupId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cargo_id")
    public String getCargoId() {
        return this.cargoId;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CargoByDriverLastSeenPublicV1Request && this.equalTo((CargoByDriverLastSeenPublicV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CargoByDriverLastSeenPublicV1Request other) {
        return this.cargoId.equals(other.cargoId) && this.taskGroupId.equals(other.taskGroupId);
    }

    public int hashCode() {
        return Objects.hash(this.cargoId, this.taskGroupId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CargoIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CargoIdStage,
    TaskGroupIdStage,
    _FinalStage {
        private String cargoId;
        private String taskGroupId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CargoByDriverLastSeenPublicV1Request other) {
            this.cargoId(other.getCargoId());
            this.taskGroupId(other.getTaskGroupId());
            return this;
        }

        @Override
        @JsonSetter(value="cargo_id")
        public TaskGroupIdStage cargoId(@NotNull String cargoId) {
            this.cargoId = Objects.requireNonNull(cargoId, "cargoId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public _FinalStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        public CargoByDriverLastSeenPublicV1Request build() {
            return new CargoByDriverLastSeenPublicV1Request(this.cargoId, this.taskGroupId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CargoByDriverLastSeenPublicV1Request build();
    }

    public static interface TaskGroupIdStage {
        public _FinalStage taskGroupId(@NotNull String var1);
    }

    public static interface CargoIdStage {
        public TaskGroupIdStage cargoId(@NotNull String var1);

        public Builder from(CargoByDriverLastSeenPublicV1Request var1);
    }
}

