/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.tracking.timeseries.sessionbydevice.requests;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SessionByDeviceDataPointsPublicV1Request {
    private final String sessionId;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private SessionByDeviceDataPointsPublicV1Request(String sessionId, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.sessionId = sessionId;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="session_id")
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SessionByDeviceDataPointsPublicV1Request && this.equalTo((SessionByDeviceDataPointsPublicV1Request)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SessionByDeviceDataPointsPublicV1Request other) {
        return this.sessionId.equals(other.sessionId) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SessionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SessionIdStage,
    _FinalStage {
        private String sessionId;
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SessionByDeviceDataPointsPublicV1Request other) {
            this.sessionId(other.getSessionId());
            this.limit(other.getLimit());
            return this;
        }

        @Override
        @JsonSetter(value="session_id")
        public _FinalStage sessionId(@NotNull String sessionId) {
            this.sessionId = Objects.requireNonNull(sessionId, "sessionId must not be null");
            return this;
        }

        @Override
        public _FinalStage limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public SessionByDeviceDataPointsPublicV1Request build() {
            return new SessionByDeviceDataPointsPublicV1Request(this.sessionId, this.limit, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SessionByDeviceDataPointsPublicV1Request build();

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage limit(Nullable<Integer> var1);
    }

    public static interface SessionIdStage {
        public _FinalStage sessionId(@NotNull String var1);

        public Builder from(SessionByDeviceDataPointsPublicV1Request var1);
    }
}

