/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.users;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.users.AsyncRawUsersClient;
import com.chrt.api.types.UserPublicData1;
import java.util.concurrent.CompletableFuture;

public class AsyncUsersClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawUsersClient rawClient;

    public AsyncUsersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawUsersClient(clientOptions);
    }

    public AsyncRawUsersClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<UserPublicData1> getUserPublicDataV1() {
        return this.rawClient.getUserPublicDataV1().thenApply(response -> (UserPublicData1)response.body());
    }

    public CompletableFuture<UserPublicData1> getUserPublicDataV1(RequestOptions requestOptions) {
        return this.rawClient.getUserPublicDataV1(requestOptions).thenApply(response -> (UserPublicData1)response.body());
    }
}

