/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.resources.utils;

import com.chrt.api.core.ClientOptions;
import com.chrt.api.core.RequestOptions;
import com.chrt.api.resources.utils.AsyncRawUtilsClient;
import com.chrt.api.resources.utils.requests.UtilsGetTimezoneV1Request;
import com.chrt.api.types.TimezoneResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncUtilsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawUtilsClient rawClient;

    public AsyncUtilsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawUtilsClient(clientOptions);
    }

    public AsyncRawUtilsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TimezoneResponse> getTimezoneV1(UtilsGetTimezoneV1Request request) {
        return this.rawClient.getTimezoneV1(request).thenApply(response -> (TimezoneResponse)response.body());
    }

    public CompletableFuture<TimezoneResponse> getTimezoneV1(UtilsGetTimezoneV1Request request, RequestOptions requestOptions) {
        return this.rawClient.getTimezoneV1(request, requestOptions).thenApply(response -> (TimezoneResponse)response.body());
    }
}

