/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoByDeviceDataPointMetadata1;
import com.chrt.api.types.LocationFeature;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CargoByDeviceDataPoint1 {
    private final int schemaVersion;
    private final OffsetDateTime timestamp;
    private final CargoByDeviceDataPointMetadata1 metadata;
    private final LocationFeature location;
    private final Optional<Double> temperature;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private CargoByDeviceDataPoint1(int schemaVersion, OffsetDateTime timestamp, CargoByDeviceDataPointMetadata1 metadata, LocationFeature location, Optional<Double> temperature, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.timestamp = timestamp;
        this.metadata = metadata;
        this.location = location;
        this.temperature = temperature;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="metadata")
    public CargoByDeviceDataPointMetadata1 getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="location")
    public LocationFeature getLocation() {
        return this.location;
    }

    @JsonIgnore
    public Optional<Double> getTemperature() {
        if (this.temperature == null) {
            return Optional.empty();
        }
        return this.temperature;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="temperature")
    private Optional<Double> _getTemperature() {
        return this.temperature;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CargoByDeviceDataPoint1 && this.equalTo((CargoByDeviceDataPoint1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CargoByDeviceDataPoint1 other) {
        return this.schemaVersion == other.schemaVersion && this.timestamp.equals(other.timestamp) && this.metadata.equals(other.metadata) && this.location.equals(other.location) && this.temperature.equals(other.temperature) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.timestamp, this.metadata, this.location, this.temperature, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    TimestampStage,
    MetadataStage,
    LocationStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private OffsetDateTime timestamp;
        private CargoByDeviceDataPointMetadata1 metadata;
        private LocationFeature location;
        private String id;
        private Optional<Double> temperature = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CargoByDeviceDataPoint1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.timestamp(other.getTimestamp());
            this.metadata(other.getMetadata());
            this.location(other.getLocation());
            this.temperature(other.getTemperature());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public TimestampStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public MetadataStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="metadata")
        public LocationStage metadata(@NotNull CargoByDeviceDataPointMetadata1 metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location")
        public IdStage location(@NotNull LocationFeature location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage temperature(Nullable<Double> temperature) {
            this.temperature = temperature.isNull() ? null : (temperature.isEmpty() ? Optional.empty() : Optional.of(temperature.get()));
            return this;
        }

        @Override
        public _FinalStage temperature(Double temperature) {
            this.temperature = Optional.ofNullable(temperature);
            return this;
        }

        @Override
        @JsonSetter(value="temperature", nulls=Nulls.SKIP)
        public _FinalStage temperature(Optional<Double> temperature) {
            this.temperature = temperature;
            return this;
        }

        @Override
        public CargoByDeviceDataPoint1 build() {
            return new CargoByDeviceDataPoint1(this.schemaVersion, this.timestamp, this.metadata, this.location, this.temperature, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CargoByDeviceDataPoint1 build();

        public _FinalStage temperature(Optional<Double> var1);

        public _FinalStage temperature(Double var1);

        public _FinalStage temperature(Nullable<Double> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface LocationStage {
        public IdStage location(@NotNull LocationFeature var1);
    }

    public static interface MetadataStage {
        public LocationStage metadata(@NotNull CargoByDeviceDataPointMetadata1 var1);
    }

    public static interface TimestampStage {
        public MetadataStage timestamp(@NotNull OffsetDateTime var1);
    }

    public static interface SchemaVersionStage {
        public TimestampStage schemaVersion(int var1);

        public Builder from(CargoByDeviceDataPoint1 var1);
    }
}

