/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.CargoTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CargoClientUpdate1 {
    private final Optional<CargoTypeEnum1> cargoType;
    private final Optional<Integer> quantity;
    private final Optional<Double> weightPounds;
    private final Optional<Double> lengthInches;
    private final Optional<Double> widthInches;
    private final Optional<Double> heightInches;
    private final Optional<Boolean> turnable;
    private final Optional<Boolean> stackable;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private CargoClientUpdate1(Optional<CargoTypeEnum1> cargoType, Optional<Integer> quantity, Optional<Double> weightPounds, Optional<Double> lengthInches, Optional<Double> widthInches, Optional<Double> heightInches, Optional<Boolean> turnable, Optional<Boolean> stackable, Optional<String> description, Map<String, Object> additionalProperties) {
        this.cargoType = cargoType;
        this.quantity = quantity;
        this.weightPounds = weightPounds;
        this.lengthInches = lengthInches;
        this.widthInches = widthInches;
        this.heightInches = heightInches;
        this.turnable = turnable;
        this.stackable = stackable;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<CargoTypeEnum1> getCargoType() {
        if (this.cargoType == null) {
            return Optional.empty();
        }
        return this.cargoType;
    }

    @JsonIgnore
    public Optional<Integer> getQuantity() {
        if (this.quantity == null) {
            return Optional.empty();
        }
        return this.quantity;
    }

    @JsonIgnore
    public Optional<Double> getWeightPounds() {
        if (this.weightPounds == null) {
            return Optional.empty();
        }
        return this.weightPounds;
    }

    @JsonIgnore
    public Optional<Double> getLengthInches() {
        if (this.lengthInches == null) {
            return Optional.empty();
        }
        return this.lengthInches;
    }

    @JsonIgnore
    public Optional<Double> getWidthInches() {
        if (this.widthInches == null) {
            return Optional.empty();
        }
        return this.widthInches;
    }

    @JsonIgnore
    public Optional<Double> getHeightInches() {
        if (this.heightInches == null) {
            return Optional.empty();
        }
        return this.heightInches;
    }

    @JsonIgnore
    public Optional<Boolean> getTurnable() {
        if (this.turnable == null) {
            return Optional.empty();
        }
        return this.turnable;
    }

    @JsonIgnore
    public Optional<Boolean> getStackable() {
        if (this.stackable == null) {
            return Optional.empty();
        }
        return this.stackable;
    }

    @JsonIgnore
    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return this.description;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cargo_type")
    private Optional<CargoTypeEnum1> _getCargoType() {
        return this.cargoType;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="quantity")
    private Optional<Integer> _getQuantity() {
        return this.quantity;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="weight_pounds")
    private Optional<Double> _getWeightPounds() {
        return this.weightPounds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="length_inches")
    private Optional<Double> _getLengthInches() {
        return this.lengthInches;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="width_inches")
    private Optional<Double> _getWidthInches() {
        return this.widthInches;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="height_inches")
    private Optional<Double> _getHeightInches() {
        return this.heightInches;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="turnable")
    private Optional<Boolean> _getTurnable() {
        return this.turnable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stackable")
    private Optional<Boolean> _getStackable() {
        return this.stackable;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="description")
    private Optional<String> _getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CargoClientUpdate1 && this.equalTo((CargoClientUpdate1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CargoClientUpdate1 other) {
        return this.cargoType.equals(other.cargoType) && this.quantity.equals(other.quantity) && this.weightPounds.equals(other.weightPounds) && this.lengthInches.equals(other.lengthInches) && this.widthInches.equals(other.widthInches) && this.heightInches.equals(other.heightInches) && this.turnable.equals(other.turnable) && this.stackable.equals(other.stackable) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.cargoType, this.quantity, this.weightPounds, this.lengthInches, this.widthInches, this.heightInches, this.turnable, this.stackable, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CargoTypeEnum1> cargoType = Optional.empty();
        private Optional<Integer> quantity = Optional.empty();
        private Optional<Double> weightPounds = Optional.empty();
        private Optional<Double> lengthInches = Optional.empty();
        private Optional<Double> widthInches = Optional.empty();
        private Optional<Double> heightInches = Optional.empty();
        private Optional<Boolean> turnable = Optional.empty();
        private Optional<Boolean> stackable = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CargoClientUpdate1 other) {
            this.cargoType(other.getCargoType());
            this.quantity(other.getQuantity());
            this.weightPounds(other.getWeightPounds());
            this.lengthInches(other.getLengthInches());
            this.widthInches(other.getWidthInches());
            this.heightInches(other.getHeightInches());
            this.turnable(other.getTurnable());
            this.stackable(other.getStackable());
            this.description(other.getDescription());
            return this;
        }

        @JsonSetter(value="cargo_type", nulls=Nulls.SKIP)
        public Builder cargoType(Optional<CargoTypeEnum1> cargoType) {
            this.cargoType = cargoType;
            return this;
        }

        public Builder cargoType(CargoTypeEnum1 cargoType) {
            this.cargoType = Optional.ofNullable(cargoType);
            return this;
        }

        public Builder cargoType(Nullable<CargoTypeEnum1> cargoType) {
            this.cargoType = cargoType.isNull() ? null : (cargoType.isEmpty() ? Optional.empty() : Optional.of(cargoType.get()));
            return this;
        }

        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public Builder quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        public Builder quantity(Nullable<Integer> quantity) {
            this.quantity = quantity.isNull() ? null : (quantity.isEmpty() ? Optional.empty() : Optional.of(quantity.get()));
            return this;
        }

        @JsonSetter(value="weight_pounds", nulls=Nulls.SKIP)
        public Builder weightPounds(Optional<Double> weightPounds) {
            this.weightPounds = weightPounds;
            return this;
        }

        public Builder weightPounds(Double weightPounds) {
            this.weightPounds = Optional.ofNullable(weightPounds);
            return this;
        }

        public Builder weightPounds(Nullable<Double> weightPounds) {
            this.weightPounds = weightPounds.isNull() ? null : (weightPounds.isEmpty() ? Optional.empty() : Optional.of(weightPounds.get()));
            return this;
        }

        @JsonSetter(value="length_inches", nulls=Nulls.SKIP)
        public Builder lengthInches(Optional<Double> lengthInches) {
            this.lengthInches = lengthInches;
            return this;
        }

        public Builder lengthInches(Double lengthInches) {
            this.lengthInches = Optional.ofNullable(lengthInches);
            return this;
        }

        public Builder lengthInches(Nullable<Double> lengthInches) {
            this.lengthInches = lengthInches.isNull() ? null : (lengthInches.isEmpty() ? Optional.empty() : Optional.of(lengthInches.get()));
            return this;
        }

        @JsonSetter(value="width_inches", nulls=Nulls.SKIP)
        public Builder widthInches(Optional<Double> widthInches) {
            this.widthInches = widthInches;
            return this;
        }

        public Builder widthInches(Double widthInches) {
            this.widthInches = Optional.ofNullable(widthInches);
            return this;
        }

        public Builder widthInches(Nullable<Double> widthInches) {
            this.widthInches = widthInches.isNull() ? null : (widthInches.isEmpty() ? Optional.empty() : Optional.of(widthInches.get()));
            return this;
        }

        @JsonSetter(value="height_inches", nulls=Nulls.SKIP)
        public Builder heightInches(Optional<Double> heightInches) {
            this.heightInches = heightInches;
            return this;
        }

        public Builder heightInches(Double heightInches) {
            this.heightInches = Optional.ofNullable(heightInches);
            return this;
        }

        public Builder heightInches(Nullable<Double> heightInches) {
            this.heightInches = heightInches.isNull() ? null : (heightInches.isEmpty() ? Optional.empty() : Optional.of(heightInches.get()));
            return this;
        }

        @JsonSetter(value="turnable", nulls=Nulls.SKIP)
        public Builder turnable(Optional<Boolean> turnable) {
            this.turnable = turnable;
            return this;
        }

        public Builder turnable(Boolean turnable) {
            this.turnable = Optional.ofNullable(turnable);
            return this;
        }

        public Builder turnable(Nullable<Boolean> turnable) {
            this.turnable = turnable.isNull() ? null : (turnable.isEmpty() ? Optional.empty() : Optional.of(turnable.get()));
            return this;
        }

        @JsonSetter(value="stackable", nulls=Nulls.SKIP)
        public Builder stackable(Optional<Boolean> stackable) {
            this.stackable = stackable;
            return this;
        }

        public Builder stackable(Boolean stackable) {
            this.stackable = Optional.ofNullable(stackable);
            return this;
        }

        public Builder stackable(Nullable<Boolean> stackable) {
            this.stackable = stackable.isNull() ? null : (stackable.isEmpty() ? Optional.empty() : Optional.of(stackable.get()));
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public Builder description(Nullable<String> description) {
            this.description = description.isNull() ? null : (description.isEmpty() ? Optional.empty() : Optional.of(description.get()));
            return this;
        }

        public CargoClientUpdate1 build() {
            return new CargoClientUpdate1(this.cargoType, this.quantity, this.weightPounds, this.lengthInches, this.widthInches, this.heightInches, this.turnable, this.stackable, this.description, this.additionalProperties);
        }
    }
}

