/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.ClerkOrgData;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DecodedJwtWithOrgAndUserId {
    private final Optional<String> azp;
    private final Optional<Integer> exp;
    private final Optional<List<Integer>> fva;
    private final Optional<Integer> iat;
    private final Optional<String> iss;
    private final Optional<String> jti;
    private final Optional<Integer> nbf;
    private final Optional<String> sid;
    private final Optional<String> sub;
    private final Optional<String> sts;
    private final Optional<Integer> v;
    private final Optional<ClerkOrgData> o;
    private final Optional<Map<String, Object>> orgPublicMetadata;
    private final Optional<String> primaryEmailAddress;
    private final String userId;
    private final String orgId;
    private final Map<String, Object> additionalProperties;

    private DecodedJwtWithOrgAndUserId(Optional<String> azp, Optional<Integer> exp, Optional<List<Integer>> fva, Optional<Integer> iat, Optional<String> iss, Optional<String> jti, Optional<Integer> nbf, Optional<String> sid, Optional<String> sub, Optional<String> sts, Optional<Integer> v, Optional<ClerkOrgData> o, Optional<Map<String, Object>> orgPublicMetadata, Optional<String> primaryEmailAddress, String userId, String orgId, Map<String, Object> additionalProperties) {
        this.azp = azp;
        this.exp = exp;
        this.fva = fva;
        this.iat = iat;
        this.iss = iss;
        this.jti = jti;
        this.nbf = nbf;
        this.sid = sid;
        this.sub = sub;
        this.sts = sts;
        this.v = v;
        this.o = o;
        this.orgPublicMetadata = orgPublicMetadata;
        this.primaryEmailAddress = primaryEmailAddress;
        this.userId = userId;
        this.orgId = orgId;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getAzp() {
        if (this.azp == null) {
            return Optional.empty();
        }
        return this.azp;
    }

    @JsonIgnore
    public Optional<Integer> getExp() {
        if (this.exp == null) {
            return Optional.empty();
        }
        return this.exp;
    }

    @JsonIgnore
    public Optional<List<Integer>> getFva() {
        if (this.fva == null) {
            return Optional.empty();
        }
        return this.fva;
    }

    @JsonIgnore
    public Optional<Integer> getIat() {
        if (this.iat == null) {
            return Optional.empty();
        }
        return this.iat;
    }

    @JsonIgnore
    public Optional<String> getIss() {
        if (this.iss == null) {
            return Optional.empty();
        }
        return this.iss;
    }

    @JsonIgnore
    public Optional<String> getJti() {
        if (this.jti == null) {
            return Optional.empty();
        }
        return this.jti;
    }

    @JsonIgnore
    public Optional<Integer> getNbf() {
        if (this.nbf == null) {
            return Optional.empty();
        }
        return this.nbf;
    }

    @JsonIgnore
    public Optional<String> getSid() {
        if (this.sid == null) {
            return Optional.empty();
        }
        return this.sid;
    }

    @JsonIgnore
    public Optional<String> getSub() {
        if (this.sub == null) {
            return Optional.empty();
        }
        return this.sub;
    }

    @JsonIgnore
    public Optional<String> getSts() {
        if (this.sts == null) {
            return Optional.empty();
        }
        return this.sts;
    }

    @JsonIgnore
    public Optional<Integer> getV() {
        if (this.v == null) {
            return Optional.empty();
        }
        return this.v;
    }

    @JsonIgnore
    public Optional<ClerkOrgData> getO() {
        if (this.o == null) {
            return Optional.empty();
        }
        return this.o;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> getOrgPublicMetadata() {
        if (this.orgPublicMetadata == null) {
            return Optional.empty();
        }
        return this.orgPublicMetadata;
    }

    @JsonIgnore
    public Optional<String> getPrimaryEmailAddress() {
        if (this.primaryEmailAddress == null) {
            return Optional.empty();
        }
        return this.primaryEmailAddress;
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="org_id")
    public String getOrgId() {
        return this.orgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="azp")
    private Optional<String> _getAzp() {
        return this.azp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exp")
    private Optional<Integer> _getExp() {
        return this.exp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fva")
    private Optional<List<Integer>> _getFva() {
        return this.fva;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="iat")
    private Optional<Integer> _getIat() {
        return this.iat;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="iss")
    private Optional<String> _getIss() {
        return this.iss;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="jti")
    private Optional<String> _getJti() {
        return this.jti;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="nbf")
    private Optional<Integer> _getNbf() {
        return this.nbf;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sid")
    private Optional<String> _getSid() {
        return this.sid;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sub")
    private Optional<String> _getSub() {
        return this.sub;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="sts")
    private Optional<String> _getSts() {
        return this.sts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="v")
    private Optional<Integer> _getV() {
        return this.v;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="o")
    private Optional<ClerkOrgData> _getO() {
        return this.o;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="org_public_metadata")
    private Optional<Map<String, Object>> _getOrgPublicMetadata() {
        return this.orgPublicMetadata;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="primary_email_address")
    private Optional<String> _getPrimaryEmailAddress() {
        return this.primaryEmailAddress;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DecodedJwtWithOrgAndUserId && this.equalTo((DecodedJwtWithOrgAndUserId)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DecodedJwtWithOrgAndUserId other) {
        return this.azp.equals(other.azp) && this.exp.equals(other.exp) && this.fva.equals(other.fva) && this.iat.equals(other.iat) && this.iss.equals(other.iss) && this.jti.equals(other.jti) && this.nbf.equals(other.nbf) && this.sid.equals(other.sid) && this.sub.equals(other.sub) && this.sts.equals(other.sts) && this.v.equals(other.v) && this.o.equals(other.o) && this.orgPublicMetadata.equals(other.orgPublicMetadata) && this.primaryEmailAddress.equals(other.primaryEmailAddress) && this.userId.equals(other.userId) && this.orgId.equals(other.orgId);
    }

    public int hashCode() {
        return Objects.hash(this.azp, this.exp, this.fva, this.iat, this.iss, this.jti, this.nbf, this.sid, this.sub, this.sts, this.v, this.o, this.orgPublicMetadata, this.primaryEmailAddress, this.userId, this.orgId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UserIdStage,
    OrgIdStage,
    _FinalStage {
        private String userId;
        private String orgId;
        private Optional<String> primaryEmailAddress = Optional.empty();
        private Optional<Map<String, Object>> orgPublicMetadata = Optional.empty();
        private Optional<ClerkOrgData> o = Optional.empty();
        private Optional<Integer> v = Optional.empty();
        private Optional<String> sts = Optional.empty();
        private Optional<String> sub = Optional.empty();
        private Optional<String> sid = Optional.empty();
        private Optional<Integer> nbf = Optional.empty();
        private Optional<String> jti = Optional.empty();
        private Optional<String> iss = Optional.empty();
        private Optional<Integer> iat = Optional.empty();
        private Optional<List<Integer>> fva = Optional.empty();
        private Optional<Integer> exp = Optional.empty();
        private Optional<String> azp = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DecodedJwtWithOrgAndUserId other) {
            this.azp(other.getAzp());
            this.exp(other.getExp());
            this.fva(other.getFva());
            this.iat(other.getIat());
            this.iss(other.getIss());
            this.jti(other.getJti());
            this.nbf(other.getNbf());
            this.sid(other.getSid());
            this.sub(other.getSub());
            this.sts(other.getSts());
            this.v(other.getV());
            this.o(other.getO());
            this.orgPublicMetadata(other.getOrgPublicMetadata());
            this.primaryEmailAddress(other.getPrimaryEmailAddress());
            this.userId(other.getUserId());
            this.orgId(other.getOrgId());
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public OrgIdStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="org_id")
        public _FinalStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @Override
        public _FinalStage primaryEmailAddress(Nullable<String> primaryEmailAddress) {
            this.primaryEmailAddress = primaryEmailAddress.isNull() ? null : (primaryEmailAddress.isEmpty() ? Optional.empty() : Optional.of(primaryEmailAddress.get()));
            return this;
        }

        @Override
        public _FinalStage primaryEmailAddress(String primaryEmailAddress) {
            this.primaryEmailAddress = Optional.ofNullable(primaryEmailAddress);
            return this;
        }

        @Override
        @JsonSetter(value="primary_email_address", nulls=Nulls.SKIP)
        public _FinalStage primaryEmailAddress(Optional<String> primaryEmailAddress) {
            this.primaryEmailAddress = primaryEmailAddress;
            return this;
        }

        @Override
        public _FinalStage orgPublicMetadata(Nullable<Map<String, Object>> orgPublicMetadata) {
            this.orgPublicMetadata = orgPublicMetadata.isNull() ? null : (orgPublicMetadata.isEmpty() ? Optional.empty() : Optional.of(orgPublicMetadata.get()));
            return this;
        }

        @Override
        public _FinalStage orgPublicMetadata(Map<String, Object> orgPublicMetadata) {
            this.orgPublicMetadata = Optional.ofNullable(orgPublicMetadata);
            return this;
        }

        @Override
        @JsonSetter(value="org_public_metadata", nulls=Nulls.SKIP)
        public _FinalStage orgPublicMetadata(Optional<Map<String, Object>> orgPublicMetadata) {
            this.orgPublicMetadata = orgPublicMetadata;
            return this;
        }

        @Override
        public _FinalStage o(Nullable<ClerkOrgData> o) {
            this.o = o.isNull() ? null : (o.isEmpty() ? Optional.empty() : Optional.of(o.get()));
            return this;
        }

        @Override
        public _FinalStage o(ClerkOrgData o) {
            this.o = Optional.ofNullable(o);
            return this;
        }

        @Override
        @JsonSetter(value="o", nulls=Nulls.SKIP)
        public _FinalStage o(Optional<ClerkOrgData> o) {
            this.o = o;
            return this;
        }

        @Override
        public _FinalStage v(Nullable<Integer> v) {
            this.v = v.isNull() ? null : (v.isEmpty() ? Optional.empty() : Optional.of(v.get()));
            return this;
        }

        @Override
        public _FinalStage v(Integer v) {
            this.v = Optional.ofNullable(v);
            return this;
        }

        @Override
        @JsonSetter(value="v", nulls=Nulls.SKIP)
        public _FinalStage v(Optional<Integer> v) {
            this.v = v;
            return this;
        }

        @Override
        public _FinalStage sts(Nullable<String> sts) {
            this.sts = sts.isNull() ? null : (sts.isEmpty() ? Optional.empty() : Optional.of(sts.get()));
            return this;
        }

        @Override
        public _FinalStage sts(String sts) {
            this.sts = Optional.ofNullable(sts);
            return this;
        }

        @Override
        @JsonSetter(value="sts", nulls=Nulls.SKIP)
        public _FinalStage sts(Optional<String> sts) {
            this.sts = sts;
            return this;
        }

        @Override
        public _FinalStage sub(Nullable<String> sub) {
            this.sub = sub.isNull() ? null : (sub.isEmpty() ? Optional.empty() : Optional.of(sub.get()));
            return this;
        }

        @Override
        public _FinalStage sub(String sub) {
            this.sub = Optional.ofNullable(sub);
            return this;
        }

        @Override
        @JsonSetter(value="sub", nulls=Nulls.SKIP)
        public _FinalStage sub(Optional<String> sub) {
            this.sub = sub;
            return this;
        }

        @Override
        public _FinalStage sid(Nullable<String> sid) {
            this.sid = sid.isNull() ? null : (sid.isEmpty() ? Optional.empty() : Optional.of(sid.get()));
            return this;
        }

        @Override
        public _FinalStage sid(String sid) {
            this.sid = Optional.ofNullable(sid);
            return this;
        }

        @Override
        @JsonSetter(value="sid", nulls=Nulls.SKIP)
        public _FinalStage sid(Optional<String> sid) {
            this.sid = sid;
            return this;
        }

        @Override
        public _FinalStage nbf(Nullable<Integer> nbf) {
            this.nbf = nbf.isNull() ? null : (nbf.isEmpty() ? Optional.empty() : Optional.of(nbf.get()));
            return this;
        }

        @Override
        public _FinalStage nbf(Integer nbf) {
            this.nbf = Optional.ofNullable(nbf);
            return this;
        }

        @Override
        @JsonSetter(value="nbf", nulls=Nulls.SKIP)
        public _FinalStage nbf(Optional<Integer> nbf) {
            this.nbf = nbf;
            return this;
        }

        @Override
        public _FinalStage jti(Nullable<String> jti) {
            this.jti = jti.isNull() ? null : (jti.isEmpty() ? Optional.empty() : Optional.of(jti.get()));
            return this;
        }

        @Override
        public _FinalStage jti(String jti) {
            this.jti = Optional.ofNullable(jti);
            return this;
        }

        @Override
        @JsonSetter(value="jti", nulls=Nulls.SKIP)
        public _FinalStage jti(Optional<String> jti) {
            this.jti = jti;
            return this;
        }

        @Override
        public _FinalStage iss(Nullable<String> iss) {
            this.iss = iss.isNull() ? null : (iss.isEmpty() ? Optional.empty() : Optional.of(iss.get()));
            return this;
        }

        @Override
        public _FinalStage iss(String iss) {
            this.iss = Optional.ofNullable(iss);
            return this;
        }

        @Override
        @JsonSetter(value="iss", nulls=Nulls.SKIP)
        public _FinalStage iss(Optional<String> iss) {
            this.iss = iss;
            return this;
        }

        @Override
        public _FinalStage iat(Nullable<Integer> iat) {
            this.iat = iat.isNull() ? null : (iat.isEmpty() ? Optional.empty() : Optional.of(iat.get()));
            return this;
        }

        @Override
        public _FinalStage iat(Integer iat) {
            this.iat = Optional.ofNullable(iat);
            return this;
        }

        @Override
        @JsonSetter(value="iat", nulls=Nulls.SKIP)
        public _FinalStage iat(Optional<Integer> iat) {
            this.iat = iat;
            return this;
        }

        @Override
        public _FinalStage fva(Nullable<List<Integer>> fva) {
            this.fva = fva.isNull() ? null : (fva.isEmpty() ? Optional.empty() : Optional.of(fva.get()));
            return this;
        }

        @Override
        public _FinalStage fva(List<Integer> fva) {
            this.fva = Optional.ofNullable(fva);
            return this;
        }

        @Override
        @JsonSetter(value="fva", nulls=Nulls.SKIP)
        public _FinalStage fva(Optional<List<Integer>> fva) {
            this.fva = fva;
            return this;
        }

        @Override
        public _FinalStage exp(Nullable<Integer> exp) {
            this.exp = exp.isNull() ? null : (exp.isEmpty() ? Optional.empty() : Optional.of(exp.get()));
            return this;
        }

        @Override
        public _FinalStage exp(Integer exp) {
            this.exp = Optional.ofNullable(exp);
            return this;
        }

        @Override
        @JsonSetter(value="exp", nulls=Nulls.SKIP)
        public _FinalStage exp(Optional<Integer> exp) {
            this.exp = exp;
            return this;
        }

        @Override
        public _FinalStage azp(Nullable<String> azp) {
            this.azp = azp.isNull() ? null : (azp.isEmpty() ? Optional.empty() : Optional.of(azp.get()));
            return this;
        }

        @Override
        public _FinalStage azp(String azp) {
            this.azp = Optional.ofNullable(azp);
            return this;
        }

        @Override
        @JsonSetter(value="azp", nulls=Nulls.SKIP)
        public _FinalStage azp(Optional<String> azp) {
            this.azp = azp;
            return this;
        }

        @Override
        public DecodedJwtWithOrgAndUserId build() {
            return new DecodedJwtWithOrgAndUserId(this.azp, this.exp, this.fva, this.iat, this.iss, this.jti, this.nbf, this.sid, this.sub, this.sts, this.v, this.o, this.orgPublicMetadata, this.primaryEmailAddress, this.userId, this.orgId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DecodedJwtWithOrgAndUserId build();

        public _FinalStage azp(Optional<String> var1);

        public _FinalStage azp(String var1);

        public _FinalStage azp(Nullable<String> var1);

        public _FinalStage exp(Optional<Integer> var1);

        public _FinalStage exp(Integer var1);

        public _FinalStage exp(Nullable<Integer> var1);

        public _FinalStage fva(Optional<List<Integer>> var1);

        public _FinalStage fva(List<Integer> var1);

        public _FinalStage fva(Nullable<List<Integer>> var1);

        public _FinalStage iat(Optional<Integer> var1);

        public _FinalStage iat(Integer var1);

        public _FinalStage iat(Nullable<Integer> var1);

        public _FinalStage iss(Optional<String> var1);

        public _FinalStage iss(String var1);

        public _FinalStage iss(Nullable<String> var1);

        public _FinalStage jti(Optional<String> var1);

        public _FinalStage jti(String var1);

        public _FinalStage jti(Nullable<String> var1);

        public _FinalStage nbf(Optional<Integer> var1);

        public _FinalStage nbf(Integer var1);

        public _FinalStage nbf(Nullable<Integer> var1);

        public _FinalStage sid(Optional<String> var1);

        public _FinalStage sid(String var1);

        public _FinalStage sid(Nullable<String> var1);

        public _FinalStage sub(Optional<String> var1);

        public _FinalStage sub(String var1);

        public _FinalStage sub(Nullable<String> var1);

        public _FinalStage sts(Optional<String> var1);

        public _FinalStage sts(String var1);

        public _FinalStage sts(Nullable<String> var1);

        public _FinalStage v(Optional<Integer> var1);

        public _FinalStage v(Integer var1);

        public _FinalStage v(Nullable<Integer> var1);

        public _FinalStage o(Optional<ClerkOrgData> var1);

        public _FinalStage o(ClerkOrgData var1);

        public _FinalStage o(Nullable<ClerkOrgData> var1);

        public _FinalStage orgPublicMetadata(Optional<Map<String, Object>> var1);

        public _FinalStage orgPublicMetadata(Map<String, Object> var1);

        public _FinalStage orgPublicMetadata(Nullable<Map<String, Object>> var1);

        public _FinalStage primaryEmailAddress(Optional<String> var1);

        public _FinalStage primaryEmailAddress(String var1);

        public _FinalStage primaryEmailAddress(Nullable<String> var1);
    }

    public static interface OrgIdStage {
        public _FinalStage orgId(@NotNull String var1);
    }

    public static interface UserIdStage {
        public OrgIdStage userId(@NotNull String var1);

        public Builder from(DecodedJwtWithOrgAndUserId var1);
    }
}

