/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LocationFeature;
import com.chrt.api.types.TrackingDeviceTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Device1 {
    private final int schemaVersion;
    private final String orgId;
    private final String deviceMacAddress;
    private final Optional<String> deviceToken;
    private final Optional<TrackingDeviceTypeEnum1> type;
    private final Optional<OffsetDateTime> registeredAtTimestamp;
    private final Optional<OffsetDateTime> firstSeenAtTimestamp;
    private final Optional<LocationFeature> lastSeenAtLocation;
    private final Optional<OffsetDateTime> lastSeenAtTimestamp;
    private final Optional<String> lastSeenBatteryLevel;
    private final Optional<String> sessionId;
    private final Optional<String> cargoId;
    private final Optional<String> comments;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private Device1(int schemaVersion, String orgId, String deviceMacAddress, Optional<String> deviceToken, Optional<TrackingDeviceTypeEnum1> type, Optional<OffsetDateTime> registeredAtTimestamp, Optional<OffsetDateTime> firstSeenAtTimestamp, Optional<LocationFeature> lastSeenAtLocation, Optional<OffsetDateTime> lastSeenAtTimestamp, Optional<String> lastSeenBatteryLevel, Optional<String> sessionId, Optional<String> cargoId, Optional<String> comments, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.orgId = orgId;
        this.deviceMacAddress = deviceMacAddress;
        this.deviceToken = deviceToken;
        this.type = type;
        this.registeredAtTimestamp = registeredAtTimestamp;
        this.firstSeenAtTimestamp = firstSeenAtTimestamp;
        this.lastSeenAtLocation = lastSeenAtLocation;
        this.lastSeenAtTimestamp = lastSeenAtTimestamp;
        this.lastSeenBatteryLevel = lastSeenBatteryLevel;
        this.sessionId = sessionId;
        this.cargoId = cargoId;
        this.comments = comments;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="org_id")
    public String getOrgId() {
        return this.orgId;
    }

    @JsonProperty(value="device_mac_address")
    public String getDeviceMacAddress() {
        return this.deviceMacAddress;
    }

    @JsonIgnore
    public Optional<String> getDeviceToken() {
        if (this.deviceToken == null) {
            return Optional.empty();
        }
        return this.deviceToken;
    }

    @JsonIgnore
    public Optional<TrackingDeviceTypeEnum1> getType() {
        if (this.type == null) {
            return Optional.empty();
        }
        return this.type;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getRegisteredAtTimestamp() {
        if (this.registeredAtTimestamp == null) {
            return Optional.empty();
        }
        return this.registeredAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getFirstSeenAtTimestamp() {
        if (this.firstSeenAtTimestamp == null) {
            return Optional.empty();
        }
        return this.firstSeenAtTimestamp;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLastSeenAtLocation() {
        if (this.lastSeenAtLocation == null) {
            return Optional.empty();
        }
        return this.lastSeenAtLocation;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenAtTimestamp() {
        if (this.lastSeenAtTimestamp == null) {
            return Optional.empty();
        }
        return this.lastSeenAtTimestamp;
    }

    @JsonIgnore
    public Optional<String> getLastSeenBatteryLevel() {
        if (this.lastSeenBatteryLevel == null) {
            return Optional.empty();
        }
        return this.lastSeenBatteryLevel;
    }

    @JsonIgnore
    public Optional<String> getSessionId() {
        if (this.sessionId == null) {
            return Optional.empty();
        }
        return this.sessionId;
    }

    @JsonIgnore
    public Optional<String> getCargoId() {
        if (this.cargoId == null) {
            return Optional.empty();
        }
        return this.cargoId;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (this.comments == null) {
            return Optional.empty();
        }
        return this.comments;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="device_token")
    private Optional<String> _getDeviceToken() {
        return this.deviceToken;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="type")
    private Optional<TrackingDeviceTypeEnum1> _getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="registered_at_timestamp")
    private Optional<OffsetDateTime> _getRegisteredAtTimestamp() {
        return this.registeredAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="first_seen_at_timestamp")
    private Optional<OffsetDateTime> _getFirstSeenAtTimestamp() {
        return this.firstSeenAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_seen_at_location")
    private Optional<LocationFeature> _getLastSeenAtLocation() {
        return this.lastSeenAtLocation;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_seen_at_timestamp")
    private Optional<OffsetDateTime> _getLastSeenAtTimestamp() {
        return this.lastSeenAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_seen_battery_level")
    private Optional<String> _getLastSeenBatteryLevel() {
        return this.lastSeenBatteryLevel;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="session_id")
    private Optional<String> _getSessionId() {
        return this.sessionId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cargo_id")
    private Optional<String> _getCargoId() {
        return this.cargoId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="comments")
    private Optional<String> _getComments() {
        return this.comments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Device1 && this.equalTo((Device1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Device1 other) {
        return this.schemaVersion == other.schemaVersion && this.orgId.equals(other.orgId) && this.deviceMacAddress.equals(other.deviceMacAddress) && this.deviceToken.equals(other.deviceToken) && this.type.equals(other.type) && this.registeredAtTimestamp.equals(other.registeredAtTimestamp) && this.firstSeenAtTimestamp.equals(other.firstSeenAtTimestamp) && this.lastSeenAtLocation.equals(other.lastSeenAtLocation) && this.lastSeenAtTimestamp.equals(other.lastSeenAtTimestamp) && this.lastSeenBatteryLevel.equals(other.lastSeenBatteryLevel) && this.sessionId.equals(other.sessionId) && this.cargoId.equals(other.cargoId) && this.comments.equals(other.comments) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.orgId, this.deviceMacAddress, this.deviceToken, this.type, this.registeredAtTimestamp, this.firstSeenAtTimestamp, this.lastSeenAtLocation, this.lastSeenAtTimestamp, this.lastSeenBatteryLevel, this.sessionId, this.cargoId, this.comments, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    OrgIdStage,
    DeviceMacAddressStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String orgId;
        private String deviceMacAddress;
        private String id;
        private Optional<String> comments = Optional.empty();
        private Optional<String> cargoId = Optional.empty();
        private Optional<String> sessionId = Optional.empty();
        private Optional<String> lastSeenBatteryLevel = Optional.empty();
        private Optional<OffsetDateTime> lastSeenAtTimestamp = Optional.empty();
        private Optional<LocationFeature> lastSeenAtLocation = Optional.empty();
        private Optional<OffsetDateTime> firstSeenAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> registeredAtTimestamp = Optional.empty();
        private Optional<TrackingDeviceTypeEnum1> type = Optional.empty();
        private Optional<String> deviceToken = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Device1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.orgId(other.getOrgId());
            this.deviceMacAddress(other.getDeviceMacAddress());
            this.deviceToken(other.getDeviceToken());
            this.type(other.getType());
            this.registeredAtTimestamp(other.getRegisteredAtTimestamp());
            this.firstSeenAtTimestamp(other.getFirstSeenAtTimestamp());
            this.lastSeenAtLocation(other.getLastSeenAtLocation());
            this.lastSeenAtTimestamp(other.getLastSeenAtTimestamp());
            this.lastSeenBatteryLevel(other.getLastSeenBatteryLevel());
            this.sessionId(other.getSessionId());
            this.cargoId(other.getCargoId());
            this.comments(other.getComments());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public OrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="org_id")
        public DeviceMacAddressStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="device_mac_address")
        public IdStage deviceMacAddress(@NotNull String deviceMacAddress) {
            this.deviceMacAddress = Objects.requireNonNull(deviceMacAddress, "deviceMacAddress must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage comments(Nullable<String> comments) {
            this.comments = comments.isNull() ? null : (comments.isEmpty() ? Optional.empty() : Optional.of(comments.get()));
            return this;
        }

        @Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @Override
        @JsonSetter(value="comments", nulls=Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public _FinalStage cargoId(Nullable<String> cargoId) {
            this.cargoId = cargoId.isNull() ? null : (cargoId.isEmpty() ? Optional.empty() : Optional.of(cargoId.get()));
            return this;
        }

        @Override
        public _FinalStage cargoId(String cargoId) {
            this.cargoId = Optional.ofNullable(cargoId);
            return this;
        }

        @Override
        @JsonSetter(value="cargo_id", nulls=Nulls.SKIP)
        public _FinalStage cargoId(Optional<String> cargoId) {
            this.cargoId = cargoId;
            return this;
        }

        @Override
        public _FinalStage sessionId(Nullable<String> sessionId) {
            this.sessionId = sessionId.isNull() ? null : (sessionId.isEmpty() ? Optional.empty() : Optional.of(sessionId.get()));
            return this;
        }

        @Override
        public _FinalStage sessionId(String sessionId) {
            this.sessionId = Optional.ofNullable(sessionId);
            return this;
        }

        @Override
        @JsonSetter(value="session_id", nulls=Nulls.SKIP)
        public _FinalStage sessionId(Optional<String> sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public _FinalStage lastSeenBatteryLevel(Nullable<String> lastSeenBatteryLevel) {
            this.lastSeenBatteryLevel = lastSeenBatteryLevel.isNull() ? null : (lastSeenBatteryLevel.isEmpty() ? Optional.empty() : Optional.of(lastSeenBatteryLevel.get()));
            return this;
        }

        @Override
        public _FinalStage lastSeenBatteryLevel(String lastSeenBatteryLevel) {
            this.lastSeenBatteryLevel = Optional.ofNullable(lastSeenBatteryLevel);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_battery_level", nulls=Nulls.SKIP)
        public _FinalStage lastSeenBatteryLevel(Optional<String> lastSeenBatteryLevel) {
            this.lastSeenBatteryLevel = lastSeenBatteryLevel;
            return this;
        }

        @Override
        public _FinalStage lastSeenAtTimestamp(Nullable<OffsetDateTime> lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = lastSeenAtTimestamp.isNull() ? null : (lastSeenAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(lastSeenAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage lastSeenAtTimestamp(OffsetDateTime lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = Optional.ofNullable(lastSeenAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAtTimestamp(Optional<OffsetDateTime> lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = lastSeenAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage lastSeenAtLocation(Nullable<LocationFeature> lastSeenAtLocation) {
            this.lastSeenAtLocation = lastSeenAtLocation.isNull() ? null : (lastSeenAtLocation.isEmpty() ? Optional.empty() : Optional.of(lastSeenAtLocation.get()));
            return this;
        }

        @Override
        public _FinalStage lastSeenAtLocation(LocationFeature lastSeenAtLocation) {
            this.lastSeenAtLocation = Optional.ofNullable(lastSeenAtLocation);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at_location", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAtLocation(Optional<LocationFeature> lastSeenAtLocation) {
            this.lastSeenAtLocation = lastSeenAtLocation;
            return this;
        }

        @Override
        public _FinalStage firstSeenAtTimestamp(Nullable<OffsetDateTime> firstSeenAtTimestamp) {
            this.firstSeenAtTimestamp = firstSeenAtTimestamp.isNull() ? null : (firstSeenAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(firstSeenAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage firstSeenAtTimestamp(OffsetDateTime firstSeenAtTimestamp) {
            this.firstSeenAtTimestamp = Optional.ofNullable(firstSeenAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="first_seen_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage firstSeenAtTimestamp(Optional<OffsetDateTime> firstSeenAtTimestamp) {
            this.firstSeenAtTimestamp = firstSeenAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage registeredAtTimestamp(Nullable<OffsetDateTime> registeredAtTimestamp) {
            this.registeredAtTimestamp = registeredAtTimestamp.isNull() ? null : (registeredAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(registeredAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage registeredAtTimestamp(OffsetDateTime registeredAtTimestamp) {
            this.registeredAtTimestamp = Optional.ofNullable(registeredAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="registered_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage registeredAtTimestamp(Optional<OffsetDateTime> registeredAtTimestamp) {
            this.registeredAtTimestamp = registeredAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage type(Nullable<TrackingDeviceTypeEnum1> type) {
            this.type = type.isNull() ? null : (type.isEmpty() ? Optional.empty() : Optional.of(type.get()));
            return this;
        }

        @Override
        public _FinalStage type(TrackingDeviceTypeEnum1 type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<TrackingDeviceTypeEnum1> type) {
            this.type = type;
            return this;
        }

        @Override
        public _FinalStage deviceToken(Nullable<String> deviceToken) {
            this.deviceToken = deviceToken.isNull() ? null : (deviceToken.isEmpty() ? Optional.empty() : Optional.of(deviceToken.get()));
            return this;
        }

        @Override
        public _FinalStage deviceToken(String deviceToken) {
            this.deviceToken = Optional.ofNullable(deviceToken);
            return this;
        }

        @Override
        @JsonSetter(value="device_token", nulls=Nulls.SKIP)
        public _FinalStage deviceToken(Optional<String> deviceToken) {
            this.deviceToken = deviceToken;
            return this;
        }

        @Override
        public Device1 build() {
            return new Device1(this.schemaVersion, this.orgId, this.deviceMacAddress, this.deviceToken, this.type, this.registeredAtTimestamp, this.firstSeenAtTimestamp, this.lastSeenAtLocation, this.lastSeenAtTimestamp, this.lastSeenBatteryLevel, this.sessionId, this.cargoId, this.comments, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Device1 build();

        public _FinalStage deviceToken(Optional<String> var1);

        public _FinalStage deviceToken(String var1);

        public _FinalStage deviceToken(Nullable<String> var1);

        public _FinalStage type(Optional<TrackingDeviceTypeEnum1> var1);

        public _FinalStage type(TrackingDeviceTypeEnum1 var1);

        public _FinalStage type(Nullable<TrackingDeviceTypeEnum1> var1);

        public _FinalStage registeredAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage registeredAtTimestamp(OffsetDateTime var1);

        public _FinalStage registeredAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage firstSeenAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage firstSeenAtTimestamp(OffsetDateTime var1);

        public _FinalStage firstSeenAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage lastSeenAtLocation(Optional<LocationFeature> var1);

        public _FinalStage lastSeenAtLocation(LocationFeature var1);

        public _FinalStage lastSeenAtLocation(Nullable<LocationFeature> var1);

        public _FinalStage lastSeenAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage lastSeenAtTimestamp(OffsetDateTime var1);

        public _FinalStage lastSeenAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage lastSeenBatteryLevel(Optional<String> var1);

        public _FinalStage lastSeenBatteryLevel(String var1);

        public _FinalStage lastSeenBatteryLevel(Nullable<String> var1);

        public _FinalStage sessionId(Optional<String> var1);

        public _FinalStage sessionId(String var1);

        public _FinalStage sessionId(Nullable<String> var1);

        public _FinalStage cargoId(Optional<String> var1);

        public _FinalStage cargoId(String var1);

        public _FinalStage cargoId(Nullable<String> var1);

        public _FinalStage comments(Optional<String> var1);

        public _FinalStage comments(String var1);

        public _FinalStage comments(Nullable<String> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface DeviceMacAddressStage {
        public IdStage deviceMacAddress(@NotNull String var1);
    }

    public static interface OrgIdStage {
        public DeviceMacAddressStage orgId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public OrgIdStage schemaVersion(int var1);

        public Builder from(Device1 var1);
    }
}

