/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.DriverStatusEnum;
import com.chrt.api.types.LocationFeature;
import com.chrt.api.types.VehicleTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Driver1 {
    private final int schemaVersion;
    private final Optional<String> emailAddressPrimary;
    private final Optional<String> emailAddressSecondary;
    private final Optional<String> phoneNumberPrimary;
    private final Optional<String> phoneNumberSecondary;
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final Optional<List<VehicleTypeEnum>> vehicleTypes;
    private final String id;
    private final String orgId;
    private final String userId;
    private final Optional<DriverStatusEnum> status;
    private final Optional<Boolean> availableAccordingToDriver;
    private final Optional<Boolean> availableAccordingToOperators;
    private final Optional<List<String>> activeTaskGroupIds;
    private final Optional<LocationFeature> lastSeenAtLocation;
    private final Optional<OffsetDateTime> lastSeenAtTimestamp;
    private final Optional<String> defaultRateSheetRouted;
    private final Optional<String> defaultRateSheetOnDemand;
    private final Map<String, Object> additionalProperties;

    private Driver1(int schemaVersion, Optional<String> emailAddressPrimary, Optional<String> emailAddressSecondary, Optional<String> phoneNumberPrimary, Optional<String> phoneNumberSecondary, Optional<String> firstName, Optional<String> lastName, Optional<List<VehicleTypeEnum>> vehicleTypes, String id, String orgId, String userId, Optional<DriverStatusEnum> status, Optional<Boolean> availableAccordingToDriver, Optional<Boolean> availableAccordingToOperators, Optional<List<String>> activeTaskGroupIds, Optional<LocationFeature> lastSeenAtLocation, Optional<OffsetDateTime> lastSeenAtTimestamp, Optional<String> defaultRateSheetRouted, Optional<String> defaultRateSheetOnDemand, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.emailAddressPrimary = emailAddressPrimary;
        this.emailAddressSecondary = emailAddressSecondary;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.phoneNumberSecondary = phoneNumberSecondary;
        this.firstName = firstName;
        this.lastName = lastName;
        this.vehicleTypes = vehicleTypes;
        this.id = id;
        this.orgId = orgId;
        this.userId = userId;
        this.status = status;
        this.availableAccordingToDriver = availableAccordingToDriver;
        this.availableAccordingToOperators = availableAccordingToOperators;
        this.activeTaskGroupIds = activeTaskGroupIds;
        this.lastSeenAtLocation = lastSeenAtLocation;
        this.lastSeenAtTimestamp = lastSeenAtTimestamp;
        this.defaultRateSheetRouted = defaultRateSheetRouted;
        this.defaultRateSheetOnDemand = defaultRateSheetOnDemand;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressPrimary() {
        if (this.emailAddressPrimary == null) {
            return Optional.empty();
        }
        return this.emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressSecondary() {
        if (this.emailAddressSecondary == null) {
            return Optional.empty();
        }
        return this.emailAddressSecondary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (this.phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return this.phoneNumberPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberSecondary() {
        if (this.phoneNumberSecondary == null) {
            return Optional.empty();
        }
        return this.phoneNumberSecondary;
    }

    @JsonIgnore
    public Optional<String> getFirstName() {
        if (this.firstName == null) {
            return Optional.empty();
        }
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> getLastName() {
        if (this.lastName == null) {
            return Optional.empty();
        }
        return this.lastName;
    }

    @JsonProperty(value="vehicle_types")
    public Optional<List<VehicleTypeEnum>> getVehicleTypes() {
        return this.vehicleTypes;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="org_id")
    public String getOrgId() {
        return this.orgId;
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="status")
    public Optional<DriverStatusEnum> getStatus() {
        return this.status;
    }

    @JsonProperty(value="available_according_to_driver")
    public Optional<Boolean> getAvailableAccordingToDriver() {
        return this.availableAccordingToDriver;
    }

    @JsonProperty(value="available_according_to_operators")
    public Optional<Boolean> getAvailableAccordingToOperators() {
        return this.availableAccordingToOperators;
    }

    @JsonProperty(value="active_task_group_ids")
    public Optional<List<String>> getActiveTaskGroupIds() {
        return this.activeTaskGroupIds;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLastSeenAtLocation() {
        if (this.lastSeenAtLocation == null) {
            return Optional.empty();
        }
        return this.lastSeenAtLocation;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenAtTimestamp() {
        if (this.lastSeenAtTimestamp == null) {
            return Optional.empty();
        }
        return this.lastSeenAtTimestamp;
    }

    @JsonIgnore
    public Optional<String> getDefaultRateSheetRouted() {
        if (this.defaultRateSheetRouted == null) {
            return Optional.empty();
        }
        return this.defaultRateSheetRouted;
    }

    @JsonIgnore
    public Optional<String> getDefaultRateSheetOnDemand() {
        if (this.defaultRateSheetOnDemand == null) {
            return Optional.empty();
        }
        return this.defaultRateSheetOnDemand;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address_primary")
    private Optional<String> _getEmailAddressPrimary() {
        return this.emailAddressPrimary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address_secondary")
    private Optional<String> _getEmailAddressSecondary() {
        return this.emailAddressSecondary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return this.phoneNumberPrimary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number_secondary")
    private Optional<String> _getPhoneNumberSecondary() {
        return this.phoneNumberSecondary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="first_name")
    private Optional<String> _getFirstName() {
        return this.firstName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_name")
    private Optional<String> _getLastName() {
        return this.lastName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_seen_at_location")
    private Optional<LocationFeature> _getLastSeenAtLocation() {
        return this.lastSeenAtLocation;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_seen_at_timestamp")
    private Optional<OffsetDateTime> _getLastSeenAtTimestamp() {
        return this.lastSeenAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="default_rate_sheet__routed")
    private Optional<String> _getDefaultRateSheetRouted() {
        return this.defaultRateSheetRouted;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="default_rate_sheet__on_demand")
    private Optional<String> _getDefaultRateSheetOnDemand() {
        return this.defaultRateSheetOnDemand;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Driver1 && this.equalTo((Driver1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Driver1 other) {
        return this.schemaVersion == other.schemaVersion && this.emailAddressPrimary.equals(other.emailAddressPrimary) && this.emailAddressSecondary.equals(other.emailAddressSecondary) && this.phoneNumberPrimary.equals(other.phoneNumberPrimary) && this.phoneNumberSecondary.equals(other.phoneNumberSecondary) && this.firstName.equals(other.firstName) && this.lastName.equals(other.lastName) && this.vehicleTypes.equals(other.vehicleTypes) && this.id.equals(other.id) && this.orgId.equals(other.orgId) && this.userId.equals(other.userId) && this.status.equals(other.status) && this.availableAccordingToDriver.equals(other.availableAccordingToDriver) && this.availableAccordingToOperators.equals(other.availableAccordingToOperators) && this.activeTaskGroupIds.equals(other.activeTaskGroupIds) && this.lastSeenAtLocation.equals(other.lastSeenAtLocation) && this.lastSeenAtTimestamp.equals(other.lastSeenAtTimestamp) && this.defaultRateSheetRouted.equals(other.defaultRateSheetRouted) && this.defaultRateSheetOnDemand.equals(other.defaultRateSheetOnDemand);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.emailAddressPrimary, this.emailAddressSecondary, this.phoneNumberPrimary, this.phoneNumberSecondary, this.firstName, this.lastName, this.vehicleTypes, this.id, this.orgId, this.userId, this.status, this.availableAccordingToDriver, this.availableAccordingToOperators, this.activeTaskGroupIds, this.lastSeenAtLocation, this.lastSeenAtTimestamp, this.defaultRateSheetRouted, this.defaultRateSheetOnDemand);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    IdStage,
    OrgIdStage,
    UserIdStage,
    _FinalStage {
        private int schemaVersion;
        private String id;
        private String orgId;
        private String userId;
        private Optional<String> defaultRateSheetOnDemand = Optional.empty();
        private Optional<String> defaultRateSheetRouted = Optional.empty();
        private Optional<OffsetDateTime> lastSeenAtTimestamp = Optional.empty();
        private Optional<LocationFeature> lastSeenAtLocation = Optional.empty();
        private Optional<List<String>> activeTaskGroupIds = Optional.empty();
        private Optional<Boolean> availableAccordingToOperators = Optional.empty();
        private Optional<Boolean> availableAccordingToDriver = Optional.empty();
        private Optional<DriverStatusEnum> status = Optional.empty();
        private Optional<List<VehicleTypeEnum>> vehicleTypes = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        private Optional<String> phoneNumberSecondary = Optional.empty();
        private Optional<String> phoneNumberPrimary = Optional.empty();
        private Optional<String> emailAddressSecondary = Optional.empty();
        private Optional<String> emailAddressPrimary = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Driver1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.emailAddressPrimary(other.getEmailAddressPrimary());
            this.emailAddressSecondary(other.getEmailAddressSecondary());
            this.phoneNumberPrimary(other.getPhoneNumberPrimary());
            this.phoneNumberSecondary(other.getPhoneNumberSecondary());
            this.firstName(other.getFirstName());
            this.lastName(other.getLastName());
            this.vehicleTypes(other.getVehicleTypes());
            this.id(other.getId());
            this.orgId(other.getOrgId());
            this.userId(other.getUserId());
            this.status(other.getStatus());
            this.availableAccordingToDriver(other.getAvailableAccordingToDriver());
            this.availableAccordingToOperators(other.getAvailableAccordingToOperators());
            this.activeTaskGroupIds(other.getActiveTaskGroupIds());
            this.lastSeenAtLocation(other.getLastSeenAtLocation());
            this.lastSeenAtTimestamp(other.getLastSeenAtTimestamp());
            this.defaultRateSheetRouted(other.getDefaultRateSheetRouted());
            this.defaultRateSheetOnDemand(other.getDefaultRateSheetOnDemand());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public OrgIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="org_id")
        public UserIdStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetOnDemand(Nullable<String> defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = defaultRateSheetOnDemand.isNull() ? null : (defaultRateSheetOnDemand.isEmpty() ? Optional.empty() : Optional.of(defaultRateSheetOnDemand.get()));
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetOnDemand(String defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = Optional.ofNullable(defaultRateSheetOnDemand);
            return this;
        }

        @Override
        @JsonSetter(value="default_rate_sheet__on_demand", nulls=Nulls.SKIP)
        public _FinalStage defaultRateSheetOnDemand(Optional<String> defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = defaultRateSheetOnDemand;
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetRouted(Nullable<String> defaultRateSheetRouted) {
            this.defaultRateSheetRouted = defaultRateSheetRouted.isNull() ? null : (defaultRateSheetRouted.isEmpty() ? Optional.empty() : Optional.of(defaultRateSheetRouted.get()));
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetRouted(String defaultRateSheetRouted) {
            this.defaultRateSheetRouted = Optional.ofNullable(defaultRateSheetRouted);
            return this;
        }

        @Override
        @JsonSetter(value="default_rate_sheet__routed", nulls=Nulls.SKIP)
        public _FinalStage defaultRateSheetRouted(Optional<String> defaultRateSheetRouted) {
            this.defaultRateSheetRouted = defaultRateSheetRouted;
            return this;
        }

        @Override
        public _FinalStage lastSeenAtTimestamp(Nullable<OffsetDateTime> lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = lastSeenAtTimestamp.isNull() ? null : (lastSeenAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(lastSeenAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage lastSeenAtTimestamp(OffsetDateTime lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = Optional.ofNullable(lastSeenAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAtTimestamp(Optional<OffsetDateTime> lastSeenAtTimestamp) {
            this.lastSeenAtTimestamp = lastSeenAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage lastSeenAtLocation(Nullable<LocationFeature> lastSeenAtLocation) {
            this.lastSeenAtLocation = lastSeenAtLocation.isNull() ? null : (lastSeenAtLocation.isEmpty() ? Optional.empty() : Optional.of(lastSeenAtLocation.get()));
            return this;
        }

        @Override
        public _FinalStage lastSeenAtLocation(LocationFeature lastSeenAtLocation) {
            this.lastSeenAtLocation = Optional.ofNullable(lastSeenAtLocation);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at_location", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAtLocation(Optional<LocationFeature> lastSeenAtLocation) {
            this.lastSeenAtLocation = lastSeenAtLocation;
            return this;
        }

        @Override
        public _FinalStage activeTaskGroupIds(List<String> activeTaskGroupIds) {
            this.activeTaskGroupIds = Optional.ofNullable(activeTaskGroupIds);
            return this;
        }

        @Override
        @JsonSetter(value="active_task_group_ids", nulls=Nulls.SKIP)
        public _FinalStage activeTaskGroupIds(Optional<List<String>> activeTaskGroupIds) {
            this.activeTaskGroupIds = activeTaskGroupIds;
            return this;
        }

        @Override
        public _FinalStage availableAccordingToOperators(Boolean availableAccordingToOperators) {
            this.availableAccordingToOperators = Optional.ofNullable(availableAccordingToOperators);
            return this;
        }

        @Override
        @JsonSetter(value="available_according_to_operators", nulls=Nulls.SKIP)
        public _FinalStage availableAccordingToOperators(Optional<Boolean> availableAccordingToOperators) {
            this.availableAccordingToOperators = availableAccordingToOperators;
            return this;
        }

        @Override
        public _FinalStage availableAccordingToDriver(Boolean availableAccordingToDriver) {
            this.availableAccordingToDriver = Optional.ofNullable(availableAccordingToDriver);
            return this;
        }

        @Override
        @JsonSetter(value="available_according_to_driver", nulls=Nulls.SKIP)
        public _FinalStage availableAccordingToDriver(Optional<Boolean> availableAccordingToDriver) {
            this.availableAccordingToDriver = availableAccordingToDriver;
            return this;
        }

        @Override
        public _FinalStage status(DriverStatusEnum status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<DriverStatusEnum> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage vehicleTypes(List<VehicleTypeEnum> vehicleTypes) {
            this.vehicleTypes = Optional.ofNullable(vehicleTypes);
            return this;
        }

        @Override
        @JsonSetter(value="vehicle_types", nulls=Nulls.SKIP)
        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> vehicleTypes) {
            this.vehicleTypes = vehicleTypes;
            return this;
        }

        @Override
        public _FinalStage lastName(Nullable<String> lastName) {
            this.lastName = lastName.isNull() ? null : (lastName.isEmpty() ? Optional.empty() : Optional.of(lastName.get()));
            return this;
        }

        @Override
        public _FinalStage lastName(String lastName) {
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        @Override
        @JsonSetter(value="last_name", nulls=Nulls.SKIP)
        public _FinalStage lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        @Override
        public _FinalStage firstName(Nullable<String> firstName) {
            this.firstName = firstName.isNull() ? null : (firstName.isEmpty() ? Optional.empty() : Optional.of(firstName.get()));
            return this;
        }

        @Override
        public _FinalStage firstName(String firstName) {
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        @Override
        @JsonSetter(value="first_name", nulls=Nulls.SKIP)
        public _FinalStage firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        @Override
        public _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary.isNull() ? null : (phoneNumberSecondary.isEmpty() ? Optional.empty() : Optional.of(phoneNumberSecondary.get()));
            return this;
        }

        @Override
        public _FinalStage phoneNumberSecondary(String phoneNumberSecondary) {
            this.phoneNumberSecondary = Optional.ofNullable(phoneNumberSecondary);
            return this;
        }

        @Override
        @JsonSetter(value="phone_number_secondary", nulls=Nulls.SKIP)
        public _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary;
            return this;
        }

        @Override
        public _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary.isNull() ? null : (phoneNumberPrimary.isEmpty() ? Optional.empty() : Optional.of(phoneNumberPrimary.get()));
            return this;
        }

        @Override
        public _FinalStage phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        @Override
        @JsonSetter(value="phone_number_primary", nulls=Nulls.SKIP)
        public _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        @Override
        public _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary.isNull() ? null : (emailAddressSecondary.isEmpty() ? Optional.empty() : Optional.of(emailAddressSecondary.get()));
            return this;
        }

        @Override
        public _FinalStage emailAddressSecondary(String emailAddressSecondary) {
            this.emailAddressSecondary = Optional.ofNullable(emailAddressSecondary);
            return this;
        }

        @Override
        @JsonSetter(value="email_address_secondary", nulls=Nulls.SKIP)
        public _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary;
            return this;
        }

        @Override
        public _FinalStage emailAddressPrimary(Nullable<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary.isNull() ? null : (emailAddressPrimary.isEmpty() ? Optional.empty() : Optional.of(emailAddressPrimary.get()));
            return this;
        }

        @Override
        public _FinalStage emailAddressPrimary(String emailAddressPrimary) {
            this.emailAddressPrimary = Optional.ofNullable(emailAddressPrimary);
            return this;
        }

        @Override
        @JsonSetter(value="email_address_primary", nulls=Nulls.SKIP)
        public _FinalStage emailAddressPrimary(Optional<String> emailAddressPrimary) {
            this.emailAddressPrimary = emailAddressPrimary;
            return this;
        }

        @Override
        public Driver1 build() {
            return new Driver1(this.schemaVersion, this.emailAddressPrimary, this.emailAddressSecondary, this.phoneNumberPrimary, this.phoneNumberSecondary, this.firstName, this.lastName, this.vehicleTypes, this.id, this.orgId, this.userId, this.status, this.availableAccordingToDriver, this.availableAccordingToOperators, this.activeTaskGroupIds, this.lastSeenAtLocation, this.lastSeenAtTimestamp, this.defaultRateSheetRouted, this.defaultRateSheetOnDemand, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Driver1 build();

        public _FinalStage emailAddressPrimary(Optional<String> var1);

        public _FinalStage emailAddressPrimary(String var1);

        public _FinalStage emailAddressPrimary(Nullable<String> var1);

        public _FinalStage emailAddressSecondary(Optional<String> var1);

        public _FinalStage emailAddressSecondary(String var1);

        public _FinalStage emailAddressSecondary(Nullable<String> var1);

        public _FinalStage phoneNumberPrimary(Optional<String> var1);

        public _FinalStage phoneNumberPrimary(String var1);

        public _FinalStage phoneNumberPrimary(Nullable<String> var1);

        public _FinalStage phoneNumberSecondary(Optional<String> var1);

        public _FinalStage phoneNumberSecondary(String var1);

        public _FinalStage phoneNumberSecondary(Nullable<String> var1);

        public _FinalStage firstName(Optional<String> var1);

        public _FinalStage firstName(String var1);

        public _FinalStage firstName(Nullable<String> var1);

        public _FinalStage lastName(Optional<String> var1);

        public _FinalStage lastName(String var1);

        public _FinalStage lastName(Nullable<String> var1);

        public _FinalStage vehicleTypes(Optional<List<VehicleTypeEnum>> var1);

        public _FinalStage vehicleTypes(List<VehicleTypeEnum> var1);

        public _FinalStage status(Optional<DriverStatusEnum> var1);

        public _FinalStage status(DriverStatusEnum var1);

        public _FinalStage availableAccordingToDriver(Optional<Boolean> var1);

        public _FinalStage availableAccordingToDriver(Boolean var1);

        public _FinalStage availableAccordingToOperators(Optional<Boolean> var1);

        public _FinalStage availableAccordingToOperators(Boolean var1);

        public _FinalStage activeTaskGroupIds(Optional<List<String>> var1);

        public _FinalStage activeTaskGroupIds(List<String> var1);

        public _FinalStage lastSeenAtLocation(Optional<LocationFeature> var1);

        public _FinalStage lastSeenAtLocation(LocationFeature var1);

        public _FinalStage lastSeenAtLocation(Nullable<LocationFeature> var1);

        public _FinalStage lastSeenAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage lastSeenAtTimestamp(OffsetDateTime var1);

        public _FinalStage lastSeenAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage defaultRateSheetRouted(Optional<String> var1);

        public _FinalStage defaultRateSheetRouted(String var1);

        public _FinalStage defaultRateSheetRouted(Nullable<String> var1);

        public _FinalStage defaultRateSheetOnDemand(Optional<String> var1);

        public _FinalStage defaultRateSheetOnDemand(String var1);

        public _FinalStage defaultRateSheetOnDemand(Nullable<String> var1);
    }

    public static interface UserIdStage {
        public _FinalStage userId(@NotNull String var1);
    }

    public static interface OrgIdStage {
        public UserIdStage orgId(@NotNull String var1);
    }

    public static interface IdStage {
        public OrgIdStage id(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public IdStage schemaVersion(int var1);

        public Builder from(Driver1 var1);
    }
}

