/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.GeometryCollectionOutputGeometriesItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GeometryCollection {
    private final Optional<List<Object>> bbox;
    private final List<GeometryCollectionOutputGeometriesItem> geometries;
    private final Map<String, Object> additionalProperties;

    private GeometryCollection(Optional<List<Object>> bbox, List<GeometryCollectionOutputGeometriesItem> geometries, Map<String, Object> additionalProperties) {
        this.bbox = bbox;
        this.geometries = geometries;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Object>> getBbox() {
        if (this.bbox == null) {
            return Optional.empty();
        }
        return this.bbox;
    }

    @JsonProperty(value="geometries")
    public List<GeometryCollectionOutputGeometriesItem> getGeometries() {
        return this.geometries;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="bbox")
    private Optional<List<Object>> _getBbox() {
        return this.bbox;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GeometryCollection && this.equalTo((GeometryCollection)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GeometryCollection other) {
        return this.bbox.equals(other.bbox) && this.geometries.equals(other.geometries);
    }

    public int hashCode() {
        return Objects.hash(this.bbox, this.geometries);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Object>> bbox = Optional.empty();
        private List<GeometryCollectionOutputGeometriesItem> geometries = new ArrayList<GeometryCollectionOutputGeometriesItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GeometryCollection other) {
            this.bbox(other.getBbox());
            this.geometries(other.getGeometries());
            return this;
        }

        @JsonSetter(value="bbox", nulls=Nulls.SKIP)
        public Builder bbox(Optional<List<Object>> bbox) {
            this.bbox = bbox;
            return this;
        }

        public Builder bbox(List<Object> bbox) {
            this.bbox = Optional.ofNullable(bbox);
            return this;
        }

        public Builder bbox(Nullable<List<Object>> bbox) {
            this.bbox = bbox.isNull() ? null : (bbox.isEmpty() ? Optional.empty() : Optional.of(bbox.get()));
            return this;
        }

        @JsonSetter(value="geometries", nulls=Nulls.SKIP)
        public Builder geometries(List<GeometryCollectionOutputGeometriesItem> geometries) {
            this.geometries.clear();
            if (geometries != null) {
                this.geometries.addAll(geometries);
            }
            return this;
        }

        public Builder addGeometries(GeometryCollectionOutputGeometriesItem geometries) {
            this.geometries.add(geometries);
            return this;
        }

        public Builder addAllGeometries(List<GeometryCollectionOutputGeometriesItem> geometries) {
            if (geometries != null) {
                this.geometries.addAll(geometries);
            }
            return this;
        }

        public GeometryCollection build() {
            return new GeometryCollection(this.bbox, this.geometries, this.additionalProperties);
        }
    }
}

