/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.types.GeometryCollection;
import com.chrt.api.types.LineString;
import com.chrt.api.types.MultiLineString;
import com.chrt.api.types.MultiPoint;
import com.chrt.api.types.MultiPolygon;
import com.chrt.api.types.Point;
import com.chrt.api.types.Polygon;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class GeometryCollectionInputGeometriesItem {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private GeometryCollectionInputGeometriesItem(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static GeometryCollectionInputGeometriesItem geometryCollection(GeometryCollection value) {
        return new GeometryCollectionInputGeometriesItem(new GeometryCollectionValue(value));
    }

    public static GeometryCollectionInputGeometriesItem lineString(LineString value) {
        return new GeometryCollectionInputGeometriesItem(new LineStringValue(value));
    }

    public static GeometryCollectionInputGeometriesItem multiLineString(MultiLineString value) {
        return new GeometryCollectionInputGeometriesItem(new MultiLineStringValue(value));
    }

    public static GeometryCollectionInputGeometriesItem multiPoint(MultiPoint value) {
        return new GeometryCollectionInputGeometriesItem(new MultiPointValue(value));
    }

    public static GeometryCollectionInputGeometriesItem multiPolygon(MultiPolygon value) {
        return new GeometryCollectionInputGeometriesItem(new MultiPolygonValue(value));
    }

    public static GeometryCollectionInputGeometriesItem point(Point value) {
        return new GeometryCollectionInputGeometriesItem(new PointValue(value));
    }

    public static GeometryCollectionInputGeometriesItem polygon(Polygon value) {
        return new GeometryCollectionInputGeometriesItem(new PolygonValue(value));
    }

    public boolean isGeometryCollection() {
        return this.value instanceof GeometryCollectionValue;
    }

    public boolean isLineString() {
        return this.value instanceof LineStringValue;
    }

    public boolean isMultiLineString() {
        return this.value instanceof MultiLineStringValue;
    }

    public boolean isMultiPoint() {
        return this.value instanceof MultiPointValue;
    }

    public boolean isMultiPolygon() {
        return this.value instanceof MultiPolygonValue;
    }

    public boolean isPoint() {
        return this.value instanceof PointValue;
    }

    public boolean isPolygon() {
        return this.value instanceof PolygonValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<GeometryCollection> getGeometryCollection() {
        if (this.isGeometryCollection()) {
            return Optional.of(((GeometryCollectionValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<LineString> getLineString() {
        if (this.isLineString()) {
            return Optional.of(((LineStringValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<MultiLineString> getMultiLineString() {
        if (this.isMultiLineString()) {
            return Optional.of(((MultiLineStringValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<MultiPoint> getMultiPoint() {
        if (this.isMultiPoint()) {
            return Optional.of(((MultiPointValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<MultiPolygon> getMultiPolygon() {
        if (this.isMultiPolygon()) {
            return Optional.of(((MultiPolygonValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Point> getPoint() {
        if (this.isPoint()) {
            return Optional.of(((PointValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Polygon> getPolygon() {
        if (this.isPolygon()) {
            return Optional.of(((PolygonValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "GeometryCollectionInputGeometriesItem{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="Polygon")
    @JsonIgnoreProperties(value={"type"})
    private static final class PolygonValue
    implements Value {
        @JsonUnwrapped
        private Polygon value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private PolygonValue() {
        }

        private PolygonValue(Polygon value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitPolygon(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof PolygonValue && this.equalTo((PolygonValue)other);
        }

        private boolean equalTo(PolygonValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GeometryCollectionInputGeometriesItem{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="Point")
    @JsonIgnoreProperties(value={"type"})
    private static final class PointValue
    implements Value {
        @JsonUnwrapped
        private Point value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private PointValue() {
        }

        private PointValue(Point value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitPoint(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof PointValue && this.equalTo((PointValue)other);
        }

        private boolean equalTo(PointValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GeometryCollectionInputGeometriesItem{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="MultiPolygon")
    @JsonIgnoreProperties(value={"type"})
    private static final class MultiPolygonValue
    implements Value {
        @JsonUnwrapped
        private MultiPolygon value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private MultiPolygonValue() {
        }

        private MultiPolygonValue(MultiPolygon value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitMultiPolygon(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof MultiPolygonValue && this.equalTo((MultiPolygonValue)other);
        }

        private boolean equalTo(MultiPolygonValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GeometryCollectionInputGeometriesItem{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="MultiPoint")
    @JsonIgnoreProperties(value={"type"})
    private static final class MultiPointValue
    implements Value {
        @JsonUnwrapped
        private MultiPoint value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private MultiPointValue() {
        }

        private MultiPointValue(MultiPoint value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitMultiPoint(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof MultiPointValue && this.equalTo((MultiPointValue)other);
        }

        private boolean equalTo(MultiPointValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GeometryCollectionInputGeometriesItem{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="MultiLineString")
    @JsonIgnoreProperties(value={"type"})
    private static final class MultiLineStringValue
    implements Value {
        @JsonUnwrapped
        private MultiLineString value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private MultiLineStringValue() {
        }

        private MultiLineStringValue(MultiLineString value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitMultiLineString(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof MultiLineStringValue && this.equalTo((MultiLineStringValue)other);
        }

        private boolean equalTo(MultiLineStringValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GeometryCollectionInputGeometriesItem{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="LineString")
    @JsonIgnoreProperties(value={"type"})
    private static final class LineStringValue
    implements Value {
        @JsonUnwrapped
        private LineString value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private LineStringValue() {
        }

        private LineStringValue(LineString value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitLineString(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof LineStringValue && this.equalTo((LineStringValue)other);
        }

        private boolean equalTo(LineStringValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GeometryCollectionInputGeometriesItem{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="GeometryCollection")
    @JsonIgnoreProperties(value={"type"})
    private static final class GeometryCollectionValue
    implements Value {
        @JsonUnwrapped
        private GeometryCollection value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private GeometryCollectionValue() {
        }

        private GeometryCollectionValue(GeometryCollection value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitGeometryCollection(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof GeometryCollectionValue && this.equalTo((GeometryCollectionValue)other);
        }

        private boolean equalTo(GeometryCollectionValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "GeometryCollectionInputGeometriesItem{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=GeometryCollectionValue.class), @JsonSubTypes.Type(value=LineStringValue.class), @JsonSubTypes.Type(value=MultiLineStringValue.class), @JsonSubTypes.Type(value=MultiPointValue.class), @JsonSubTypes.Type(value=MultiPolygonValue.class), @JsonSubTypes.Type(value=PointValue.class), @JsonSubTypes.Type(value=PolygonValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitGeometryCollection(GeometryCollection var1);

        public T visitLineString(LineString var1);

        public T visitMultiLineString(MultiLineString var1);

        public T visitMultiPoint(MultiPoint var1);

        public T visitMultiPolygon(MultiPolygon var1);

        public T visitPoint(Point var1);

        public T visitPolygon(Polygon var1);

        public T _visitUnknown(Object var1);
    }
}

