/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItemEnum1;
import com.chrt.api.types.UnitsEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LineItem1 {
    private final Optional<Integer> schemaVersion;
    private final LineItemEnum1 item;
    private final double quantity;
    private final double rate;
    private final Optional<UnitsEnum> units;
    private final Optional<String> comments;
    private final Optional<Double> adjustment;
    private final Optional<String> adjustmentComments;
    private final Optional<OffsetDateTime> createdAtTimestamp;
    private final Optional<String> uuidStr;
    private final double amount;
    private final Map<String, Object> additionalProperties;

    private LineItem1(Optional<Integer> schemaVersion, LineItemEnum1 item, double quantity, double rate, Optional<UnitsEnum> units, Optional<String> comments, Optional<Double> adjustment, Optional<String> adjustmentComments, Optional<OffsetDateTime> createdAtTimestamp, Optional<String> uuidStr, double amount, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.item = item;
        this.quantity = quantity;
        this.rate = rate;
        this.units = units;
        this.comments = comments;
        this.adjustment = adjustment;
        this.adjustmentComments = adjustmentComments;
        this.createdAtTimestamp = createdAtTimestamp;
        this.uuidStr = uuidStr;
        this.amount = amount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public Optional<Integer> getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="item")
    public LineItemEnum1 getItem() {
        return this.item;
    }

    @JsonProperty(value="quantity")
    public double getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="rate")
    public double getRate() {
        return this.rate;
    }

    @JsonProperty(value="units")
    public Optional<UnitsEnum> getUnits() {
        return this.units;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (this.comments == null) {
            return Optional.empty();
        }
        return this.comments;
    }

    @JsonIgnore
    public Optional<Double> getAdjustment() {
        if (this.adjustment == null) {
            return Optional.empty();
        }
        return this.adjustment;
    }

    @JsonIgnore
    public Optional<String> getAdjustmentComments() {
        if (this.adjustmentComments == null) {
            return Optional.empty();
        }
        return this.adjustmentComments;
    }

    @JsonProperty(value="created_at_timestamp")
    public Optional<OffsetDateTime> getCreatedAtTimestamp() {
        return this.createdAtTimestamp;
    }

    @JsonProperty(value="uuid_str")
    public Optional<String> getUuidStr() {
        return this.uuidStr;
    }

    @JsonProperty(value="amount")
    public double getAmount() {
        return this.amount;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="comments")
    private Optional<String> _getComments() {
        return this.comments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="adjustment")
    private Optional<Double> _getAdjustment() {
        return this.adjustment;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="adjustment_comments")
    private Optional<String> _getAdjustmentComments() {
        return this.adjustmentComments;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LineItem1 && this.equalTo((LineItem1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LineItem1 other) {
        return this.schemaVersion.equals(other.schemaVersion) && this.item.equals(other.item) && this.quantity == other.quantity && this.rate == other.rate && this.units.equals(other.units) && this.comments.equals(other.comments) && this.adjustment.equals(other.adjustment) && this.adjustmentComments.equals(other.adjustmentComments) && this.createdAtTimestamp.equals(other.createdAtTimestamp) && this.uuidStr.equals(other.uuidStr) && this.amount == other.amount;
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.item, this.quantity, this.rate, this.units, this.comments, this.adjustment, this.adjustmentComments, this.createdAtTimestamp, this.uuidStr, this.amount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ItemStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ItemStage,
    QuantityStage,
    RateStage,
    AmountStage,
    _FinalStage {
        private LineItemEnum1 item;
        private double quantity;
        private double rate;
        private double amount;
        private Optional<String> uuidStr = Optional.empty();
        private Optional<OffsetDateTime> createdAtTimestamp = Optional.empty();
        private Optional<String> adjustmentComments = Optional.empty();
        private Optional<Double> adjustment = Optional.empty();
        private Optional<String> comments = Optional.empty();
        private Optional<UnitsEnum> units = Optional.empty();
        private Optional<Integer> schemaVersion = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LineItem1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.item(other.getItem());
            this.quantity(other.getQuantity());
            this.rate(other.getRate());
            this.units(other.getUnits());
            this.comments(other.getComments());
            this.adjustment(other.getAdjustment());
            this.adjustmentComments(other.getAdjustmentComments());
            this.createdAtTimestamp(other.getCreatedAtTimestamp());
            this.uuidStr(other.getUuidStr());
            this.amount(other.getAmount());
            return this;
        }

        @Override
        @JsonSetter(value="item")
        public QuantityStage item(@NotNull LineItemEnum1 item) {
            this.item = Objects.requireNonNull(item, "item must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public RateStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="rate")
        public AmountStage rate(double rate) {
            this.rate = rate;
            return this;
        }

        @Override
        @JsonSetter(value="amount")
        public _FinalStage amount(double amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public _FinalStage uuidStr(String uuidStr) {
            this.uuidStr = Optional.ofNullable(uuidStr);
            return this;
        }

        @Override
        @JsonSetter(value="uuid_str", nulls=Nulls.SKIP)
        public _FinalStage uuidStr(Optional<String> uuidStr) {
            this.uuidStr = uuidStr;
            return this;
        }

        @Override
        public _FinalStage createdAtTimestamp(OffsetDateTime createdAtTimestamp) {
            this.createdAtTimestamp = Optional.ofNullable(createdAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="created_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage createdAtTimestamp(Optional<OffsetDateTime> createdAtTimestamp) {
            this.createdAtTimestamp = createdAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage adjustmentComments(Nullable<String> adjustmentComments) {
            this.adjustmentComments = adjustmentComments.isNull() ? null : (adjustmentComments.isEmpty() ? Optional.empty() : Optional.of(adjustmentComments.get()));
            return this;
        }

        @Override
        public _FinalStage adjustmentComments(String adjustmentComments) {
            this.adjustmentComments = Optional.ofNullable(adjustmentComments);
            return this;
        }

        @Override
        @JsonSetter(value="adjustment_comments", nulls=Nulls.SKIP)
        public _FinalStage adjustmentComments(Optional<String> adjustmentComments) {
            this.adjustmentComments = adjustmentComments;
            return this;
        }

        @Override
        public _FinalStage adjustment(Nullable<Double> adjustment) {
            this.adjustment = adjustment.isNull() ? null : (adjustment.isEmpty() ? Optional.empty() : Optional.of(adjustment.get()));
            return this;
        }

        @Override
        public _FinalStage adjustment(Double adjustment) {
            this.adjustment = Optional.ofNullable(adjustment);
            return this;
        }

        @Override
        @JsonSetter(value="adjustment", nulls=Nulls.SKIP)
        public _FinalStage adjustment(Optional<Double> adjustment) {
            this.adjustment = adjustment;
            return this;
        }

        @Override
        public _FinalStage comments(Nullable<String> comments) {
            this.comments = comments.isNull() ? null : (comments.isEmpty() ? Optional.empty() : Optional.of(comments.get()));
            return this;
        }

        @Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @Override
        @JsonSetter(value="comments", nulls=Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public _FinalStage units(UnitsEnum units) {
            this.units = Optional.ofNullable(units);
            return this;
        }

        @Override
        @JsonSetter(value="units", nulls=Nulls.SKIP)
        public _FinalStage units(Optional<UnitsEnum> units) {
            this.units = units;
            return this;
        }

        @Override
        public _FinalStage schemaVersion(Integer schemaVersion) {
            this.schemaVersion = Optional.ofNullable(schemaVersion);
            return this;
        }

        @Override
        @JsonSetter(value="schema_version", nulls=Nulls.SKIP)
        public _FinalStage schemaVersion(Optional<Integer> schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public LineItem1 build() {
            return new LineItem1(this.schemaVersion, this.item, this.quantity, this.rate, this.units, this.comments, this.adjustment, this.adjustmentComments, this.createdAtTimestamp, this.uuidStr, this.amount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LineItem1 build();

        public _FinalStage schemaVersion(Optional<Integer> var1);

        public _FinalStage schemaVersion(Integer var1);

        public _FinalStage units(Optional<UnitsEnum> var1);

        public _FinalStage units(UnitsEnum var1);

        public _FinalStage comments(Optional<String> var1);

        public _FinalStage comments(String var1);

        public _FinalStage comments(Nullable<String> var1);

        public _FinalStage adjustment(Optional<Double> var1);

        public _FinalStage adjustment(Double var1);

        public _FinalStage adjustment(Nullable<Double> var1);

        public _FinalStage adjustmentComments(Optional<String> var1);

        public _FinalStage adjustmentComments(String var1);

        public _FinalStage adjustmentComments(Nullable<String> var1);

        public _FinalStage createdAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage createdAtTimestamp(OffsetDateTime var1);

        public _FinalStage uuidStr(Optional<String> var1);

        public _FinalStage uuidStr(String var1);
    }

    public static interface AmountStage {
        public _FinalStage amount(double var1);
    }

    public static interface RateStage {
        public AmountStage rate(double var1);
    }

    public static interface QuantityStage {
        public RateStage quantity(double var1);
    }

    public static interface ItemStage {
        public QuantityStage item(@NotNull LineItemEnum1 var1);

        public Builder from(LineItem1 var1);
    }
}

