/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItem1;
import com.chrt.api.types.LineItemGroupMessage1;
import com.chrt.api.types.LineItemGroupStatusEnum1;
import com.chrt.api.types.PaymentVectorTypeEnum1;
import com.chrt.api.types.SettlementTypeEnum1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LineItemGroup1 {
    private final int schemaVersion;
    private final String id;
    private final Optional<String> taskGroupId;
    private final Optional<String> rateSheetId;
    private final List<LineItem1> lineItems;
    private final Optional<List<String>> lineItemGroupS3ObjectMetadataIds;
    private final Optional<String> statementId;
    private final String ownedByOrgId;
    private final PaymentVectorTypeEnum1 paymentVectorType;
    private final SettlementTypeEnum1 settlementType;
    private final Optional<String> paymentOriginOrgId;
    private final Optional<String> paymentOriginOffChrtShipperOrgId;
    private final Optional<String> paymentDestinationOrgId;
    private final Optional<String> paymentDestinationDriverId;
    private final Optional<LineItemGroupStatusEnum1> status;
    private final Optional<List<LineItemGroupMessage1>> messages;
    private final Map<String, Object> additionalProperties;

    private LineItemGroup1(int schemaVersion, String id, Optional<String> taskGroupId, Optional<String> rateSheetId, List<LineItem1> lineItems, Optional<List<String>> lineItemGroupS3ObjectMetadataIds, Optional<String> statementId, String ownedByOrgId, PaymentVectorTypeEnum1 paymentVectorType, SettlementTypeEnum1 settlementType, Optional<String> paymentOriginOrgId, Optional<String> paymentOriginOffChrtShipperOrgId, Optional<String> paymentDestinationOrgId, Optional<String> paymentDestinationDriverId, Optional<LineItemGroupStatusEnum1> status, Optional<List<LineItemGroupMessage1>> messages, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.taskGroupId = taskGroupId;
        this.rateSheetId = rateSheetId;
        this.lineItems = lineItems;
        this.lineItemGroupS3ObjectMetadataIds = lineItemGroupS3ObjectMetadataIds;
        this.statementId = statementId;
        this.ownedByOrgId = ownedByOrgId;
        this.paymentVectorType = paymentVectorType;
        this.settlementType = settlementType;
        this.paymentOriginOrgId = paymentOriginOrgId;
        this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
        this.paymentDestinationOrgId = paymentDestinationOrgId;
        this.paymentDestinationDriverId = paymentDestinationDriverId;
        this.status = status;
        this.messages = messages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> getTaskGroupId() {
        if (this.taskGroupId == null) {
            return Optional.empty();
        }
        return this.taskGroupId;
    }

    @JsonIgnore
    public Optional<String> getRateSheetId() {
        if (this.rateSheetId == null) {
            return Optional.empty();
        }
        return this.rateSheetId;
    }

    @JsonProperty(value="line_items")
    public List<LineItem1> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="line_item_group_s3_object_metadata_ids")
    public Optional<List<String>> getLineItemGroupS3ObjectMetadataIds() {
        return this.lineItemGroupS3ObjectMetadataIds;
    }

    @JsonIgnore
    public Optional<String> getStatementId() {
        if (this.statementId == null) {
            return Optional.empty();
        }
        return this.statementId;
    }

    @JsonProperty(value="owned_by_org_id")
    public String getOwnedByOrgId() {
        return this.ownedByOrgId;
    }

    @JsonProperty(value="payment_vector_type")
    public PaymentVectorTypeEnum1 getPaymentVectorType() {
        return this.paymentVectorType;
    }

    @JsonProperty(value="settlement_type")
    public SettlementTypeEnum1 getSettlementType() {
        return this.settlementType;
    }

    @JsonIgnore
    public Optional<String> getPaymentOriginOrgId() {
        if (this.paymentOriginOrgId == null) {
            return Optional.empty();
        }
        return this.paymentOriginOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentOriginOffChrtShipperOrgId() {
        if (this.paymentOriginOffChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return this.paymentOriginOffChrtShipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentDestinationOrgId() {
        if (this.paymentDestinationOrgId == null) {
            return Optional.empty();
        }
        return this.paymentDestinationOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentDestinationDriverId() {
        if (this.paymentDestinationDriverId == null) {
            return Optional.empty();
        }
        return this.paymentDestinationDriverId;
    }

    @JsonProperty(value="status")
    public Optional<LineItemGroupStatusEnum1> getStatus() {
        return this.status;
    }

    @JsonProperty(value="messages")
    public Optional<List<LineItemGroupMessage1>> getMessages() {
        return this.messages;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="task_group_id")
    private Optional<String> _getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="rate_sheet_id")
    private Optional<String> _getRateSheetId() {
        return this.rateSheetId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="statement_id")
    private Optional<String> _getStatementId() {
        return this.statementId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_origin_org_id")
    private Optional<String> _getPaymentOriginOrgId() {
        return this.paymentOriginOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_origin_off_chrt_shipper_org_id")
    private Optional<String> _getPaymentOriginOffChrtShipperOrgId() {
        return this.paymentOriginOffChrtShipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_destination_org_id")
    private Optional<String> _getPaymentDestinationOrgId() {
        return this.paymentDestinationOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_destination_driver_id")
    private Optional<String> _getPaymentDestinationDriverId() {
        return this.paymentDestinationDriverId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LineItemGroup1 && this.equalTo((LineItemGroup1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LineItemGroup1 other) {
        return this.schemaVersion == other.schemaVersion && this.id.equals(other.id) && this.taskGroupId.equals(other.taskGroupId) && this.rateSheetId.equals(other.rateSheetId) && this.lineItems.equals(other.lineItems) && this.lineItemGroupS3ObjectMetadataIds.equals(other.lineItemGroupS3ObjectMetadataIds) && this.statementId.equals(other.statementId) && this.ownedByOrgId.equals(other.ownedByOrgId) && this.paymentVectorType.equals(other.paymentVectorType) && this.settlementType.equals(other.settlementType) && this.paymentOriginOrgId.equals(other.paymentOriginOrgId) && this.paymentOriginOffChrtShipperOrgId.equals(other.paymentOriginOffChrtShipperOrgId) && this.paymentDestinationOrgId.equals(other.paymentDestinationOrgId) && this.paymentDestinationDriverId.equals(other.paymentDestinationDriverId) && this.status.equals(other.status) && this.messages.equals(other.messages);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.id, this.taskGroupId, this.rateSheetId, this.lineItems, this.lineItemGroupS3ObjectMetadataIds, this.statementId, this.ownedByOrgId, this.paymentVectorType, this.settlementType, this.paymentOriginOrgId, this.paymentOriginOffChrtShipperOrgId, this.paymentDestinationOrgId, this.paymentDestinationDriverId, this.status, this.messages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    IdStage,
    OwnedByOrgIdStage,
    PaymentVectorTypeStage,
    SettlementTypeStage,
    _FinalStage {
        private int schemaVersion;
        private String id;
        private String ownedByOrgId;
        private PaymentVectorTypeEnum1 paymentVectorType;
        private SettlementTypeEnum1 settlementType;
        private Optional<List<LineItemGroupMessage1>> messages = Optional.empty();
        private Optional<LineItemGroupStatusEnum1> status = Optional.empty();
        private Optional<String> paymentDestinationDriverId = Optional.empty();
        private Optional<String> paymentDestinationOrgId = Optional.empty();
        private Optional<String> paymentOriginOffChrtShipperOrgId = Optional.empty();
        private Optional<String> paymentOriginOrgId = Optional.empty();
        private Optional<String> statementId = Optional.empty();
        private Optional<List<String>> lineItemGroupS3ObjectMetadataIds = Optional.empty();
        private List<LineItem1> lineItems = new ArrayList<LineItem1>();
        private Optional<String> rateSheetId = Optional.empty();
        private Optional<String> taskGroupId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LineItemGroup1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.id(other.getId());
            this.taskGroupId(other.getTaskGroupId());
            this.rateSheetId(other.getRateSheetId());
            this.lineItems(other.getLineItems());
            this.lineItemGroupS3ObjectMetadataIds(other.getLineItemGroupS3ObjectMetadataIds());
            this.statementId(other.getStatementId());
            this.ownedByOrgId(other.getOwnedByOrgId());
            this.paymentVectorType(other.getPaymentVectorType());
            this.settlementType(other.getSettlementType());
            this.paymentOriginOrgId(other.getPaymentOriginOrgId());
            this.paymentOriginOffChrtShipperOrgId(other.getPaymentOriginOffChrtShipperOrgId());
            this.paymentDestinationOrgId(other.getPaymentDestinationOrgId());
            this.paymentDestinationDriverId(other.getPaymentDestinationDriverId());
            this.status(other.getStatus());
            this.messages(other.getMessages());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public OwnedByOrgIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="owned_by_org_id")
        public PaymentVectorTypeStage ownedByOrgId(@NotNull String ownedByOrgId) {
            this.ownedByOrgId = Objects.requireNonNull(ownedByOrgId, "ownedByOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="payment_vector_type")
        public SettlementTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType) {
            this.paymentVectorType = Objects.requireNonNull(paymentVectorType, "paymentVectorType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="settlement_type")
        public _FinalStage settlementType(@NotNull SettlementTypeEnum1 settlementType) {
            this.settlementType = Objects.requireNonNull(settlementType, "settlementType must not be null");
            return this;
        }

        @Override
        public _FinalStage messages(List<LineItemGroupMessage1> messages) {
            this.messages = Optional.ofNullable(messages);
            return this;
        }

        @Override
        @JsonSetter(value="messages", nulls=Nulls.SKIP)
        public _FinalStage messages(Optional<List<LineItemGroupMessage1>> messages) {
            this.messages = messages;
            return this;
        }

        @Override
        public _FinalStage status(LineItemGroupStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<LineItemGroupStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage paymentDestinationDriverId(Nullable<String> paymentDestinationDriverId) {
            this.paymentDestinationDriverId = paymentDestinationDriverId.isNull() ? null : (paymentDestinationDriverId.isEmpty() ? Optional.empty() : Optional.of(paymentDestinationDriverId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentDestinationDriverId(String paymentDestinationDriverId) {
            this.paymentDestinationDriverId = Optional.ofNullable(paymentDestinationDriverId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_destination_driver_id", nulls=Nulls.SKIP)
        public _FinalStage paymentDestinationDriverId(Optional<String> paymentDestinationDriverId) {
            this.paymentDestinationDriverId = paymentDestinationDriverId;
            return this;
        }

        @Override
        public _FinalStage paymentDestinationOrgId(Nullable<String> paymentDestinationOrgId) {
            this.paymentDestinationOrgId = paymentDestinationOrgId.isNull() ? null : (paymentDestinationOrgId.isEmpty() ? Optional.empty() : Optional.of(paymentDestinationOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentDestinationOrgId(String paymentDestinationOrgId) {
            this.paymentDestinationOrgId = Optional.ofNullable(paymentDestinationOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_destination_org_id", nulls=Nulls.SKIP)
        public _FinalStage paymentDestinationOrgId(Optional<String> paymentDestinationOrgId) {
            this.paymentDestinationOrgId = paymentDestinationOrgId;
            return this;
        }

        @Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId.isNull() ? null : (paymentOriginOffChrtShipperOrgId.isEmpty() ? Optional.empty() : Optional.of(paymentOriginOffChrtShipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(String paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = Optional.ofNullable(paymentOriginOffChrtShipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_origin_off_chrt_shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
            return this;
        }

        @Override
        public _FinalStage paymentOriginOrgId(Nullable<String> paymentOriginOrgId) {
            this.paymentOriginOrgId = paymentOriginOrgId.isNull() ? null : (paymentOriginOrgId.isEmpty() ? Optional.empty() : Optional.of(paymentOriginOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentOriginOrgId(String paymentOriginOrgId) {
            this.paymentOriginOrgId = Optional.ofNullable(paymentOriginOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_origin_org_id", nulls=Nulls.SKIP)
        public _FinalStage paymentOriginOrgId(Optional<String> paymentOriginOrgId) {
            this.paymentOriginOrgId = paymentOriginOrgId;
            return this;
        }

        @Override
        public _FinalStage statementId(Nullable<String> statementId) {
            this.statementId = statementId.isNull() ? null : (statementId.isEmpty() ? Optional.empty() : Optional.of(statementId.get()));
            return this;
        }

        @Override
        public _FinalStage statementId(String statementId) {
            this.statementId = Optional.ofNullable(statementId);
            return this;
        }

        @Override
        @JsonSetter(value="statement_id", nulls=Nulls.SKIP)
        public _FinalStage statementId(Optional<String> statementId) {
            this.statementId = statementId;
            return this;
        }

        @Override
        public _FinalStage lineItemGroupS3ObjectMetadataIds(List<String> lineItemGroupS3ObjectMetadataIds) {
            this.lineItemGroupS3ObjectMetadataIds = Optional.ofNullable(lineItemGroupS3ObjectMetadataIds);
            return this;
        }

        @Override
        @JsonSetter(value="line_item_group_s3_object_metadata_ids", nulls=Nulls.SKIP)
        public _FinalStage lineItemGroupS3ObjectMetadataIds(Optional<List<String>> lineItemGroupS3ObjectMetadataIds) {
            this.lineItemGroupS3ObjectMetadataIds = lineItemGroupS3ObjectMetadataIds;
            return this;
        }

        @Override
        public _FinalStage addAllLineItems(List<LineItem1> lineItems) {
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @Override
        public _FinalStage addLineItems(LineItem1 lineItems) {
            this.lineItems.add(lineItems);
            return this;
        }

        @Override
        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public _FinalStage lineItems(List<LineItem1> lineItems) {
            this.lineItems.clear();
            if (lineItems != null) {
                this.lineItems.addAll(lineItems);
            }
            return this;
        }

        @Override
        public _FinalStage rateSheetId(Nullable<String> rateSheetId) {
            this.rateSheetId = rateSheetId.isNull() ? null : (rateSheetId.isEmpty() ? Optional.empty() : Optional.of(rateSheetId.get()));
            return this;
        }

        @Override
        public _FinalStage rateSheetId(String rateSheetId) {
            this.rateSheetId = Optional.ofNullable(rateSheetId);
            return this;
        }

        @Override
        @JsonSetter(value="rate_sheet_id", nulls=Nulls.SKIP)
        public _FinalStage rateSheetId(Optional<String> rateSheetId) {
            this.rateSheetId = rateSheetId;
            return this;
        }

        @Override
        public _FinalStage taskGroupId(Nullable<String> taskGroupId) {
            this.taskGroupId = taskGroupId.isNull() ? null : (taskGroupId.isEmpty() ? Optional.empty() : Optional.of(taskGroupId.get()));
            return this;
        }

        @Override
        public _FinalStage taskGroupId(String taskGroupId) {
            this.taskGroupId = Optional.ofNullable(taskGroupId);
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id", nulls=Nulls.SKIP)
        public _FinalStage taskGroupId(Optional<String> taskGroupId) {
            this.taskGroupId = taskGroupId;
            return this;
        }

        @Override
        public LineItemGroup1 build() {
            return new LineItemGroup1(this.schemaVersion, this.id, this.taskGroupId, this.rateSheetId, this.lineItems, this.lineItemGroupS3ObjectMetadataIds, this.statementId, this.ownedByOrgId, this.paymentVectorType, this.settlementType, this.paymentOriginOrgId, this.paymentOriginOffChrtShipperOrgId, this.paymentDestinationOrgId, this.paymentDestinationDriverId, this.status, this.messages, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LineItemGroup1 build();

        public _FinalStage taskGroupId(Optional<String> var1);

        public _FinalStage taskGroupId(String var1);

        public _FinalStage taskGroupId(Nullable<String> var1);

        public _FinalStage rateSheetId(Optional<String> var1);

        public _FinalStage rateSheetId(String var1);

        public _FinalStage rateSheetId(Nullable<String> var1);

        public _FinalStage lineItems(List<LineItem1> var1);

        public _FinalStage addLineItems(LineItem1 var1);

        public _FinalStage addAllLineItems(List<LineItem1> var1);

        public _FinalStage lineItemGroupS3ObjectMetadataIds(Optional<List<String>> var1);

        public _FinalStage lineItemGroupS3ObjectMetadataIds(List<String> var1);

        public _FinalStage statementId(Optional<String> var1);

        public _FinalStage statementId(String var1);

        public _FinalStage statementId(Nullable<String> var1);

        public _FinalStage paymentOriginOrgId(Optional<String> var1);

        public _FinalStage paymentOriginOrgId(String var1);

        public _FinalStage paymentOriginOrgId(Nullable<String> var1);

        public _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> var1);

        public _FinalStage paymentOriginOffChrtShipperOrgId(String var1);

        public _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> var1);

        public _FinalStage paymentDestinationOrgId(Optional<String> var1);

        public _FinalStage paymentDestinationOrgId(String var1);

        public _FinalStage paymentDestinationOrgId(Nullable<String> var1);

        public _FinalStage paymentDestinationDriverId(Optional<String> var1);

        public _FinalStage paymentDestinationDriverId(String var1);

        public _FinalStage paymentDestinationDriverId(Nullable<String> var1);

        public _FinalStage status(Optional<LineItemGroupStatusEnum1> var1);

        public _FinalStage status(LineItemGroupStatusEnum1 var1);

        public _FinalStage messages(Optional<List<LineItemGroupMessage1>> var1);

        public _FinalStage messages(List<LineItemGroupMessage1> var1);
    }

    public static interface SettlementTypeStage {
        public _FinalStage settlementType(@NotNull SettlementTypeEnum1 var1);
    }

    public static interface PaymentVectorTypeStage {
        public SettlementTypeStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 var1);
    }

    public static interface OwnedByOrgIdStage {
        public PaymentVectorTypeStage ownedByOrgId(@NotNull String var1);
    }

    public static interface IdStage {
        public OwnedByOrgIdStage id(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public IdStage schemaVersion(int var1);

        public Builder from(LineItemGroup1 var1);
    }
}

