/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.Geometry;
import com.chrt.api.types.Id;
import com.chrt.api.types.LocationProperties;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LocationFeature {
    private final Optional<List<Object>> bbox;
    private final Geometry geometry;
    private final Optional<LocationProperties> properties;
    private final Optional<Id> id;
    private final Map<String, Object> additionalProperties;

    private LocationFeature(Optional<List<Object>> bbox, Geometry geometry, Optional<LocationProperties> properties, Optional<Id> id, Map<String, Object> additionalProperties) {
        this.bbox = bbox;
        this.geometry = geometry;
        this.properties = properties;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Object>> getBbox() {
        if (this.bbox == null) {
            return Optional.empty();
        }
        return this.bbox;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "Feature";
    }

    @JsonProperty(value="geometry")
    public Geometry getGeometry() {
        return this.geometry;
    }

    @JsonIgnore
    public Optional<LocationProperties> getProperties() {
        if (this.properties == null) {
            return Optional.empty();
        }
        return this.properties;
    }

    @JsonIgnore
    public Optional<Id> getId() {
        if (this.id == null) {
            return Optional.empty();
        }
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="bbox")
    private Optional<List<Object>> _getBbox() {
        return this.bbox;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="properties")
    private Optional<LocationProperties> _getProperties() {
        return this.properties;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="id")
    private Optional<Id> _getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LocationFeature && this.equalTo((LocationFeature)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LocationFeature other) {
        return this.bbox.equals(other.bbox) && this.geometry.equals(other.geometry) && this.properties.equals(other.properties) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.bbox, this.geometry, this.properties, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GeometryStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GeometryStage,
    _FinalStage {
        private Geometry geometry;
        private Optional<Id> id = Optional.empty();
        private Optional<LocationProperties> properties = Optional.empty();
        private Optional<List<Object>> bbox = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LocationFeature other) {
            this.bbox(other.getBbox());
            this.geometry(other.getGeometry());
            this.properties(other.getProperties());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="geometry")
        public _FinalStage geometry(@NotNull Geometry geometry) {
            this.geometry = Objects.requireNonNull(geometry, "geometry must not be null");
            return this;
        }

        @Override
        public _FinalStage id(Nullable<Id> id) {
            this.id = id.isNull() ? null : (id.isEmpty() ? Optional.empty() : Optional.of(id.get()));
            return this;
        }

        @Override
        public _FinalStage id(Id id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<Id> id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage properties(Nullable<LocationProperties> properties) {
            this.properties = properties.isNull() ? null : (properties.isEmpty() ? Optional.empty() : Optional.of(properties.get()));
            return this;
        }

        @Override
        public _FinalStage properties(LocationProperties properties) {
            this.properties = Optional.ofNullable(properties);
            return this;
        }

        @Override
        @JsonSetter(value="properties", nulls=Nulls.SKIP)
        public _FinalStage properties(Optional<LocationProperties> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public _FinalStage bbox(Nullable<List<Object>> bbox) {
            this.bbox = bbox.isNull() ? null : (bbox.isEmpty() ? Optional.empty() : Optional.of(bbox.get()));
            return this;
        }

        @Override
        public _FinalStage bbox(List<Object> bbox) {
            this.bbox = Optional.ofNullable(bbox);
            return this;
        }

        @Override
        @JsonSetter(value="bbox", nulls=Nulls.SKIP)
        public _FinalStage bbox(Optional<List<Object>> bbox) {
            this.bbox = bbox;
            return this;
        }

        @Override
        public LocationFeature build() {
            return new LocationFeature(this.bbox, this.geometry, this.properties, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LocationFeature build();

        public _FinalStage bbox(Optional<List<Object>> var1);

        public _FinalStage bbox(List<Object> var1);

        public _FinalStage bbox(Nullable<List<Object>> var1);

        public _FinalStage properties(Optional<LocationProperties> var1);

        public _FinalStage properties(LocationProperties var1);

        public _FinalStage properties(Nullable<LocationProperties> var1);

        public _FinalStage id(Optional<Id> var1);

        public _FinalStage id(Id var1);

        public _FinalStage id(Nullable<Id> var1);
    }

    public static interface GeometryStage {
        public _FinalStage geometry(@NotNull Geometry var1);

        public Builder from(LocationFeature var1);
    }
}

