/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.MultiPolygonCoordinatesItemItemItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MultiPolygon {
    private final Optional<List<Object>> bbox;
    private final List<List<List<MultiPolygonCoordinatesItemItemItem>>> coordinates;
    private final Map<String, Object> additionalProperties;

    private MultiPolygon(Optional<List<Object>> bbox, List<List<List<MultiPolygonCoordinatesItemItemItem>>> coordinates, Map<String, Object> additionalProperties) {
        this.bbox = bbox;
        this.coordinates = coordinates;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Object>> getBbox() {
        if (this.bbox == null) {
            return Optional.empty();
        }
        return this.bbox;
    }

    @JsonProperty(value="coordinates")
    public List<List<List<MultiPolygonCoordinatesItemItemItem>>> getCoordinates() {
        return this.coordinates;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="bbox")
    private Optional<List<Object>> _getBbox() {
        return this.bbox;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MultiPolygon && this.equalTo((MultiPolygon)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MultiPolygon other) {
        return this.bbox.equals(other.bbox) && this.coordinates.equals(other.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.bbox, this.coordinates);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Object>> bbox = Optional.empty();
        private List<List<List<MultiPolygonCoordinatesItemItemItem>>> coordinates = new ArrayList<List<List<MultiPolygonCoordinatesItemItemItem>>>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(MultiPolygon other) {
            this.bbox(other.getBbox());
            this.coordinates(other.getCoordinates());
            return this;
        }

        @JsonSetter(value="bbox", nulls=Nulls.SKIP)
        public Builder bbox(Optional<List<Object>> bbox) {
            this.bbox = bbox;
            return this;
        }

        public Builder bbox(List<Object> bbox) {
            this.bbox = Optional.ofNullable(bbox);
            return this;
        }

        public Builder bbox(Nullable<List<Object>> bbox) {
            this.bbox = bbox.isNull() ? null : (bbox.isEmpty() ? Optional.empty() : Optional.of(bbox.get()));
            return this;
        }

        @JsonSetter(value="coordinates", nulls=Nulls.SKIP)
        public Builder coordinates(List<List<List<MultiPolygonCoordinatesItemItemItem>>> coordinates) {
            this.coordinates.clear();
            if (coordinates != null) {
                this.coordinates.addAll(coordinates);
            }
            return this;
        }

        public Builder addCoordinates(List<List<MultiPolygonCoordinatesItemItemItem>> coordinates) {
            this.coordinates.add(coordinates);
            return this;
        }

        public Builder addAllCoordinates(List<List<List<MultiPolygonCoordinatesItemItemItem>>> coordinates) {
            if (coordinates != null) {
                this.coordinates.addAll(coordinates);
            }
            return this;
        }

        public MultiPolygon build() {
            return new MultiPolygon(this.bbox, this.coordinates, this.additionalProperties);
        }
    }
}

