/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class NotificationChannelEnum {
    public static final NotificationChannelEnum EMAIL = new NotificationChannelEnum(Value.EMAIL, "email");
    public static final NotificationChannelEnum PHONE_CALL = new NotificationChannelEnum(Value.PHONE_CALL, "phone_call");
    public static final NotificationChannelEnum PUSH = new NotificationChannelEnum(Value.PUSH, "push");
    public static final NotificationChannelEnum SMS = new NotificationChannelEnum(Value.SMS, "sms");
    private final Value value;
    private final String string;

    NotificationChannelEnum(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NotificationChannelEnum && this.string.equals(((NotificationChannelEnum)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case EMAIL: {
                return visitor.visitEmail();
            }
            case PHONE_CALL: {
                return visitor.visitPhoneCall();
            }
            case PUSH: {
                return visitor.visitPush();
            }
            case SMS: {
                return visitor.visitSms();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static NotificationChannelEnum valueOf(String value) {
        switch (value) {
            case "email": {
                return EMAIL;
            }
            case "phone_call": {
                return PHONE_CALL;
            }
            case "push": {
                return PUSH;
            }
            case "sms": {
                return SMS;
            }
        }
        return new NotificationChannelEnum(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitEmail();

        public T visitSms();

        public T visitPush();

        public T visitPhoneCall();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        EMAIL,
        SMS,
        PUSH,
        PHONE_CALL,
        UNKNOWN;

    }
}

