/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LocationFeature;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OffChrtShipperOrg1 {
    private final int schemaVersion;
    private final Optional<String> companyName;
    private final Optional<String> industry;
    private final Optional<LocationFeature> streetAddress;
    private final Optional<String> contactFirstName;
    private final Optional<String> contactLastName;
    private final Optional<String> phoneNumberPrimary;
    private final Optional<String> phoneNumberSecondary;
    private final String emailAddressPrimary;
    private final Optional<String> emailAddressSecondary;
    private final Optional<String> jobTitle;
    private final Optional<String> notes;
    private final Optional<String> shipperCustomerIdForStripeConnectAccount;
    private final String createdByOrgId;
    private final String createdByUserId;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private OffChrtShipperOrg1(int schemaVersion, Optional<String> companyName, Optional<String> industry, Optional<LocationFeature> streetAddress, Optional<String> contactFirstName, Optional<String> contactLastName, Optional<String> phoneNumberPrimary, Optional<String> phoneNumberSecondary, String emailAddressPrimary, Optional<String> emailAddressSecondary, Optional<String> jobTitle, Optional<String> notes, Optional<String> shipperCustomerIdForStripeConnectAccount, String createdByOrgId, String createdByUserId, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.companyName = companyName;
        this.industry = industry;
        this.streetAddress = streetAddress;
        this.contactFirstName = contactFirstName;
        this.contactLastName = contactLastName;
        this.phoneNumberPrimary = phoneNumberPrimary;
        this.phoneNumberSecondary = phoneNumberSecondary;
        this.emailAddressPrimary = emailAddressPrimary;
        this.emailAddressSecondary = emailAddressSecondary;
        this.jobTitle = jobTitle;
        this.notes = notes;
        this.shipperCustomerIdForStripeConnectAccount = shipperCustomerIdForStripeConnectAccount;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonIgnore
    public Optional<String> getCompanyName() {
        if (this.companyName == null) {
            return Optional.empty();
        }
        return this.companyName;
    }

    @JsonIgnore
    public Optional<String> getIndustry() {
        if (this.industry == null) {
            return Optional.empty();
        }
        return this.industry;
    }

    @JsonIgnore
    public Optional<LocationFeature> getStreetAddress() {
        if (this.streetAddress == null) {
            return Optional.empty();
        }
        return this.streetAddress;
    }

    @JsonIgnore
    public Optional<String> getContactFirstName() {
        if (this.contactFirstName == null) {
            return Optional.empty();
        }
        return this.contactFirstName;
    }

    @JsonIgnore
    public Optional<String> getContactLastName() {
        if (this.contactLastName == null) {
            return Optional.empty();
        }
        return this.contactLastName;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberPrimary() {
        if (this.phoneNumberPrimary == null) {
            return Optional.empty();
        }
        return this.phoneNumberPrimary;
    }

    @JsonIgnore
    public Optional<String> getPhoneNumberSecondary() {
        if (this.phoneNumberSecondary == null) {
            return Optional.empty();
        }
        return this.phoneNumberSecondary;
    }

    @JsonProperty(value="email_address_primary")
    public String getEmailAddressPrimary() {
        return this.emailAddressPrimary;
    }

    @JsonIgnore
    public Optional<String> getEmailAddressSecondary() {
        if (this.emailAddressSecondary == null) {
            return Optional.empty();
        }
        return this.emailAddressSecondary;
    }

    @JsonIgnore
    public Optional<String> getJobTitle() {
        if (this.jobTitle == null) {
            return Optional.empty();
        }
        return this.jobTitle;
    }

    @JsonIgnore
    public Optional<String> getNotes() {
        if (this.notes == null) {
            return Optional.empty();
        }
        return this.notes;
    }

    @JsonIgnore
    public Optional<String> getShipperCustomerIdForStripeConnectAccount() {
        if (this.shipperCustomerIdForStripeConnectAccount == null) {
            return Optional.empty();
        }
        return this.shipperCustomerIdForStripeConnectAccount;
    }

    @JsonProperty(value="created_by_org_id")
    public String getCreatedByOrgId() {
        return this.createdByOrgId;
    }

    @JsonProperty(value="created_by_user_id")
    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="company_name")
    private Optional<String> _getCompanyName() {
        return this.companyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="industry")
    private Optional<String> _getIndustry() {
        return this.industry;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="street_address")
    private Optional<LocationFeature> _getStreetAddress() {
        return this.streetAddress;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="contact_first_name")
    private Optional<String> _getContactFirstName() {
        return this.contactFirstName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="contact_last_name")
    private Optional<String> _getContactLastName() {
        return this.contactLastName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number_primary")
    private Optional<String> _getPhoneNumberPrimary() {
        return this.phoneNumberPrimary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="phone_number_secondary")
    private Optional<String> _getPhoneNumberSecondary() {
        return this.phoneNumberSecondary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="email_address_secondary")
    private Optional<String> _getEmailAddressSecondary() {
        return this.emailAddressSecondary;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="job_title")
    private Optional<String> _getJobTitle() {
        return this.jobTitle;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="notes")
    private Optional<String> _getNotes() {
        return this.notes;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_customer_id_for_stripe_connect_account")
    private Optional<String> _getShipperCustomerIdForStripeConnectAccount() {
        return this.shipperCustomerIdForStripeConnectAccount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OffChrtShipperOrg1 && this.equalTo((OffChrtShipperOrg1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OffChrtShipperOrg1 other) {
        return this.schemaVersion == other.schemaVersion && this.companyName.equals(other.companyName) && this.industry.equals(other.industry) && this.streetAddress.equals(other.streetAddress) && this.contactFirstName.equals(other.contactFirstName) && this.contactLastName.equals(other.contactLastName) && this.phoneNumberPrimary.equals(other.phoneNumberPrimary) && this.phoneNumberSecondary.equals(other.phoneNumberSecondary) && this.emailAddressPrimary.equals(other.emailAddressPrimary) && this.emailAddressSecondary.equals(other.emailAddressSecondary) && this.jobTitle.equals(other.jobTitle) && this.notes.equals(other.notes) && this.shipperCustomerIdForStripeConnectAccount.equals(other.shipperCustomerIdForStripeConnectAccount) && this.createdByOrgId.equals(other.createdByOrgId) && this.createdByUserId.equals(other.createdByUserId) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.companyName, this.industry, this.streetAddress, this.contactFirstName, this.contactLastName, this.phoneNumberPrimary, this.phoneNumberSecondary, this.emailAddressPrimary, this.emailAddressSecondary, this.jobTitle, this.notes, this.shipperCustomerIdForStripeConnectAccount, this.createdByOrgId, this.createdByUserId, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    EmailAddressPrimaryStage,
    CreatedByOrgIdStage,
    CreatedByUserIdStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String emailAddressPrimary;
        private String createdByOrgId;
        private String createdByUserId;
        private String id;
        private Optional<String> shipperCustomerIdForStripeConnectAccount = Optional.empty();
        private Optional<String> notes = Optional.empty();
        private Optional<String> jobTitle = Optional.empty();
        private Optional<String> emailAddressSecondary = Optional.empty();
        private Optional<String> phoneNumberSecondary = Optional.empty();
        private Optional<String> phoneNumberPrimary = Optional.empty();
        private Optional<String> contactLastName = Optional.empty();
        private Optional<String> contactFirstName = Optional.empty();
        private Optional<LocationFeature> streetAddress = Optional.empty();
        private Optional<String> industry = Optional.empty();
        private Optional<String> companyName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OffChrtShipperOrg1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.companyName(other.getCompanyName());
            this.industry(other.getIndustry());
            this.streetAddress(other.getStreetAddress());
            this.contactFirstName(other.getContactFirstName());
            this.contactLastName(other.getContactLastName());
            this.phoneNumberPrimary(other.getPhoneNumberPrimary());
            this.phoneNumberSecondary(other.getPhoneNumberSecondary());
            this.emailAddressPrimary(other.getEmailAddressPrimary());
            this.emailAddressSecondary(other.getEmailAddressSecondary());
            this.jobTitle(other.getJobTitle());
            this.notes(other.getNotes());
            this.shipperCustomerIdForStripeConnectAccount(other.getShipperCustomerIdForStripeConnectAccount());
            this.createdByOrgId(other.getCreatedByOrgId());
            this.createdByUserId(other.getCreatedByUserId());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public EmailAddressPrimaryStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="email_address_primary")
        public CreatedByOrgIdStage emailAddressPrimary(@NotNull String emailAddressPrimary) {
            this.emailAddressPrimary = Objects.requireNonNull(emailAddressPrimary, "emailAddressPrimary must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_user_id")
        public IdStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage shipperCustomerIdForStripeConnectAccount(Nullable<String> shipperCustomerIdForStripeConnectAccount) {
            this.shipperCustomerIdForStripeConnectAccount = shipperCustomerIdForStripeConnectAccount.isNull() ? null : (shipperCustomerIdForStripeConnectAccount.isEmpty() ? Optional.empty() : Optional.of(shipperCustomerIdForStripeConnectAccount.get()));
            return this;
        }

        @Override
        public _FinalStage shipperCustomerIdForStripeConnectAccount(String shipperCustomerIdForStripeConnectAccount) {
            this.shipperCustomerIdForStripeConnectAccount = Optional.ofNullable(shipperCustomerIdForStripeConnectAccount);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_customer_id_for_stripe_connect_account", nulls=Nulls.SKIP)
        public _FinalStage shipperCustomerIdForStripeConnectAccount(Optional<String> shipperCustomerIdForStripeConnectAccount) {
            this.shipperCustomerIdForStripeConnectAccount = shipperCustomerIdForStripeConnectAccount;
            return this;
        }

        @Override
        public _FinalStage notes(Nullable<String> notes) {
            this.notes = notes.isNull() ? null : (notes.isEmpty() ? Optional.empty() : Optional.of(notes.get()));
            return this;
        }

        @Override
        public _FinalStage notes(String notes) {
            this.notes = Optional.ofNullable(notes);
            return this;
        }

        @Override
        @JsonSetter(value="notes", nulls=Nulls.SKIP)
        public _FinalStage notes(Optional<String> notes) {
            this.notes = notes;
            return this;
        }

        @Override
        public _FinalStage jobTitle(Nullable<String> jobTitle) {
            this.jobTitle = jobTitle.isNull() ? null : (jobTitle.isEmpty() ? Optional.empty() : Optional.of(jobTitle.get()));
            return this;
        }

        @Override
        public _FinalStage jobTitle(String jobTitle) {
            this.jobTitle = Optional.ofNullable(jobTitle);
            return this;
        }

        @Override
        @JsonSetter(value="job_title", nulls=Nulls.SKIP)
        public _FinalStage jobTitle(Optional<String> jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        @Override
        public _FinalStage emailAddressSecondary(Nullable<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary.isNull() ? null : (emailAddressSecondary.isEmpty() ? Optional.empty() : Optional.of(emailAddressSecondary.get()));
            return this;
        }

        @Override
        public _FinalStage emailAddressSecondary(String emailAddressSecondary) {
            this.emailAddressSecondary = Optional.ofNullable(emailAddressSecondary);
            return this;
        }

        @Override
        @JsonSetter(value="email_address_secondary", nulls=Nulls.SKIP)
        public _FinalStage emailAddressSecondary(Optional<String> emailAddressSecondary) {
            this.emailAddressSecondary = emailAddressSecondary;
            return this;
        }

        @Override
        public _FinalStage phoneNumberSecondary(Nullable<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary.isNull() ? null : (phoneNumberSecondary.isEmpty() ? Optional.empty() : Optional.of(phoneNumberSecondary.get()));
            return this;
        }

        @Override
        public _FinalStage phoneNumberSecondary(String phoneNumberSecondary) {
            this.phoneNumberSecondary = Optional.ofNullable(phoneNumberSecondary);
            return this;
        }

        @Override
        @JsonSetter(value="phone_number_secondary", nulls=Nulls.SKIP)
        public _FinalStage phoneNumberSecondary(Optional<String> phoneNumberSecondary) {
            this.phoneNumberSecondary = phoneNumberSecondary;
            return this;
        }

        @Override
        public _FinalStage phoneNumberPrimary(Nullable<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary.isNull() ? null : (phoneNumberPrimary.isEmpty() ? Optional.empty() : Optional.of(phoneNumberPrimary.get()));
            return this;
        }

        @Override
        public _FinalStage phoneNumberPrimary(String phoneNumberPrimary) {
            this.phoneNumberPrimary = Optional.ofNullable(phoneNumberPrimary);
            return this;
        }

        @Override
        @JsonSetter(value="phone_number_primary", nulls=Nulls.SKIP)
        public _FinalStage phoneNumberPrimary(Optional<String> phoneNumberPrimary) {
            this.phoneNumberPrimary = phoneNumberPrimary;
            return this;
        }

        @Override
        public _FinalStage contactLastName(Nullable<String> contactLastName) {
            this.contactLastName = contactLastName.isNull() ? null : (contactLastName.isEmpty() ? Optional.empty() : Optional.of(contactLastName.get()));
            return this;
        }

        @Override
        public _FinalStage contactLastName(String contactLastName) {
            this.contactLastName = Optional.ofNullable(contactLastName);
            return this;
        }

        @Override
        @JsonSetter(value="contact_last_name", nulls=Nulls.SKIP)
        public _FinalStage contactLastName(Optional<String> contactLastName) {
            this.contactLastName = contactLastName;
            return this;
        }

        @Override
        public _FinalStage contactFirstName(Nullable<String> contactFirstName) {
            this.contactFirstName = contactFirstName.isNull() ? null : (contactFirstName.isEmpty() ? Optional.empty() : Optional.of(contactFirstName.get()));
            return this;
        }

        @Override
        public _FinalStage contactFirstName(String contactFirstName) {
            this.contactFirstName = Optional.ofNullable(contactFirstName);
            return this;
        }

        @Override
        @JsonSetter(value="contact_first_name", nulls=Nulls.SKIP)
        public _FinalStage contactFirstName(Optional<String> contactFirstName) {
            this.contactFirstName = contactFirstName;
            return this;
        }

        @Override
        public _FinalStage streetAddress(Nullable<LocationFeature> streetAddress) {
            this.streetAddress = streetAddress.isNull() ? null : (streetAddress.isEmpty() ? Optional.empty() : Optional.of(streetAddress.get()));
            return this;
        }

        @Override
        public _FinalStage streetAddress(LocationFeature streetAddress) {
            this.streetAddress = Optional.ofNullable(streetAddress);
            return this;
        }

        @Override
        @JsonSetter(value="street_address", nulls=Nulls.SKIP)
        public _FinalStage streetAddress(Optional<LocationFeature> streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        @Override
        public _FinalStage industry(Nullable<String> industry) {
            this.industry = industry.isNull() ? null : (industry.isEmpty() ? Optional.empty() : Optional.of(industry.get()));
            return this;
        }

        @Override
        public _FinalStage industry(String industry) {
            this.industry = Optional.ofNullable(industry);
            return this;
        }

        @Override
        @JsonSetter(value="industry", nulls=Nulls.SKIP)
        public _FinalStage industry(Optional<String> industry) {
            this.industry = industry;
            return this;
        }

        @Override
        public _FinalStage companyName(Nullable<String> companyName) {
            this.companyName = companyName.isNull() ? null : (companyName.isEmpty() ? Optional.empty() : Optional.of(companyName.get()));
            return this;
        }

        @Override
        public _FinalStage companyName(String companyName) {
            this.companyName = Optional.ofNullable(companyName);
            return this;
        }

        @Override
        @JsonSetter(value="company_name", nulls=Nulls.SKIP)
        public _FinalStage companyName(Optional<String> companyName) {
            this.companyName = companyName;
            return this;
        }

        @Override
        public OffChrtShipperOrg1 build() {
            return new OffChrtShipperOrg1(this.schemaVersion, this.companyName, this.industry, this.streetAddress, this.contactFirstName, this.contactLastName, this.phoneNumberPrimary, this.phoneNumberSecondary, this.emailAddressPrimary, this.emailAddressSecondary, this.jobTitle, this.notes, this.shipperCustomerIdForStripeConnectAccount, this.createdByOrgId, this.createdByUserId, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OffChrtShipperOrg1 build();

        public _FinalStage companyName(Optional<String> var1);

        public _FinalStage companyName(String var1);

        public _FinalStage companyName(Nullable<String> var1);

        public _FinalStage industry(Optional<String> var1);

        public _FinalStage industry(String var1);

        public _FinalStage industry(Nullable<String> var1);

        public _FinalStage streetAddress(Optional<LocationFeature> var1);

        public _FinalStage streetAddress(LocationFeature var1);

        public _FinalStage streetAddress(Nullable<LocationFeature> var1);

        public _FinalStage contactFirstName(Optional<String> var1);

        public _FinalStage contactFirstName(String var1);

        public _FinalStage contactFirstName(Nullable<String> var1);

        public _FinalStage contactLastName(Optional<String> var1);

        public _FinalStage contactLastName(String var1);

        public _FinalStage contactLastName(Nullable<String> var1);

        public _FinalStage phoneNumberPrimary(Optional<String> var1);

        public _FinalStage phoneNumberPrimary(String var1);

        public _FinalStage phoneNumberPrimary(Nullable<String> var1);

        public _FinalStage phoneNumberSecondary(Optional<String> var1);

        public _FinalStage phoneNumberSecondary(String var1);

        public _FinalStage phoneNumberSecondary(Nullable<String> var1);

        public _FinalStage emailAddressSecondary(Optional<String> var1);

        public _FinalStage emailAddressSecondary(String var1);

        public _FinalStage emailAddressSecondary(Nullable<String> var1);

        public _FinalStage jobTitle(Optional<String> var1);

        public _FinalStage jobTitle(String var1);

        public _FinalStage jobTitle(Nullable<String> var1);

        public _FinalStage notes(Optional<String> var1);

        public _FinalStage notes(String var1);

        public _FinalStage notes(Nullable<String> var1);

        public _FinalStage shipperCustomerIdForStripeConnectAccount(Optional<String> var1);

        public _FinalStage shipperCustomerIdForStripeConnectAccount(String var1);

        public _FinalStage shipperCustomerIdForStripeConnectAccount(Nullable<String> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface CreatedByUserIdStage {
        public IdStage createdByUserId(@NotNull String var1);
    }

    public static interface CreatedByOrgIdStage {
        public CreatedByUserIdStage createdByOrgId(@NotNull String var1);
    }

    public static interface EmailAddressPrimaryStage {
        public CreatedByOrgIdStage emailAddressPrimary(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public EmailAddressPrimaryStage schemaVersion(int var1);

        public Builder from(OffChrtShipperOrg1 var1);
    }
}

