/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.OrderStatusEnum1;
import com.chrt.api.types.OrgTypeEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Order1 {
    private final int schemaVersion;
    private final String id;
    private final String shortId;
    private final Optional<List<String>> taskGroupIds;
    private final OrgTypeEnum createdByOrgType;
    private final String createdByOrgId;
    private final String createdByUserId;
    private final Optional<String> forwarderOrgId;
    private final Optional<String> shipperOrgId;
    private final Optional<String> offChrtShipperOrgId;
    private final Optional<OrderStatusEnum1> status;
    private final OffsetDateTime draftStartedAtTimestamp;
    private final Optional<OffsetDateTime> stagedAtTimestamp;
    private final Optional<OffsetDateTime> inProgressAtTimestamp;
    private final Optional<OffsetDateTime> completedAtTimestamp;
    private final Optional<OffsetDateTime> exceptionAtTimestamp;
    private final Optional<Boolean> orderCancelled;
    private final Optional<OffsetDateTime> orderCancelledAtTimestamp;
    private final Map<String, Object> additionalProperties;

    private Order1(int schemaVersion, String id, String shortId, Optional<List<String>> taskGroupIds, OrgTypeEnum createdByOrgType, String createdByOrgId, String createdByUserId, Optional<String> forwarderOrgId, Optional<String> shipperOrgId, Optional<String> offChrtShipperOrgId, Optional<OrderStatusEnum1> status, OffsetDateTime draftStartedAtTimestamp, Optional<OffsetDateTime> stagedAtTimestamp, Optional<OffsetDateTime> inProgressAtTimestamp, Optional<OffsetDateTime> completedAtTimestamp, Optional<OffsetDateTime> exceptionAtTimestamp, Optional<Boolean> orderCancelled, Optional<OffsetDateTime> orderCancelledAtTimestamp, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.shortId = shortId;
        this.taskGroupIds = taskGroupIds;
        this.createdByOrgType = createdByOrgType;
        this.createdByOrgId = createdByOrgId;
        this.createdByUserId = createdByUserId;
        this.forwarderOrgId = forwarderOrgId;
        this.shipperOrgId = shipperOrgId;
        this.offChrtShipperOrgId = offChrtShipperOrgId;
        this.status = status;
        this.draftStartedAtTimestamp = draftStartedAtTimestamp;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.inProgressAtTimestamp = inProgressAtTimestamp;
        this.completedAtTimestamp = completedAtTimestamp;
        this.exceptionAtTimestamp = exceptionAtTimestamp;
        this.orderCancelled = orderCancelled;
        this.orderCancelledAtTimestamp = orderCancelledAtTimestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="short_id")
    public String getShortId() {
        return this.shortId;
    }

    @JsonProperty(value="task_group_ids")
    public Optional<List<String>> getTaskGroupIds() {
        return this.taskGroupIds;
    }

    @JsonProperty(value="created_by_org_type")
    public OrgTypeEnum getCreatedByOrgType() {
        return this.createdByOrgType;
    }

    @JsonProperty(value="created_by_org_id")
    public String getCreatedByOrgId() {
        return this.createdByOrgId;
    }

    @JsonProperty(value="created_by_user_id")
    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    @JsonIgnore
    public Optional<String> getForwarderOrgId() {
        if (this.forwarderOrgId == null) {
            return Optional.empty();
        }
        return this.forwarderOrgId;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgId() {
        if (this.shipperOrgId == null) {
            return Optional.empty();
        }
        return this.shipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgId() {
        if (this.offChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return this.offChrtShipperOrgId;
    }

    @JsonProperty(value="status")
    public Optional<OrderStatusEnum1> getStatus() {
        return this.status;
    }

    @JsonProperty(value="draft_started_at_timestamp")
    public OffsetDateTime getDraftStartedAtTimestamp() {
        return this.draftStartedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (this.stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getInProgressAtTimestamp() {
        if (this.inProgressAtTimestamp == null) {
            return Optional.empty();
        }
        return this.inProgressAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedAtTimestamp() {
        if (this.completedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.completedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExceptionAtTimestamp() {
        if (this.exceptionAtTimestamp == null) {
            return Optional.empty();
        }
        return this.exceptionAtTimestamp;
    }

    @JsonProperty(value="order_cancelled")
    public Optional<Boolean> getOrderCancelled() {
        return this.orderCancelled;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getOrderCancelledAtTimestamp() {
        if (this.orderCancelledAtTimestamp == null) {
            return Optional.empty();
        }
        return this.orderCancelledAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="forwarder_org_id")
    private Optional<String> _getForwarderOrgId() {
        return this.forwarderOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_org_id")
    private Optional<String> _getShipperOrgId() {
        return this.shipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="off_chrt_shipper_org_id")
    private Optional<String> _getOffChrtShipperOrgId() {
        return this.offChrtShipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return this.stagedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="in_progress_at_timestamp")
    private Optional<OffsetDateTime> _getInProgressAtTimestamp() {
        return this.inProgressAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="completed_at_timestamp")
    private Optional<OffsetDateTime> _getCompletedAtTimestamp() {
        return this.completedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="exception_at_timestamp")
    private Optional<OffsetDateTime> _getExceptionAtTimestamp() {
        return this.exceptionAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="order_cancelled_at_timestamp")
    private Optional<OffsetDateTime> _getOrderCancelledAtTimestamp() {
        return this.orderCancelledAtTimestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Order1 && this.equalTo((Order1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Order1 other) {
        return this.schemaVersion == other.schemaVersion && this.id.equals(other.id) && this.shortId.equals(other.shortId) && this.taskGroupIds.equals(other.taskGroupIds) && this.createdByOrgType.equals(other.createdByOrgType) && this.createdByOrgId.equals(other.createdByOrgId) && this.createdByUserId.equals(other.createdByUserId) && this.forwarderOrgId.equals(other.forwarderOrgId) && this.shipperOrgId.equals(other.shipperOrgId) && this.offChrtShipperOrgId.equals(other.offChrtShipperOrgId) && this.status.equals(other.status) && this.draftStartedAtTimestamp.equals(other.draftStartedAtTimestamp) && this.stagedAtTimestamp.equals(other.stagedAtTimestamp) && this.inProgressAtTimestamp.equals(other.inProgressAtTimestamp) && this.completedAtTimestamp.equals(other.completedAtTimestamp) && this.exceptionAtTimestamp.equals(other.exceptionAtTimestamp) && this.orderCancelled.equals(other.orderCancelled) && this.orderCancelledAtTimestamp.equals(other.orderCancelledAtTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.id, this.shortId, this.taskGroupIds, this.createdByOrgType, this.createdByOrgId, this.createdByUserId, this.forwarderOrgId, this.shipperOrgId, this.offChrtShipperOrgId, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.inProgressAtTimestamp, this.completedAtTimestamp, this.exceptionAtTimestamp, this.orderCancelled, this.orderCancelledAtTimestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    IdStage,
    ShortIdStage,
    CreatedByOrgTypeStage,
    CreatedByOrgIdStage,
    CreatedByUserIdStage,
    DraftStartedAtTimestampStage,
    _FinalStage {
        private int schemaVersion;
        private String id;
        private String shortId;
        private OrgTypeEnum createdByOrgType;
        private String createdByOrgId;
        private String createdByUserId;
        private OffsetDateTime draftStartedAtTimestamp;
        private Optional<OffsetDateTime> orderCancelledAtTimestamp = Optional.empty();
        private Optional<Boolean> orderCancelled = Optional.empty();
        private Optional<OffsetDateTime> exceptionAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> completedAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> inProgressAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();
        private Optional<OrderStatusEnum1> status = Optional.empty();
        private Optional<String> offChrtShipperOrgId = Optional.empty();
        private Optional<String> shipperOrgId = Optional.empty();
        private Optional<String> forwarderOrgId = Optional.empty();
        private Optional<List<String>> taskGroupIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Order1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.id(other.getId());
            this.shortId(other.getShortId());
            this.taskGroupIds(other.getTaskGroupIds());
            this.createdByOrgType(other.getCreatedByOrgType());
            this.createdByOrgId(other.getCreatedByOrgId());
            this.createdByUserId(other.getCreatedByUserId());
            this.forwarderOrgId(other.getForwarderOrgId());
            this.shipperOrgId(other.getShipperOrgId());
            this.offChrtShipperOrgId(other.getOffChrtShipperOrgId());
            this.status(other.getStatus());
            this.draftStartedAtTimestamp(other.getDraftStartedAtTimestamp());
            this.stagedAtTimestamp(other.getStagedAtTimestamp());
            this.inProgressAtTimestamp(other.getInProgressAtTimestamp());
            this.completedAtTimestamp(other.getCompletedAtTimestamp());
            this.exceptionAtTimestamp(other.getExceptionAtTimestamp());
            this.orderCancelled(other.getOrderCancelled());
            this.orderCancelledAtTimestamp(other.getOrderCancelledAtTimestamp());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public ShortIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="short_id")
        public CreatedByOrgTypeStage shortId(@NotNull String shortId) {
            this.shortId = Objects.requireNonNull(shortId, "shortId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_org_type")
        public CreatedByOrgIdStage createdByOrgType(@NotNull OrgTypeEnum createdByOrgType) {
            this.createdByOrgType = Objects.requireNonNull(createdByOrgType, "createdByOrgType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_org_id")
        public CreatedByUserIdStage createdByOrgId(@NotNull String createdByOrgId) {
            this.createdByOrgId = Objects.requireNonNull(createdByOrgId, "createdByOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_by_user_id")
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String createdByUserId) {
            this.createdByUserId = Objects.requireNonNull(createdByUserId, "createdByUserId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="draft_started_at_timestamp")
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime draftStartedAtTimestamp) {
            this.draftStartedAtTimestamp = Objects.requireNonNull(draftStartedAtTimestamp, "draftStartedAtTimestamp must not be null");
            return this;
        }

        @Override
        public _FinalStage orderCancelledAtTimestamp(Nullable<OffsetDateTime> orderCancelledAtTimestamp) {
            this.orderCancelledAtTimestamp = orderCancelledAtTimestamp.isNull() ? null : (orderCancelledAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(orderCancelledAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage orderCancelledAtTimestamp(OffsetDateTime orderCancelledAtTimestamp) {
            this.orderCancelledAtTimestamp = Optional.ofNullable(orderCancelledAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="order_cancelled_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage orderCancelledAtTimestamp(Optional<OffsetDateTime> orderCancelledAtTimestamp) {
            this.orderCancelledAtTimestamp = orderCancelledAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage orderCancelled(Boolean orderCancelled) {
            this.orderCancelled = Optional.ofNullable(orderCancelled);
            return this;
        }

        @Override
        @JsonSetter(value="order_cancelled", nulls=Nulls.SKIP)
        public _FinalStage orderCancelled(Optional<Boolean> orderCancelled) {
            this.orderCancelled = orderCancelled;
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp.isNull() ? null : (exceptionAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(exceptionAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage exceptionAtTimestamp(OffsetDateTime exceptionAtTimestamp) {
            this.exceptionAtTimestamp = Optional.ofNullable(exceptionAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="exception_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> exceptionAtTimestamp) {
            this.exceptionAtTimestamp = exceptionAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp.isNull() ? null : (completedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(completedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage completedAtTimestamp(OffsetDateTime completedAtTimestamp) {
            this.completedAtTimestamp = Optional.ofNullable(completedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="completed_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> completedAtTimestamp) {
            this.completedAtTimestamp = completedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> inProgressAtTimestamp) {
            this.inProgressAtTimestamp = inProgressAtTimestamp.isNull() ? null : (inProgressAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(inProgressAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage inProgressAtTimestamp(OffsetDateTime inProgressAtTimestamp) {
            this.inProgressAtTimestamp = Optional.ofNullable(inProgressAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="in_progress_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> inProgressAtTimestamp) {
            this.inProgressAtTimestamp = inProgressAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp.isNull() ? null : (stagedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(stagedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="staged_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage status(OrderStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<OrderStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(Nullable<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId.isNull() ? null : (offChrtShipperOrgId.isEmpty() ? Optional.empty() : Optional.of(offChrtShipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgId(String offChrtShipperOrgId) {
            this.offChrtShipperOrgId = Optional.ofNullable(offChrtShipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="off_chrt_shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage offChrtShipperOrgId(Optional<String> offChrtShipperOrgId) {
            this.offChrtShipperOrgId = offChrtShipperOrgId;
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(Nullable<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId.isNull() ? null : (shipperOrgId.isEmpty() ? Optional.empty() : Optional.of(shipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage shipperOrgId(String shipperOrgId) {
            this.shipperOrgId = Optional.ofNullable(shipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage shipperOrgId(Optional<String> shipperOrgId) {
            this.shipperOrgId = shipperOrgId;
            return this;
        }

        @Override
        public _FinalStage forwarderOrgId(Nullable<String> forwarderOrgId) {
            this.forwarderOrgId = forwarderOrgId.isNull() ? null : (forwarderOrgId.isEmpty() ? Optional.empty() : Optional.of(forwarderOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage forwarderOrgId(String forwarderOrgId) {
            this.forwarderOrgId = Optional.ofNullable(forwarderOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="forwarder_org_id", nulls=Nulls.SKIP)
        public _FinalStage forwarderOrgId(Optional<String> forwarderOrgId) {
            this.forwarderOrgId = forwarderOrgId;
            return this;
        }

        @Override
        public _FinalStage taskGroupIds(List<String> taskGroupIds) {
            this.taskGroupIds = Optional.ofNullable(taskGroupIds);
            return this;
        }

        @Override
        @JsonSetter(value="task_group_ids", nulls=Nulls.SKIP)
        public _FinalStage taskGroupIds(Optional<List<String>> taskGroupIds) {
            this.taskGroupIds = taskGroupIds;
            return this;
        }

        @Override
        public Order1 build() {
            return new Order1(this.schemaVersion, this.id, this.shortId, this.taskGroupIds, this.createdByOrgType, this.createdByOrgId, this.createdByUserId, this.forwarderOrgId, this.shipperOrgId, this.offChrtShipperOrgId, this.status, this.draftStartedAtTimestamp, this.stagedAtTimestamp, this.inProgressAtTimestamp, this.completedAtTimestamp, this.exceptionAtTimestamp, this.orderCancelled, this.orderCancelledAtTimestamp, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Order1 build();

        public _FinalStage taskGroupIds(Optional<List<String>> var1);

        public _FinalStage taskGroupIds(List<String> var1);

        public _FinalStage forwarderOrgId(Optional<String> var1);

        public _FinalStage forwarderOrgId(String var1);

        public _FinalStage forwarderOrgId(Nullable<String> var1);

        public _FinalStage shipperOrgId(Optional<String> var1);

        public _FinalStage shipperOrgId(String var1);

        public _FinalStage shipperOrgId(Nullable<String> var1);

        public _FinalStage offChrtShipperOrgId(Optional<String> var1);

        public _FinalStage offChrtShipperOrgId(String var1);

        public _FinalStage offChrtShipperOrgId(Nullable<String> var1);

        public _FinalStage status(Optional<OrderStatusEnum1> var1);

        public _FinalStage status(OrderStatusEnum1 var1);

        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage stagedAtTimestamp(OffsetDateTime var1);

        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage inProgressAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage inProgressAtTimestamp(OffsetDateTime var1);

        public _FinalStage inProgressAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage completedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage completedAtTimestamp(OffsetDateTime var1);

        public _FinalStage completedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage exceptionAtTimestamp(OffsetDateTime var1);

        public _FinalStage exceptionAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage orderCancelled(Optional<Boolean> var1);

        public _FinalStage orderCancelled(Boolean var1);

        public _FinalStage orderCancelledAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage orderCancelledAtTimestamp(OffsetDateTime var1);

        public _FinalStage orderCancelledAtTimestamp(Nullable<OffsetDateTime> var1);
    }

    public static interface DraftStartedAtTimestampStage {
        public _FinalStage draftStartedAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface CreatedByUserIdStage {
        public DraftStartedAtTimestampStage createdByUserId(@NotNull String var1);
    }

    public static interface CreatedByOrgIdStage {
        public CreatedByUserIdStage createdByOrgId(@NotNull String var1);
    }

    public static interface CreatedByOrgTypeStage {
        public CreatedByOrgIdStage createdByOrgType(@NotNull OrgTypeEnum var1);
    }

    public static interface ShortIdStage {
        public CreatedByOrgTypeStage shortId(@NotNull String var1);
    }

    public static interface IdStage {
        public ShortIdStage id(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public IdStage schemaVersion(int var1);

        public Builder from(Order1 var1);
    }
}

