/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.Cargo1;
import com.chrt.api.types.Order1;
import com.chrt.api.types.TaskGroupExpanded;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrderDraftExpanded {
    private final Order1 order;
    private final Optional<String> forwarderOrgCompanyName;
    private final Optional<String> forwarderOrgHandle;
    private final Optional<String> shipperOrgCompanyName;
    private final Optional<String> offChrtShipperOrgCompanyName;
    private final Optional<List<TaskGroupExpanded>> taskGroupsExpanded;
    private final Optional<List<Cargo1>> cargos;
    private final Map<String, Object> additionalProperties;

    private OrderDraftExpanded(Order1 order, Optional<String> forwarderOrgCompanyName, Optional<String> forwarderOrgHandle, Optional<String> shipperOrgCompanyName, Optional<String> offChrtShipperOrgCompanyName, Optional<List<TaskGroupExpanded>> taskGroupsExpanded, Optional<List<Cargo1>> cargos, Map<String, Object> additionalProperties) {
        this.order = order;
        this.forwarderOrgCompanyName = forwarderOrgCompanyName;
        this.forwarderOrgHandle = forwarderOrgHandle;
        this.shipperOrgCompanyName = shipperOrgCompanyName;
        this.offChrtShipperOrgCompanyName = offChrtShipperOrgCompanyName;
        this.taskGroupsExpanded = taskGroupsExpanded;
        this.cargos = cargos;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order")
    public Order1 getOrder() {
        return this.order;
    }

    @JsonIgnore
    public Optional<String> getForwarderOrgCompanyName() {
        if (this.forwarderOrgCompanyName == null) {
            return Optional.empty();
        }
        return this.forwarderOrgCompanyName;
    }

    @JsonIgnore
    public Optional<String> getForwarderOrgHandle() {
        if (this.forwarderOrgHandle == null) {
            return Optional.empty();
        }
        return this.forwarderOrgHandle;
    }

    @JsonIgnore
    public Optional<String> getShipperOrgCompanyName() {
        if (this.shipperOrgCompanyName == null) {
            return Optional.empty();
        }
        return this.shipperOrgCompanyName;
    }

    @JsonIgnore
    public Optional<String> getOffChrtShipperOrgCompanyName() {
        if (this.offChrtShipperOrgCompanyName == null) {
            return Optional.empty();
        }
        return this.offChrtShipperOrgCompanyName;
    }

    @JsonIgnore
    public Optional<List<TaskGroupExpanded>> getTaskGroupsExpanded() {
        if (this.taskGroupsExpanded == null) {
            return Optional.empty();
        }
        return this.taskGroupsExpanded;
    }

    @JsonIgnore
    public Optional<List<Cargo1>> getCargos() {
        if (this.cargos == null) {
            return Optional.empty();
        }
        return this.cargos;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="forwarder_org_company_name")
    private Optional<String> _getForwarderOrgCompanyName() {
        return this.forwarderOrgCompanyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="forwarder_org_handle")
    private Optional<String> _getForwarderOrgHandle() {
        return this.forwarderOrgHandle;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_org_company_name")
    private Optional<String> _getShipperOrgCompanyName() {
        return this.shipperOrgCompanyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="off_chrt_shipper_org_company_name")
    private Optional<String> _getOffChrtShipperOrgCompanyName() {
        return this.offChrtShipperOrgCompanyName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="task_groups_expanded")
    private Optional<List<TaskGroupExpanded>> _getTaskGroupsExpanded() {
        return this.taskGroupsExpanded;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cargos")
    private Optional<List<Cargo1>> _getCargos() {
        return this.cargos;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrderDraftExpanded && this.equalTo((OrderDraftExpanded)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrderDraftExpanded other) {
        return this.order.equals(other.order) && this.forwarderOrgCompanyName.equals(other.forwarderOrgCompanyName) && this.forwarderOrgHandle.equals(other.forwarderOrgHandle) && this.shipperOrgCompanyName.equals(other.shipperOrgCompanyName) && this.offChrtShipperOrgCompanyName.equals(other.offChrtShipperOrgCompanyName) && this.taskGroupsExpanded.equals(other.taskGroupsExpanded) && this.cargos.equals(other.cargos);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.forwarderOrgCompanyName, this.forwarderOrgHandle, this.shipperOrgCompanyName, this.offChrtShipperOrgCompanyName, this.taskGroupsExpanded, this.cargos);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderStage,
    _FinalStage {
        private Order1 order;
        private Optional<List<Cargo1>> cargos = Optional.empty();
        private Optional<List<TaskGroupExpanded>> taskGroupsExpanded = Optional.empty();
        private Optional<String> offChrtShipperOrgCompanyName = Optional.empty();
        private Optional<String> shipperOrgCompanyName = Optional.empty();
        private Optional<String> forwarderOrgHandle = Optional.empty();
        private Optional<String> forwarderOrgCompanyName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrderDraftExpanded other) {
            this.order(other.getOrder());
            this.forwarderOrgCompanyName(other.getForwarderOrgCompanyName());
            this.forwarderOrgHandle(other.getForwarderOrgHandle());
            this.shipperOrgCompanyName(other.getShipperOrgCompanyName());
            this.offChrtShipperOrgCompanyName(other.getOffChrtShipperOrgCompanyName());
            this.taskGroupsExpanded(other.getTaskGroupsExpanded());
            this.cargos(other.getCargos());
            return this;
        }

        @Override
        @JsonSetter(value="order")
        public _FinalStage order(@NotNull Order1 order) {
            this.order = Objects.requireNonNull(order, "order must not be null");
            return this;
        }

        @Override
        public _FinalStage cargos(Nullable<List<Cargo1>> cargos) {
            this.cargos = cargos.isNull() ? null : (cargos.isEmpty() ? Optional.empty() : Optional.of(cargos.get()));
            return this;
        }

        @Override
        public _FinalStage cargos(List<Cargo1> cargos) {
            this.cargos = Optional.ofNullable(cargos);
            return this;
        }

        @Override
        @JsonSetter(value="cargos", nulls=Nulls.SKIP)
        public _FinalStage cargos(Optional<List<Cargo1>> cargos) {
            this.cargos = cargos;
            return this;
        }

        @Override
        public _FinalStage taskGroupsExpanded(Nullable<List<TaskGroupExpanded>> taskGroupsExpanded) {
            this.taskGroupsExpanded = taskGroupsExpanded.isNull() ? null : (taskGroupsExpanded.isEmpty() ? Optional.empty() : Optional.of(taskGroupsExpanded.get()));
            return this;
        }

        @Override
        public _FinalStage taskGroupsExpanded(List<TaskGroupExpanded> taskGroupsExpanded) {
            this.taskGroupsExpanded = Optional.ofNullable(taskGroupsExpanded);
            return this;
        }

        @Override
        @JsonSetter(value="task_groups_expanded", nulls=Nulls.SKIP)
        public _FinalStage taskGroupsExpanded(Optional<List<TaskGroupExpanded>> taskGroupsExpanded) {
            this.taskGroupsExpanded = taskGroupsExpanded;
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgCompanyName(Nullable<String> offChrtShipperOrgCompanyName) {
            this.offChrtShipperOrgCompanyName = offChrtShipperOrgCompanyName.isNull() ? null : (offChrtShipperOrgCompanyName.isEmpty() ? Optional.empty() : Optional.of(offChrtShipperOrgCompanyName.get()));
            return this;
        }

        @Override
        public _FinalStage offChrtShipperOrgCompanyName(String offChrtShipperOrgCompanyName) {
            this.offChrtShipperOrgCompanyName = Optional.ofNullable(offChrtShipperOrgCompanyName);
            return this;
        }

        @Override
        @JsonSetter(value="off_chrt_shipper_org_company_name", nulls=Nulls.SKIP)
        public _FinalStage offChrtShipperOrgCompanyName(Optional<String> offChrtShipperOrgCompanyName) {
            this.offChrtShipperOrgCompanyName = offChrtShipperOrgCompanyName;
            return this;
        }

        @Override
        public _FinalStage shipperOrgCompanyName(Nullable<String> shipperOrgCompanyName) {
            this.shipperOrgCompanyName = shipperOrgCompanyName.isNull() ? null : (shipperOrgCompanyName.isEmpty() ? Optional.empty() : Optional.of(shipperOrgCompanyName.get()));
            return this;
        }

        @Override
        public _FinalStage shipperOrgCompanyName(String shipperOrgCompanyName) {
            this.shipperOrgCompanyName = Optional.ofNullable(shipperOrgCompanyName);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_org_company_name", nulls=Nulls.SKIP)
        public _FinalStage shipperOrgCompanyName(Optional<String> shipperOrgCompanyName) {
            this.shipperOrgCompanyName = shipperOrgCompanyName;
            return this;
        }

        @Override
        public _FinalStage forwarderOrgHandle(Nullable<String> forwarderOrgHandle) {
            this.forwarderOrgHandle = forwarderOrgHandle.isNull() ? null : (forwarderOrgHandle.isEmpty() ? Optional.empty() : Optional.of(forwarderOrgHandle.get()));
            return this;
        }

        @Override
        public _FinalStage forwarderOrgHandle(String forwarderOrgHandle) {
            this.forwarderOrgHandle = Optional.ofNullable(forwarderOrgHandle);
            return this;
        }

        @Override
        @JsonSetter(value="forwarder_org_handle", nulls=Nulls.SKIP)
        public _FinalStage forwarderOrgHandle(Optional<String> forwarderOrgHandle) {
            this.forwarderOrgHandle = forwarderOrgHandle;
            return this;
        }

        @Override
        public _FinalStage forwarderOrgCompanyName(Nullable<String> forwarderOrgCompanyName) {
            this.forwarderOrgCompanyName = forwarderOrgCompanyName.isNull() ? null : (forwarderOrgCompanyName.isEmpty() ? Optional.empty() : Optional.of(forwarderOrgCompanyName.get()));
            return this;
        }

        @Override
        public _FinalStage forwarderOrgCompanyName(String forwarderOrgCompanyName) {
            this.forwarderOrgCompanyName = Optional.ofNullable(forwarderOrgCompanyName);
            return this;
        }

        @Override
        @JsonSetter(value="forwarder_org_company_name", nulls=Nulls.SKIP)
        public _FinalStage forwarderOrgCompanyName(Optional<String> forwarderOrgCompanyName) {
            this.forwarderOrgCompanyName = forwarderOrgCompanyName;
            return this;
        }

        @Override
        public OrderDraftExpanded build() {
            return new OrderDraftExpanded(this.order, this.forwarderOrgCompanyName, this.forwarderOrgHandle, this.shipperOrgCompanyName, this.offChrtShipperOrgCompanyName, this.taskGroupsExpanded, this.cargos, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrderDraftExpanded build();

        public _FinalStage forwarderOrgCompanyName(Optional<String> var1);

        public _FinalStage forwarderOrgCompanyName(String var1);

        public _FinalStage forwarderOrgCompanyName(Nullable<String> var1);

        public _FinalStage forwarderOrgHandle(Optional<String> var1);

        public _FinalStage forwarderOrgHandle(String var1);

        public _FinalStage forwarderOrgHandle(Nullable<String> var1);

        public _FinalStage shipperOrgCompanyName(Optional<String> var1);

        public _FinalStage shipperOrgCompanyName(String var1);

        public _FinalStage shipperOrgCompanyName(Nullable<String> var1);

        public _FinalStage offChrtShipperOrgCompanyName(Optional<String> var1);

        public _FinalStage offChrtShipperOrgCompanyName(String var1);

        public _FinalStage offChrtShipperOrgCompanyName(Nullable<String> var1);

        public _FinalStage taskGroupsExpanded(Optional<List<TaskGroupExpanded>> var1);

        public _FinalStage taskGroupsExpanded(List<TaskGroupExpanded> var1);

        public _FinalStage taskGroupsExpanded(Nullable<List<TaskGroupExpanded>> var1);

        public _FinalStage cargos(Optional<List<Cargo1>> var1);

        public _FinalStage cargos(List<Cargo1> var1);

        public _FinalStage cargos(Nullable<List<Cargo1>> var1);
    }

    public static interface OrderStage {
        public _FinalStage order(@NotNull Order1 var1);

        public Builder from(OrderDraftExpanded var1);
    }
}

