/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.OrgRoleEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class OrgMemberDetails {
    private final OrgRoleEnum role;
    private final String userId;
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final Map<String, Object> additionalProperties;

    private OrgMemberDetails(OrgRoleEnum role, String userId, Optional<String> firstName, Optional<String> lastName, Map<String, Object> additionalProperties) {
        this.role = role;
        this.userId = userId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="role")
    public OrgRoleEnum getRole() {
        return this.role;
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<String> getFirstName() {
        if (this.firstName == null) {
            return Optional.empty();
        }
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> getLastName() {
        if (this.lastName == null) {
            return Optional.empty();
        }
        return this.lastName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="first_name")
    private Optional<String> _getFirstName() {
        return this.firstName;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_name")
    private Optional<String> _getLastName() {
        return this.lastName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OrgMemberDetails && this.equalTo((OrgMemberDetails)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OrgMemberDetails other) {
        return this.role.equals(other.role) && this.userId.equals(other.userId) && this.firstName.equals(other.firstName) && this.lastName.equals(other.lastName);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.userId, this.firstName, this.lastName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RoleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RoleStage,
    UserIdStage,
    _FinalStage {
        private OrgRoleEnum role;
        private String userId;
        private Optional<String> lastName = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(OrgMemberDetails other) {
            this.role(other.getRole());
            this.userId(other.getUserId());
            this.firstName(other.getFirstName());
            this.lastName(other.getLastName());
            return this;
        }

        @Override
        @JsonSetter(value="role")
        public UserIdStage role(@NotNull OrgRoleEnum role) {
            this.role = Objects.requireNonNull(role, "role must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        public _FinalStage lastName(Nullable<String> lastName) {
            this.lastName = lastName.isNull() ? null : (lastName.isEmpty() ? Optional.empty() : Optional.of(lastName.get()));
            return this;
        }

        @Override
        public _FinalStage lastName(String lastName) {
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        @Override
        @JsonSetter(value="last_name", nulls=Nulls.SKIP)
        public _FinalStage lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        @Override
        public _FinalStage firstName(Nullable<String> firstName) {
            this.firstName = firstName.isNull() ? null : (firstName.isEmpty() ? Optional.empty() : Optional.of(firstName.get()));
            return this;
        }

        @Override
        public _FinalStage firstName(String firstName) {
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        @Override
        @JsonSetter(value="first_name", nulls=Nulls.SKIP)
        public _FinalStage firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        @Override
        public OrgMemberDetails build() {
            return new OrgMemberDetails(this.role, this.userId, this.firstName, this.lastName, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public OrgMemberDetails build();

        public _FinalStage firstName(Optional<String> var1);

        public _FinalStage firstName(String var1);

        public _FinalStage firstName(Nullable<String> var1);

        public _FinalStage lastName(Optional<String> var1);

        public _FinalStage lastName(String var1);

        public _FinalStage lastName(Nullable<String> var1);
    }

    public static interface UserIdStage {
        public _FinalStage userId(@NotNull String var1);
    }

    public static interface RoleStage {
        public UserIdStage role(@NotNull OrgRoleEnum var1);

        public Builder from(OrgMemberDetails var1);
    }
}

