/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.Coordinates;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Point {
    private final Optional<List<Object>> bbox;
    private final Coordinates coordinates;
    private final Map<String, Object> additionalProperties;

    private Point(Optional<List<Object>> bbox, Coordinates coordinates, Map<String, Object> additionalProperties) {
        this.bbox = bbox;
        this.coordinates = coordinates;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<List<Object>> getBbox() {
        if (this.bbox == null) {
            return Optional.empty();
        }
        return this.bbox;
    }

    @JsonProperty(value="coordinates")
    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="bbox")
    private Optional<List<Object>> _getBbox() {
        return this.bbox;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Point && this.equalTo((Point)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Point other) {
        return this.bbox.equals(other.bbox) && this.coordinates.equals(other.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.bbox, this.coordinates);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CoordinatesStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CoordinatesStage,
    _FinalStage {
        private Coordinates coordinates;
        private Optional<List<Object>> bbox = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Point other) {
            this.bbox(other.getBbox());
            this.coordinates(other.getCoordinates());
            return this;
        }

        @Override
        @JsonSetter(value="coordinates")
        public _FinalStage coordinates(@NotNull Coordinates coordinates) {
            this.coordinates = Objects.requireNonNull(coordinates, "coordinates must not be null");
            return this;
        }

        @Override
        public _FinalStage bbox(Nullable<List<Object>> bbox) {
            this.bbox = bbox.isNull() ? null : (bbox.isEmpty() ? Optional.empty() : Optional.of(bbox.get()));
            return this;
        }

        @Override
        public _FinalStage bbox(List<Object> bbox) {
            this.bbox = Optional.ofNullable(bbox);
            return this;
        }

        @Override
        @JsonSetter(value="bbox", nulls=Nulls.SKIP)
        public _FinalStage bbox(Optional<List<Object>> bbox) {
            this.bbox = bbox;
            return this;
        }

        @Override
        public Point build() {
            return new Point(this.bbox, this.coordinates, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Point build();

        public _FinalStage bbox(Optional<List<Object>> var1);

        public _FinalStage bbox(List<Object> var1);

        public _FinalStage bbox(Nullable<List<Object>> var1);
    }

    public static interface CoordinatesStage {
        public _FinalStage coordinates(@NotNull Coordinates var1);

        public Builder from(Point var1);
    }
}

