/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.RateSheet1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RateSheetListResponse {
    private final List<RateSheet1> rateSheets;
    private final int totalCount;
    private final Map<String, Object> additionalProperties;

    private RateSheetListResponse(List<RateSheet1> rateSheets, int totalCount, Map<String, Object> additionalProperties) {
        this.rateSheets = rateSheets;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="rate_sheets")
    public List<RateSheet1> getRateSheets() {
        return this.rateSheets;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RateSheetListResponse && this.equalTo((RateSheetListResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RateSheetListResponse other) {
        return this.rateSheets.equals(other.rateSheets) && this.totalCount == other.totalCount;
    }

    public int hashCode() {
        return Objects.hash(this.rateSheets, this.totalCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private List<RateSheet1> rateSheets = new ArrayList<RateSheet1>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RateSheetListResponse other) {
            this.rateSheets(other.getRateSheets());
            this.totalCount(other.getTotalCount());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllRateSheets(List<RateSheet1> rateSheets) {
            if (rateSheets != null) {
                this.rateSheets.addAll(rateSheets);
            }
            return this;
        }

        @Override
        public _FinalStage addRateSheets(RateSheet1 rateSheets) {
            this.rateSheets.add(rateSheets);
            return this;
        }

        @Override
        @JsonSetter(value="rate_sheets", nulls=Nulls.SKIP)
        public _FinalStage rateSheets(List<RateSheet1> rateSheets) {
            this.rateSheets.clear();
            if (rateSheets != null) {
                this.rateSheets.addAll(rateSheets);
            }
            return this;
        }

        @Override
        public RateSheetListResponse build() {
            return new RateSheetListResponse(this.rateSheets, this.totalCount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RateSheetListResponse build();

        public _FinalStage rateSheets(List<RateSheet1> var1);

        public _FinalStage addRateSheets(RateSheet1 var1);

        public _FinalStage addAllRateSheets(List<RateSheet1> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(RateSheetListResponse var1);
    }
}

