/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Session1 {
    private final int schemaVersion;
    private final String deviceId;
    private final String deviceMacAddress;
    private final String orgId;
    private final Optional<String> comments;
    private final Optional<Boolean> recording;
    private final Optional<Boolean> terminated;
    private final OffsetDateTime sessionCreatedAtTimestamp;
    private final Optional<OffsetDateTime> recordingInitiatedAtTimestamp;
    private final Optional<Boolean> public_;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private Session1(int schemaVersion, String deviceId, String deviceMacAddress, String orgId, Optional<String> comments, Optional<Boolean> recording, Optional<Boolean> terminated, OffsetDateTime sessionCreatedAtTimestamp, Optional<OffsetDateTime> recordingInitiatedAtTimestamp, Optional<Boolean> public_, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.deviceId = deviceId;
        this.deviceMacAddress = deviceMacAddress;
        this.orgId = orgId;
        this.comments = comments;
        this.recording = recording;
        this.terminated = terminated;
        this.sessionCreatedAtTimestamp = sessionCreatedAtTimestamp;
        this.recordingInitiatedAtTimestamp = recordingInitiatedAtTimestamp;
        this.public_ = public_;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="device_mac_address")
    public String getDeviceMacAddress() {
        return this.deviceMacAddress;
    }

    @JsonProperty(value="org_id")
    public String getOrgId() {
        return this.orgId;
    }

    @JsonIgnore
    public Optional<String> getComments() {
        if (this.comments == null) {
            return Optional.empty();
        }
        return this.comments;
    }

    @JsonProperty(value="recording")
    public Optional<Boolean> getRecording() {
        return this.recording;
    }

    @JsonProperty(value="terminated")
    public Optional<Boolean> getTerminated() {
        return this.terminated;
    }

    @JsonProperty(value="session_created_at_timestamp")
    public OffsetDateTime getSessionCreatedAtTimestamp() {
        return this.sessionCreatedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getRecordingInitiatedAtTimestamp() {
        if (this.recordingInitiatedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.recordingInitiatedAtTimestamp;
    }

    @JsonProperty(value="public")
    public Optional<Boolean> getPublic() {
        return this.public_;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="comments")
    private Optional<String> _getComments() {
        return this.comments;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="recording_initiated_at_timestamp")
    private Optional<OffsetDateTime> _getRecordingInitiatedAtTimestamp() {
        return this.recordingInitiatedAtTimestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Session1 && this.equalTo((Session1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Session1 other) {
        return this.schemaVersion == other.schemaVersion && this.deviceId.equals(other.deviceId) && this.deviceMacAddress.equals(other.deviceMacAddress) && this.orgId.equals(other.orgId) && this.comments.equals(other.comments) && this.recording.equals(other.recording) && this.terminated.equals(other.terminated) && this.sessionCreatedAtTimestamp.equals(other.sessionCreatedAtTimestamp) && this.recordingInitiatedAtTimestamp.equals(other.recordingInitiatedAtTimestamp) && this.public_.equals(other.public_) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.deviceId, this.deviceMacAddress, this.orgId, this.comments, this.recording, this.terminated, this.sessionCreatedAtTimestamp, this.recordingInitiatedAtTimestamp, this.public_, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    DeviceIdStage,
    DeviceMacAddressStage,
    OrgIdStage,
    SessionCreatedAtTimestampStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String deviceId;
        private String deviceMacAddress;
        private String orgId;
        private OffsetDateTime sessionCreatedAtTimestamp;
        private String id;
        private Optional<Boolean> public_ = Optional.empty();
        private Optional<OffsetDateTime> recordingInitiatedAtTimestamp = Optional.empty();
        private Optional<Boolean> terminated = Optional.empty();
        private Optional<Boolean> recording = Optional.empty();
        private Optional<String> comments = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Session1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.deviceId(other.getDeviceId());
            this.deviceMacAddress(other.getDeviceMacAddress());
            this.orgId(other.getOrgId());
            this.comments(other.getComments());
            this.recording(other.getRecording());
            this.terminated(other.getTerminated());
            this.sessionCreatedAtTimestamp(other.getSessionCreatedAtTimestamp());
            this.recordingInitiatedAtTimestamp(other.getRecordingInitiatedAtTimestamp());
            this.public_(other.getPublic());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public DeviceIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public DeviceMacAddressStage deviceId(@NotNull String deviceId) {
            this.deviceId = Objects.requireNonNull(deviceId, "deviceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="device_mac_address")
        public OrgIdStage deviceMacAddress(@NotNull String deviceMacAddress) {
            this.deviceMacAddress = Objects.requireNonNull(deviceMacAddress, "deviceMacAddress must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="org_id")
        public SessionCreatedAtTimestampStage orgId(@NotNull String orgId) {
            this.orgId = Objects.requireNonNull(orgId, "orgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="session_created_at_timestamp")
        public IdStage sessionCreatedAtTimestamp(@NotNull OffsetDateTime sessionCreatedAtTimestamp) {
            this.sessionCreatedAtTimestamp = Objects.requireNonNull(sessionCreatedAtTimestamp, "sessionCreatedAtTimestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage public_(Boolean public_) {
            this.public_ = Optional.ofNullable(public_);
            return this;
        }

        @Override
        @JsonSetter(value="public", nulls=Nulls.SKIP)
        public _FinalStage public_(Optional<Boolean> public_) {
            this.public_ = public_;
            return this;
        }

        @Override
        public _FinalStage recordingInitiatedAtTimestamp(Nullable<OffsetDateTime> recordingInitiatedAtTimestamp) {
            this.recordingInitiatedAtTimestamp = recordingInitiatedAtTimestamp.isNull() ? null : (recordingInitiatedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(recordingInitiatedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage recordingInitiatedAtTimestamp(OffsetDateTime recordingInitiatedAtTimestamp) {
            this.recordingInitiatedAtTimestamp = Optional.ofNullable(recordingInitiatedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="recording_initiated_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage recordingInitiatedAtTimestamp(Optional<OffsetDateTime> recordingInitiatedAtTimestamp) {
            this.recordingInitiatedAtTimestamp = recordingInitiatedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage terminated(Boolean terminated) {
            this.terminated = Optional.ofNullable(terminated);
            return this;
        }

        @Override
        @JsonSetter(value="terminated", nulls=Nulls.SKIP)
        public _FinalStage terminated(Optional<Boolean> terminated) {
            this.terminated = terminated;
            return this;
        }

        @Override
        public _FinalStage recording(Boolean recording) {
            this.recording = Optional.ofNullable(recording);
            return this;
        }

        @Override
        @JsonSetter(value="recording", nulls=Nulls.SKIP)
        public _FinalStage recording(Optional<Boolean> recording) {
            this.recording = recording;
            return this;
        }

        @Override
        public _FinalStage comments(Nullable<String> comments) {
            this.comments = comments.isNull() ? null : (comments.isEmpty() ? Optional.empty() : Optional.of(comments.get()));
            return this;
        }

        @Override
        public _FinalStage comments(String comments) {
            this.comments = Optional.ofNullable(comments);
            return this;
        }

        @Override
        @JsonSetter(value="comments", nulls=Nulls.SKIP)
        public _FinalStage comments(Optional<String> comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public Session1 build() {
            return new Session1(this.schemaVersion, this.deviceId, this.deviceMacAddress, this.orgId, this.comments, this.recording, this.terminated, this.sessionCreatedAtTimestamp, this.recordingInitiatedAtTimestamp, this.public_, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Session1 build();

        public _FinalStage comments(Optional<String> var1);

        public _FinalStage comments(String var1);

        public _FinalStage comments(Nullable<String> var1);

        public _FinalStage recording(Optional<Boolean> var1);

        public _FinalStage recording(Boolean var1);

        public _FinalStage terminated(Optional<Boolean> var1);

        public _FinalStage terminated(Boolean var1);

        public _FinalStage recordingInitiatedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage recordingInitiatedAtTimestamp(OffsetDateTime var1);

        public _FinalStage recordingInitiatedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage public_(Optional<Boolean> var1);

        public _FinalStage public_(Boolean var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface SessionCreatedAtTimestampStage {
        public IdStage sessionCreatedAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface OrgIdStage {
        public SessionCreatedAtTimestampStage orgId(@NotNull String var1);
    }

    public static interface DeviceMacAddressStage {
        public OrgIdStage deviceMacAddress(@NotNull String var1);
    }

    public static interface DeviceIdStage {
        public DeviceMacAddressStage deviceId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public DeviceIdStage schemaVersion(int var1);

        public Builder from(Session1 var1);
    }
}

