/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SetFlightInfoReq {
    private final Optional<String> flightNumber;
    private final Optional<List<String>> faFlightIds;
    private final Map<String, Object> additionalProperties;

    private SetFlightInfoReq(Optional<String> flightNumber, Optional<List<String>> faFlightIds, Map<String, Object> additionalProperties) {
        this.flightNumber = flightNumber;
        this.faFlightIds = faFlightIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<String> getFlightNumber() {
        if (this.flightNumber == null) {
            return Optional.empty();
        }
        return this.flightNumber;
    }

    @JsonIgnore
    public Optional<List<String>> getFaFlightIds() {
        if (this.faFlightIds == null) {
            return Optional.empty();
        }
        return this.faFlightIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="flight_number")
    private Optional<String> _getFlightNumber() {
        return this.flightNumber;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="fa_flight_ids")
    private Optional<List<String>> _getFaFlightIds() {
        return this.faFlightIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SetFlightInfoReq && this.equalTo((SetFlightInfoReq)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SetFlightInfoReq other) {
        return this.flightNumber.equals(other.flightNumber) && this.faFlightIds.equals(other.faFlightIds);
    }

    public int hashCode() {
        return Objects.hash(this.flightNumber, this.faFlightIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> flightNumber = Optional.empty();
        private Optional<List<String>> faFlightIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SetFlightInfoReq other) {
            this.flightNumber(other.getFlightNumber());
            this.faFlightIds(other.getFaFlightIds());
            return this;
        }

        @JsonSetter(value="flight_number", nulls=Nulls.SKIP)
        public Builder flightNumber(Optional<String> flightNumber) {
            this.flightNumber = flightNumber;
            return this;
        }

        public Builder flightNumber(String flightNumber) {
            this.flightNumber = Optional.ofNullable(flightNumber);
            return this;
        }

        public Builder flightNumber(Nullable<String> flightNumber) {
            this.flightNumber = flightNumber.isNull() ? null : (flightNumber.isEmpty() ? Optional.empty() : Optional.of(flightNumber.get()));
            return this;
        }

        @JsonSetter(value="fa_flight_ids", nulls=Nulls.SKIP)
        public Builder faFlightIds(Optional<List<String>> faFlightIds) {
            this.faFlightIds = faFlightIds;
            return this;
        }

        public Builder faFlightIds(List<String> faFlightIds) {
            this.faFlightIds = Optional.ofNullable(faFlightIds);
            return this;
        }

        public Builder faFlightIds(Nullable<List<String>> faFlightIds) {
            this.faFlightIds = faFlightIds.isNull() ? null : (faFlightIds.isEmpty() ? Optional.empty() : Optional.of(faFlightIds.get()));
            return this;
        }

        public SetFlightInfoReq build() {
            return new SetFlightInfoReq(this.flightNumber, this.faFlightIds, this.additionalProperties);
        }
    }
}

