/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ShipperCourierConnection1 {
    private final int schemaVersion;
    private final String shipperOrgId;
    private final String courierOrgId;
    private final Optional<Boolean> connected;
    private final Optional<String> shipperCustomerIdForCourierStripeConnectAccount;
    private final Optional<String> defaultRateSheetRouted;
    private final Optional<String> defaultRateSheetOnDemand;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private ShipperCourierConnection1(int schemaVersion, String shipperOrgId, String courierOrgId, Optional<Boolean> connected, Optional<String> shipperCustomerIdForCourierStripeConnectAccount, Optional<String> defaultRateSheetRouted, Optional<String> defaultRateSheetOnDemand, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.shipperOrgId = shipperOrgId;
        this.courierOrgId = courierOrgId;
        this.connected = connected;
        this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
        this.defaultRateSheetRouted = defaultRateSheetRouted;
        this.defaultRateSheetOnDemand = defaultRateSheetOnDemand;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="shipper_org_id")
    public String getShipperOrgId() {
        return this.shipperOrgId;
    }

    @JsonProperty(value="courier_org_id")
    public String getCourierOrgId() {
        return this.courierOrgId;
    }

    @JsonProperty(value="connected")
    public Optional<Boolean> getConnected() {
        return this.connected;
    }

    @JsonIgnore
    public Optional<String> getShipperCustomerIdForCourierStripeConnectAccount() {
        if (this.shipperCustomerIdForCourierStripeConnectAccount == null) {
            return Optional.empty();
        }
        return this.shipperCustomerIdForCourierStripeConnectAccount;
    }

    @JsonIgnore
    public Optional<String> getDefaultRateSheetRouted() {
        if (this.defaultRateSheetRouted == null) {
            return Optional.empty();
        }
        return this.defaultRateSheetRouted;
    }

    @JsonIgnore
    public Optional<String> getDefaultRateSheetOnDemand() {
        if (this.defaultRateSheetOnDemand == null) {
            return Optional.empty();
        }
        return this.defaultRateSheetOnDemand;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_customer_id_for_courier_stripe_connect_account")
    private Optional<String> _getShipperCustomerIdForCourierStripeConnectAccount() {
        return this.shipperCustomerIdForCourierStripeConnectAccount;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="default_rate_sheet__routed")
    private Optional<String> _getDefaultRateSheetRouted() {
        return this.defaultRateSheetRouted;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="default_rate_sheet__on_demand")
    private Optional<String> _getDefaultRateSheetOnDemand() {
        return this.defaultRateSheetOnDemand;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ShipperCourierConnection1 && this.equalTo((ShipperCourierConnection1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperCourierConnection1 other) {
        return this.schemaVersion == other.schemaVersion && this.shipperOrgId.equals(other.shipperOrgId) && this.courierOrgId.equals(other.courierOrgId) && this.connected.equals(other.connected) && this.shipperCustomerIdForCourierStripeConnectAccount.equals(other.shipperCustomerIdForCourierStripeConnectAccount) && this.defaultRateSheetRouted.equals(other.defaultRateSheetRouted) && this.defaultRateSheetOnDemand.equals(other.defaultRateSheetOnDemand) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.shipperOrgId, this.courierOrgId, this.connected, this.shipperCustomerIdForCourierStripeConnectAccount, this.defaultRateSheetRouted, this.defaultRateSheetOnDemand, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    ShipperOrgIdStage,
    CourierOrgIdStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String shipperOrgId;
        private String courierOrgId;
        private String id;
        private Optional<String> defaultRateSheetOnDemand = Optional.empty();
        private Optional<String> defaultRateSheetRouted = Optional.empty();
        private Optional<String> shipperCustomerIdForCourierStripeConnectAccount = Optional.empty();
        private Optional<Boolean> connected = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ShipperCourierConnection1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.shipperOrgId(other.getShipperOrgId());
            this.courierOrgId(other.getCourierOrgId());
            this.connected(other.getConnected());
            this.shipperCustomerIdForCourierStripeConnectAccount(other.getShipperCustomerIdForCourierStripeConnectAccount());
            this.defaultRateSheetRouted(other.getDefaultRateSheetRouted());
            this.defaultRateSheetOnDemand(other.getDefaultRateSheetOnDemand());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public ShipperOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="shipper_org_id")
        public CourierOrgIdStage shipperOrgId(@NotNull String shipperOrgId) {
            this.shipperOrgId = Objects.requireNonNull(shipperOrgId, "shipperOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="courier_org_id")
        public IdStage courierOrgId(@NotNull String courierOrgId) {
            this.courierOrgId = Objects.requireNonNull(courierOrgId, "courierOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetOnDemand(Nullable<String> defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = defaultRateSheetOnDemand.isNull() ? null : (defaultRateSheetOnDemand.isEmpty() ? Optional.empty() : Optional.of(defaultRateSheetOnDemand.get()));
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetOnDemand(String defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = Optional.ofNullable(defaultRateSheetOnDemand);
            return this;
        }

        @Override
        @JsonSetter(value="default_rate_sheet__on_demand", nulls=Nulls.SKIP)
        public _FinalStage defaultRateSheetOnDemand(Optional<String> defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = defaultRateSheetOnDemand;
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetRouted(Nullable<String> defaultRateSheetRouted) {
            this.defaultRateSheetRouted = defaultRateSheetRouted.isNull() ? null : (defaultRateSheetRouted.isEmpty() ? Optional.empty() : Optional.of(defaultRateSheetRouted.get()));
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetRouted(String defaultRateSheetRouted) {
            this.defaultRateSheetRouted = Optional.ofNullable(defaultRateSheetRouted);
            return this;
        }

        @Override
        @JsonSetter(value="default_rate_sheet__routed", nulls=Nulls.SKIP)
        public _FinalStage defaultRateSheetRouted(Optional<String> defaultRateSheetRouted) {
            this.defaultRateSheetRouted = defaultRateSheetRouted;
            return this;
        }

        @Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(Nullable<String> shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount.isNull() ? null : (shipperCustomerIdForCourierStripeConnectAccount.isEmpty() ? Optional.empty() : Optional.of(shipperCustomerIdForCourierStripeConnectAccount.get()));
            return this;
        }

        @Override
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(String shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount = Optional.ofNullable(shipperCustomerIdForCourierStripeConnectAccount);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_customer_id_for_courier_stripe_connect_account", nulls=Nulls.SKIP)
        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(Optional<String> shipperCustomerIdForCourierStripeConnectAccount) {
            this.shipperCustomerIdForCourierStripeConnectAccount = shipperCustomerIdForCourierStripeConnectAccount;
            return this;
        }

        @Override
        public _FinalStage connected(Boolean connected) {
            this.connected = Optional.ofNullable(connected);
            return this;
        }

        @Override
        @JsonSetter(value="connected", nulls=Nulls.SKIP)
        public _FinalStage connected(Optional<Boolean> connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public ShipperCourierConnection1 build() {
            return new ShipperCourierConnection1(this.schemaVersion, this.shipperOrgId, this.courierOrgId, this.connected, this.shipperCustomerIdForCourierStripeConnectAccount, this.defaultRateSheetRouted, this.defaultRateSheetOnDemand, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ShipperCourierConnection1 build();

        public _FinalStage connected(Optional<Boolean> var1);

        public _FinalStage connected(Boolean var1);

        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(Optional<String> var1);

        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(String var1);

        public _FinalStage shipperCustomerIdForCourierStripeConnectAccount(Nullable<String> var1);

        public _FinalStage defaultRateSheetRouted(Optional<String> var1);

        public _FinalStage defaultRateSheetRouted(String var1);

        public _FinalStage defaultRateSheetRouted(Nullable<String> var1);

        public _FinalStage defaultRateSheetOnDemand(Optional<String> var1);

        public _FinalStage defaultRateSheetOnDemand(String var1);

        public _FinalStage defaultRateSheetOnDemand(Nullable<String> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface CourierOrgIdStage {
        public IdStage courierOrgId(@NotNull String var1);
    }

    public static interface ShipperOrgIdStage {
        public CourierOrgIdStage shipperOrgId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public ShipperOrgIdStage schemaVersion(int var1);

        public Builder from(ShipperCourierConnection1 var1);
    }
}

