/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ShipperForwarderConnection1 {
    private final int schemaVersion;
    private final String shipperOrgId;
    private final String forwarderOrgId;
    private final Optional<Boolean> connected;
    private final Optional<String> shipperCustomerIdForForwarderStripeConnectAccount;
    private final Optional<String> defaultRateSheetRouted;
    private final Optional<String> defaultRateSheetOnDemand;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private ShipperForwarderConnection1(int schemaVersion, String shipperOrgId, String forwarderOrgId, Optional<Boolean> connected, Optional<String> shipperCustomerIdForForwarderStripeConnectAccount, Optional<String> defaultRateSheetRouted, Optional<String> defaultRateSheetOnDemand, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.shipperOrgId = shipperOrgId;
        this.forwarderOrgId = forwarderOrgId;
        this.connected = connected;
        this.shipperCustomerIdForForwarderStripeConnectAccount = shipperCustomerIdForForwarderStripeConnectAccount;
        this.defaultRateSheetRouted = defaultRateSheetRouted;
        this.defaultRateSheetOnDemand = defaultRateSheetOnDemand;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="shipper_org_id")
    public String getShipperOrgId() {
        return this.shipperOrgId;
    }

    @JsonProperty(value="forwarder_org_id")
    public String getForwarderOrgId() {
        return this.forwarderOrgId;
    }

    @JsonProperty(value="connected")
    public Optional<Boolean> getConnected() {
        return this.connected;
    }

    @JsonIgnore
    public Optional<String> getShipperCustomerIdForForwarderStripeConnectAccount() {
        if (this.shipperCustomerIdForForwarderStripeConnectAccount == null) {
            return Optional.empty();
        }
        return this.shipperCustomerIdForForwarderStripeConnectAccount;
    }

    @JsonIgnore
    public Optional<String> getDefaultRateSheetRouted() {
        if (this.defaultRateSheetRouted == null) {
            return Optional.empty();
        }
        return this.defaultRateSheetRouted;
    }

    @JsonIgnore
    public Optional<String> getDefaultRateSheetOnDemand() {
        if (this.defaultRateSheetOnDemand == null) {
            return Optional.empty();
        }
        return this.defaultRateSheetOnDemand;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_customer_id_for_forwarder_stripe_connect_account")
    private Optional<String> _getShipperCustomerIdForForwarderStripeConnectAccount() {
        return this.shipperCustomerIdForForwarderStripeConnectAccount;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="default_rate_sheet__routed")
    private Optional<String> _getDefaultRateSheetRouted() {
        return this.defaultRateSheetRouted;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="default_rate_sheet__on_demand")
    private Optional<String> _getDefaultRateSheetOnDemand() {
        return this.defaultRateSheetOnDemand;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ShipperForwarderConnection1 && this.equalTo((ShipperForwarderConnection1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShipperForwarderConnection1 other) {
        return this.schemaVersion == other.schemaVersion && this.shipperOrgId.equals(other.shipperOrgId) && this.forwarderOrgId.equals(other.forwarderOrgId) && this.connected.equals(other.connected) && this.shipperCustomerIdForForwarderStripeConnectAccount.equals(other.shipperCustomerIdForForwarderStripeConnectAccount) && this.defaultRateSheetRouted.equals(other.defaultRateSheetRouted) && this.defaultRateSheetOnDemand.equals(other.defaultRateSheetOnDemand) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.shipperOrgId, this.forwarderOrgId, this.connected, this.shipperCustomerIdForForwarderStripeConnectAccount, this.defaultRateSheetRouted, this.defaultRateSheetOnDemand, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    ShipperOrgIdStage,
    ForwarderOrgIdStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String shipperOrgId;
        private String forwarderOrgId;
        private String id;
        private Optional<String> defaultRateSheetOnDemand = Optional.empty();
        private Optional<String> defaultRateSheetRouted = Optional.empty();
        private Optional<String> shipperCustomerIdForForwarderStripeConnectAccount = Optional.empty();
        private Optional<Boolean> connected = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ShipperForwarderConnection1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.shipperOrgId(other.getShipperOrgId());
            this.forwarderOrgId(other.getForwarderOrgId());
            this.connected(other.getConnected());
            this.shipperCustomerIdForForwarderStripeConnectAccount(other.getShipperCustomerIdForForwarderStripeConnectAccount());
            this.defaultRateSheetRouted(other.getDefaultRateSheetRouted());
            this.defaultRateSheetOnDemand(other.getDefaultRateSheetOnDemand());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public ShipperOrgIdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="shipper_org_id")
        public ForwarderOrgIdStage shipperOrgId(@NotNull String shipperOrgId) {
            this.shipperOrgId = Objects.requireNonNull(shipperOrgId, "shipperOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="forwarder_org_id")
        public IdStage forwarderOrgId(@NotNull String forwarderOrgId) {
            this.forwarderOrgId = Objects.requireNonNull(forwarderOrgId, "forwarderOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetOnDemand(Nullable<String> defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = defaultRateSheetOnDemand.isNull() ? null : (defaultRateSheetOnDemand.isEmpty() ? Optional.empty() : Optional.of(defaultRateSheetOnDemand.get()));
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetOnDemand(String defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = Optional.ofNullable(defaultRateSheetOnDemand);
            return this;
        }

        @Override
        @JsonSetter(value="default_rate_sheet__on_demand", nulls=Nulls.SKIP)
        public _FinalStage defaultRateSheetOnDemand(Optional<String> defaultRateSheetOnDemand) {
            this.defaultRateSheetOnDemand = defaultRateSheetOnDemand;
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetRouted(Nullable<String> defaultRateSheetRouted) {
            this.defaultRateSheetRouted = defaultRateSheetRouted.isNull() ? null : (defaultRateSheetRouted.isEmpty() ? Optional.empty() : Optional.of(defaultRateSheetRouted.get()));
            return this;
        }

        @Override
        public _FinalStage defaultRateSheetRouted(String defaultRateSheetRouted) {
            this.defaultRateSheetRouted = Optional.ofNullable(defaultRateSheetRouted);
            return this;
        }

        @Override
        @JsonSetter(value="default_rate_sheet__routed", nulls=Nulls.SKIP)
        public _FinalStage defaultRateSheetRouted(Optional<String> defaultRateSheetRouted) {
            this.defaultRateSheetRouted = defaultRateSheetRouted;
            return this;
        }

        @Override
        public _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(Nullable<String> shipperCustomerIdForForwarderStripeConnectAccount) {
            this.shipperCustomerIdForForwarderStripeConnectAccount = shipperCustomerIdForForwarderStripeConnectAccount.isNull() ? null : (shipperCustomerIdForForwarderStripeConnectAccount.isEmpty() ? Optional.empty() : Optional.of(shipperCustomerIdForForwarderStripeConnectAccount.get()));
            return this;
        }

        @Override
        public _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(String shipperCustomerIdForForwarderStripeConnectAccount) {
            this.shipperCustomerIdForForwarderStripeConnectAccount = Optional.ofNullable(shipperCustomerIdForForwarderStripeConnectAccount);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_customer_id_for_forwarder_stripe_connect_account", nulls=Nulls.SKIP)
        public _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(Optional<String> shipperCustomerIdForForwarderStripeConnectAccount) {
            this.shipperCustomerIdForForwarderStripeConnectAccount = shipperCustomerIdForForwarderStripeConnectAccount;
            return this;
        }

        @Override
        public _FinalStage connected(Boolean connected) {
            this.connected = Optional.ofNullable(connected);
            return this;
        }

        @Override
        @JsonSetter(value="connected", nulls=Nulls.SKIP)
        public _FinalStage connected(Optional<Boolean> connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public ShipperForwarderConnection1 build() {
            return new ShipperForwarderConnection1(this.schemaVersion, this.shipperOrgId, this.forwarderOrgId, this.connected, this.shipperCustomerIdForForwarderStripeConnectAccount, this.defaultRateSheetRouted, this.defaultRateSheetOnDemand, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ShipperForwarderConnection1 build();

        public _FinalStage connected(Optional<Boolean> var1);

        public _FinalStage connected(Boolean var1);

        public _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(Optional<String> var1);

        public _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(String var1);

        public _FinalStage shipperCustomerIdForForwarderStripeConnectAccount(Nullable<String> var1);

        public _FinalStage defaultRateSheetRouted(Optional<String> var1);

        public _FinalStage defaultRateSheetRouted(String var1);

        public _FinalStage defaultRateSheetRouted(Nullable<String> var1);

        public _FinalStage defaultRateSheetOnDemand(Optional<String> var1);

        public _FinalStage defaultRateSheetOnDemand(String var1);

        public _FinalStage defaultRateSheetOnDemand(Nullable<String> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface ForwarderOrgIdStage {
        public IdStage forwarderOrgId(@NotNull String var1);
    }

    public static interface ShipperOrgIdStage {
        public ForwarderOrgIdStage shipperOrgId(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public ShipperOrgIdStage schemaVersion(int var1);

        public Builder from(ShipperForwarderConnection1 var1);
    }
}

