/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.PaymentVectorTypeEnum1;
import com.chrt.api.types.SettlementTypeEnum1;
import com.chrt.api.types.StatementStatusEnum1;
import com.chrt.api.types.StripeConnectInvoiceStatusEnum;
import com.chrt.api.types.UnitsEnum;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Statement1 {
    private final int schemaVersion;
    private final String id;
    private final Optional<List<String>> lineItemGroupIds;
    private final int amount;
    private final Optional<UnitsEnum> units;
    private final Optional<String> stagedByUserId;
    private final SettlementTypeEnum1 settlementType;
    private final String ownedByOrgId;
    private final PaymentVectorTypeEnum1 paymentVectorType;
    private final Optional<String> paymentOriginOrgId;
    private final Optional<String> paymentOriginOffChrtShipperOrgId;
    private final Optional<String> paymentDestinationOrgId;
    private final Optional<String> paymentDestinationDriverId;
    private final Optional<StatementStatusEnum1> status;
    private final Optional<String> stripeInvoiceId;
    private final Optional<String> stripeInvoiceUrl;
    private final Optional<String> stripeInvoiceCreatedByUserId;
    private final Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus;
    private final Optional<OffsetDateTime> stagedAtTimestamp;
    private final Optional<OffsetDateTime> openedAtTimestamp;
    private final Optional<OffsetDateTime> paidAtTimestamp;
    private final Optional<OffsetDateTime> uncollectibleAtTimestamp;
    private final Optional<String> markedOpenByUserId;
    private final Optional<String> markedPaidByUserId;
    private final Optional<String> markedUncollectibleByUserId;
    private final Map<String, Object> additionalProperties;

    private Statement1(int schemaVersion, String id, Optional<List<String>> lineItemGroupIds, int amount, Optional<UnitsEnum> units, Optional<String> stagedByUserId, SettlementTypeEnum1 settlementType, String ownedByOrgId, PaymentVectorTypeEnum1 paymentVectorType, Optional<String> paymentOriginOrgId, Optional<String> paymentOriginOffChrtShipperOrgId, Optional<String> paymentDestinationOrgId, Optional<String> paymentDestinationDriverId, Optional<StatementStatusEnum1> status, Optional<String> stripeInvoiceId, Optional<String> stripeInvoiceUrl, Optional<String> stripeInvoiceCreatedByUserId, Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus, Optional<OffsetDateTime> stagedAtTimestamp, Optional<OffsetDateTime> openedAtTimestamp, Optional<OffsetDateTime> paidAtTimestamp, Optional<OffsetDateTime> uncollectibleAtTimestamp, Optional<String> markedOpenByUserId, Optional<String> markedPaidByUserId, Optional<String> markedUncollectibleByUserId, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.lineItemGroupIds = lineItemGroupIds;
        this.amount = amount;
        this.units = units;
        this.stagedByUserId = stagedByUserId;
        this.settlementType = settlementType;
        this.ownedByOrgId = ownedByOrgId;
        this.paymentVectorType = paymentVectorType;
        this.paymentOriginOrgId = paymentOriginOrgId;
        this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
        this.paymentDestinationOrgId = paymentDestinationOrgId;
        this.paymentDestinationDriverId = paymentDestinationDriverId;
        this.status = status;
        this.stripeInvoiceId = stripeInvoiceId;
        this.stripeInvoiceUrl = stripeInvoiceUrl;
        this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId;
        this.stripeInvoiceStatus = stripeInvoiceStatus;
        this.stagedAtTimestamp = stagedAtTimestamp;
        this.openedAtTimestamp = openedAtTimestamp;
        this.paidAtTimestamp = paidAtTimestamp;
        this.uncollectibleAtTimestamp = uncollectibleAtTimestamp;
        this.markedOpenByUserId = markedOpenByUserId;
        this.markedPaidByUserId = markedPaidByUserId;
        this.markedUncollectibleByUserId = markedUncollectibleByUserId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="line_item_group_ids")
    public Optional<List<String>> getLineItemGroupIds() {
        return this.lineItemGroupIds;
    }

    @JsonProperty(value="amount")
    public int getAmount() {
        return this.amount;
    }

    @JsonProperty(value="units")
    public Optional<UnitsEnum> getUnits() {
        return this.units;
    }

    @JsonIgnore
    public Optional<String> getStagedByUserId() {
        if (this.stagedByUserId == null) {
            return Optional.empty();
        }
        return this.stagedByUserId;
    }

    @JsonProperty(value="settlement_type")
    public SettlementTypeEnum1 getSettlementType() {
        return this.settlementType;
    }

    @JsonProperty(value="owned_by_org_id")
    public String getOwnedByOrgId() {
        return this.ownedByOrgId;
    }

    @JsonProperty(value="payment_vector_type")
    public PaymentVectorTypeEnum1 getPaymentVectorType() {
        return this.paymentVectorType;
    }

    @JsonIgnore
    public Optional<String> getPaymentOriginOrgId() {
        if (this.paymentOriginOrgId == null) {
            return Optional.empty();
        }
        return this.paymentOriginOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentOriginOffChrtShipperOrgId() {
        if (this.paymentOriginOffChrtShipperOrgId == null) {
            return Optional.empty();
        }
        return this.paymentOriginOffChrtShipperOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentDestinationOrgId() {
        if (this.paymentDestinationOrgId == null) {
            return Optional.empty();
        }
        return this.paymentDestinationOrgId;
    }

    @JsonIgnore
    public Optional<String> getPaymentDestinationDriverId() {
        if (this.paymentDestinationDriverId == null) {
            return Optional.empty();
        }
        return this.paymentDestinationDriverId;
    }

    @JsonProperty(value="status")
    public Optional<StatementStatusEnum1> getStatus() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceId() {
        if (this.stripeInvoiceId == null) {
            return Optional.empty();
        }
        return this.stripeInvoiceId;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceUrl() {
        if (this.stripeInvoiceUrl == null) {
            return Optional.empty();
        }
        return this.stripeInvoiceUrl;
    }

    @JsonIgnore
    public Optional<String> getStripeInvoiceCreatedByUserId() {
        if (this.stripeInvoiceCreatedByUserId == null) {
            return Optional.empty();
        }
        return this.stripeInvoiceCreatedByUserId;
    }

    @JsonIgnore
    public Optional<StripeConnectInvoiceStatusEnum> getStripeInvoiceStatus() {
        if (this.stripeInvoiceStatus == null) {
            return Optional.empty();
        }
        return this.stripeInvoiceStatus;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getStagedAtTimestamp() {
        if (this.stagedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.stagedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getOpenedAtTimestamp() {
        if (this.openedAtTimestamp == null) {
            return Optional.empty();
        }
        return this.openedAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getPaidAtTimestamp() {
        if (this.paidAtTimestamp == null) {
            return Optional.empty();
        }
        return this.paidAtTimestamp;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getUncollectibleAtTimestamp() {
        if (this.uncollectibleAtTimestamp == null) {
            return Optional.empty();
        }
        return this.uncollectibleAtTimestamp;
    }

    @JsonIgnore
    public Optional<String> getMarkedOpenByUserId() {
        if (this.markedOpenByUserId == null) {
            return Optional.empty();
        }
        return this.markedOpenByUserId;
    }

    @JsonIgnore
    public Optional<String> getMarkedPaidByUserId() {
        if (this.markedPaidByUserId == null) {
            return Optional.empty();
        }
        return this.markedPaidByUserId;
    }

    @JsonIgnore
    public Optional<String> getMarkedUncollectibleByUserId() {
        if (this.markedUncollectibleByUserId == null) {
            return Optional.empty();
        }
        return this.markedUncollectibleByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="staged_by_user_id")
    private Optional<String> _getStagedByUserId() {
        return this.stagedByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_origin_org_id")
    private Optional<String> _getPaymentOriginOrgId() {
        return this.paymentOriginOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_origin_off_chrt_shipper_org_id")
    private Optional<String> _getPaymentOriginOffChrtShipperOrgId() {
        return this.paymentOriginOffChrtShipperOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_destination_org_id")
    private Optional<String> _getPaymentDestinationOrgId() {
        return this.paymentDestinationOrgId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="payment_destination_driver_id")
    private Optional<String> _getPaymentDestinationDriverId() {
        return this.paymentDestinationDriverId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stripe_invoice_id")
    private Optional<String> _getStripeInvoiceId() {
        return this.stripeInvoiceId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stripe_invoice_url")
    private Optional<String> _getStripeInvoiceUrl() {
        return this.stripeInvoiceUrl;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stripe_invoice_created_by_user_id")
    private Optional<String> _getStripeInvoiceCreatedByUserId() {
        return this.stripeInvoiceCreatedByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="stripe_invoice_status")
    private Optional<StripeConnectInvoiceStatusEnum> _getStripeInvoiceStatus() {
        return this.stripeInvoiceStatus;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="staged_at_timestamp")
    private Optional<OffsetDateTime> _getStagedAtTimestamp() {
        return this.stagedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="opened_at_timestamp")
    private Optional<OffsetDateTime> _getOpenedAtTimestamp() {
        return this.openedAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="paid_at_timestamp")
    private Optional<OffsetDateTime> _getPaidAtTimestamp() {
        return this.paidAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="uncollectible_at_timestamp")
    private Optional<OffsetDateTime> _getUncollectibleAtTimestamp() {
        return this.uncollectibleAtTimestamp;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="marked_open_by_user_id")
    private Optional<String> _getMarkedOpenByUserId() {
        return this.markedOpenByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="marked_paid_by_user_id")
    private Optional<String> _getMarkedPaidByUserId() {
        return this.markedPaidByUserId;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="marked_uncollectible_by_user_id")
    private Optional<String> _getMarkedUncollectibleByUserId() {
        return this.markedUncollectibleByUserId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Statement1 && this.equalTo((Statement1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Statement1 other) {
        return this.schemaVersion == other.schemaVersion && this.id.equals(other.id) && this.lineItemGroupIds.equals(other.lineItemGroupIds) && this.amount == other.amount && this.units.equals(other.units) && this.stagedByUserId.equals(other.stagedByUserId) && this.settlementType.equals(other.settlementType) && this.ownedByOrgId.equals(other.ownedByOrgId) && this.paymentVectorType.equals(other.paymentVectorType) && this.paymentOriginOrgId.equals(other.paymentOriginOrgId) && this.paymentOriginOffChrtShipperOrgId.equals(other.paymentOriginOffChrtShipperOrgId) && this.paymentDestinationOrgId.equals(other.paymentDestinationOrgId) && this.paymentDestinationDriverId.equals(other.paymentDestinationDriverId) && this.status.equals(other.status) && this.stripeInvoiceId.equals(other.stripeInvoiceId) && this.stripeInvoiceUrl.equals(other.stripeInvoiceUrl) && this.stripeInvoiceCreatedByUserId.equals(other.stripeInvoiceCreatedByUserId) && this.stripeInvoiceStatus.equals(other.stripeInvoiceStatus) && this.stagedAtTimestamp.equals(other.stagedAtTimestamp) && this.openedAtTimestamp.equals(other.openedAtTimestamp) && this.paidAtTimestamp.equals(other.paidAtTimestamp) && this.uncollectibleAtTimestamp.equals(other.uncollectibleAtTimestamp) && this.markedOpenByUserId.equals(other.markedOpenByUserId) && this.markedPaidByUserId.equals(other.markedPaidByUserId) && this.markedUncollectibleByUserId.equals(other.markedUncollectibleByUserId);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.id, this.lineItemGroupIds, this.amount, this.units, this.stagedByUserId, this.settlementType, this.ownedByOrgId, this.paymentVectorType, this.paymentOriginOrgId, this.paymentOriginOffChrtShipperOrgId, this.paymentDestinationOrgId, this.paymentDestinationDriverId, this.status, this.stripeInvoiceId, this.stripeInvoiceUrl, this.stripeInvoiceCreatedByUserId, this.stripeInvoiceStatus, this.stagedAtTimestamp, this.openedAtTimestamp, this.paidAtTimestamp, this.uncollectibleAtTimestamp, this.markedOpenByUserId, this.markedPaidByUserId, this.markedUncollectibleByUserId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    IdStage,
    AmountStage,
    SettlementTypeStage,
    OwnedByOrgIdStage,
    PaymentVectorTypeStage,
    _FinalStage {
        private int schemaVersion;
        private String id;
        private int amount;
        private SettlementTypeEnum1 settlementType;
        private String ownedByOrgId;
        private PaymentVectorTypeEnum1 paymentVectorType;
        private Optional<String> markedUncollectibleByUserId = Optional.empty();
        private Optional<String> markedPaidByUserId = Optional.empty();
        private Optional<String> markedOpenByUserId = Optional.empty();
        private Optional<OffsetDateTime> uncollectibleAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> paidAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> openedAtTimestamp = Optional.empty();
        private Optional<OffsetDateTime> stagedAtTimestamp = Optional.empty();
        private Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus = Optional.empty();
        private Optional<String> stripeInvoiceCreatedByUserId = Optional.empty();
        private Optional<String> stripeInvoiceUrl = Optional.empty();
        private Optional<String> stripeInvoiceId = Optional.empty();
        private Optional<StatementStatusEnum1> status = Optional.empty();
        private Optional<String> paymentDestinationDriverId = Optional.empty();
        private Optional<String> paymentDestinationOrgId = Optional.empty();
        private Optional<String> paymentOriginOffChrtShipperOrgId = Optional.empty();
        private Optional<String> paymentOriginOrgId = Optional.empty();
        private Optional<String> stagedByUserId = Optional.empty();
        private Optional<UnitsEnum> units = Optional.empty();
        private Optional<List<String>> lineItemGroupIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Statement1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.id(other.getId());
            this.lineItemGroupIds(other.getLineItemGroupIds());
            this.amount(other.getAmount());
            this.units(other.getUnits());
            this.stagedByUserId(other.getStagedByUserId());
            this.settlementType(other.getSettlementType());
            this.ownedByOrgId(other.getOwnedByOrgId());
            this.paymentVectorType(other.getPaymentVectorType());
            this.paymentOriginOrgId(other.getPaymentOriginOrgId());
            this.paymentOriginOffChrtShipperOrgId(other.getPaymentOriginOffChrtShipperOrgId());
            this.paymentDestinationOrgId(other.getPaymentDestinationOrgId());
            this.paymentDestinationDriverId(other.getPaymentDestinationDriverId());
            this.status(other.getStatus());
            this.stripeInvoiceId(other.getStripeInvoiceId());
            this.stripeInvoiceUrl(other.getStripeInvoiceUrl());
            this.stripeInvoiceCreatedByUserId(other.getStripeInvoiceCreatedByUserId());
            this.stripeInvoiceStatus(other.getStripeInvoiceStatus());
            this.stagedAtTimestamp(other.getStagedAtTimestamp());
            this.openedAtTimestamp(other.getOpenedAtTimestamp());
            this.paidAtTimestamp(other.getPaidAtTimestamp());
            this.uncollectibleAtTimestamp(other.getUncollectibleAtTimestamp());
            this.markedOpenByUserId(other.getMarkedOpenByUserId());
            this.markedPaidByUserId(other.getMarkedPaidByUserId());
            this.markedUncollectibleByUserId(other.getMarkedUncollectibleByUserId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public AmountStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="amount")
        public SettlementTypeStage amount(int amount) {
            this.amount = amount;
            return this;
        }

        @Override
        @JsonSetter(value="settlement_type")
        public OwnedByOrgIdStage settlementType(@NotNull SettlementTypeEnum1 settlementType) {
            this.settlementType = Objects.requireNonNull(settlementType, "settlementType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="owned_by_org_id")
        public PaymentVectorTypeStage ownedByOrgId(@NotNull String ownedByOrgId) {
            this.ownedByOrgId = Objects.requireNonNull(ownedByOrgId, "ownedByOrgId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="payment_vector_type")
        public _FinalStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 paymentVectorType) {
            this.paymentVectorType = Objects.requireNonNull(paymentVectorType, "paymentVectorType must not be null");
            return this;
        }

        @Override
        public _FinalStage markedUncollectibleByUserId(Nullable<String> markedUncollectibleByUserId) {
            this.markedUncollectibleByUserId = markedUncollectibleByUserId.isNull() ? null : (markedUncollectibleByUserId.isEmpty() ? Optional.empty() : Optional.of(markedUncollectibleByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage markedUncollectibleByUserId(String markedUncollectibleByUserId) {
            this.markedUncollectibleByUserId = Optional.ofNullable(markedUncollectibleByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="marked_uncollectible_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage markedUncollectibleByUserId(Optional<String> markedUncollectibleByUserId) {
            this.markedUncollectibleByUserId = markedUncollectibleByUserId;
            return this;
        }

        @Override
        public _FinalStage markedPaidByUserId(Nullable<String> markedPaidByUserId) {
            this.markedPaidByUserId = markedPaidByUserId.isNull() ? null : (markedPaidByUserId.isEmpty() ? Optional.empty() : Optional.of(markedPaidByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage markedPaidByUserId(String markedPaidByUserId) {
            this.markedPaidByUserId = Optional.ofNullable(markedPaidByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="marked_paid_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage markedPaidByUserId(Optional<String> markedPaidByUserId) {
            this.markedPaidByUserId = markedPaidByUserId;
            return this;
        }

        @Override
        public _FinalStage markedOpenByUserId(Nullable<String> markedOpenByUserId) {
            this.markedOpenByUserId = markedOpenByUserId.isNull() ? null : (markedOpenByUserId.isEmpty() ? Optional.empty() : Optional.of(markedOpenByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage markedOpenByUserId(String markedOpenByUserId) {
            this.markedOpenByUserId = Optional.ofNullable(markedOpenByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="marked_open_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage markedOpenByUserId(Optional<String> markedOpenByUserId) {
            this.markedOpenByUserId = markedOpenByUserId;
            return this;
        }

        @Override
        public _FinalStage uncollectibleAtTimestamp(Nullable<OffsetDateTime> uncollectibleAtTimestamp) {
            this.uncollectibleAtTimestamp = uncollectibleAtTimestamp.isNull() ? null : (uncollectibleAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(uncollectibleAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage uncollectibleAtTimestamp(OffsetDateTime uncollectibleAtTimestamp) {
            this.uncollectibleAtTimestamp = Optional.ofNullable(uncollectibleAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="uncollectible_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage uncollectibleAtTimestamp(Optional<OffsetDateTime> uncollectibleAtTimestamp) {
            this.uncollectibleAtTimestamp = uncollectibleAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage paidAtTimestamp(Nullable<OffsetDateTime> paidAtTimestamp) {
            this.paidAtTimestamp = paidAtTimestamp.isNull() ? null : (paidAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(paidAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage paidAtTimestamp(OffsetDateTime paidAtTimestamp) {
            this.paidAtTimestamp = Optional.ofNullable(paidAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="paid_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage paidAtTimestamp(Optional<OffsetDateTime> paidAtTimestamp) {
            this.paidAtTimestamp = paidAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage openedAtTimestamp(Nullable<OffsetDateTime> openedAtTimestamp) {
            this.openedAtTimestamp = openedAtTimestamp.isNull() ? null : (openedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(openedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage openedAtTimestamp(OffsetDateTime openedAtTimestamp) {
            this.openedAtTimestamp = Optional.ofNullable(openedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="opened_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage openedAtTimestamp(Optional<OffsetDateTime> openedAtTimestamp) {
            this.openedAtTimestamp = openedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp.isNull() ? null : (stagedAtTimestamp.isEmpty() ? Optional.empty() : Optional.of(stagedAtTimestamp.get()));
            return this;
        }

        @Override
        public _FinalStage stagedAtTimestamp(OffsetDateTime stagedAtTimestamp) {
            this.stagedAtTimestamp = Optional.ofNullable(stagedAtTimestamp);
            return this;
        }

        @Override
        @JsonSetter(value="staged_at_timestamp", nulls=Nulls.SKIP)
        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> stagedAtTimestamp) {
            this.stagedAtTimestamp = stagedAtTimestamp;
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceStatus(Nullable<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus) {
            this.stripeInvoiceStatus = stripeInvoiceStatus.isNull() ? null : (stripeInvoiceStatus.isEmpty() ? Optional.empty() : Optional.of(stripeInvoiceStatus.get()));
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceStatus(StripeConnectInvoiceStatusEnum stripeInvoiceStatus) {
            this.stripeInvoiceStatus = Optional.ofNullable(stripeInvoiceStatus);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_status", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceStatus(Optional<StripeConnectInvoiceStatusEnum> stripeInvoiceStatus) {
            this.stripeInvoiceStatus = stripeInvoiceStatus;
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceCreatedByUserId(Nullable<String> stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId.isNull() ? null : (stripeInvoiceCreatedByUserId.isEmpty() ? Optional.empty() : Optional.of(stripeInvoiceCreatedByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceCreatedByUserId(String stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = Optional.ofNullable(stripeInvoiceCreatedByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_created_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceCreatedByUserId(Optional<String> stripeInvoiceCreatedByUserId) {
            this.stripeInvoiceCreatedByUserId = stripeInvoiceCreatedByUserId;
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceUrl(Nullable<String> stripeInvoiceUrl) {
            this.stripeInvoiceUrl = stripeInvoiceUrl.isNull() ? null : (stripeInvoiceUrl.isEmpty() ? Optional.empty() : Optional.of(stripeInvoiceUrl.get()));
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceUrl(String stripeInvoiceUrl) {
            this.stripeInvoiceUrl = Optional.ofNullable(stripeInvoiceUrl);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_url", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceUrl(Optional<String> stripeInvoiceUrl) {
            this.stripeInvoiceUrl = stripeInvoiceUrl;
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceId(Nullable<String> stripeInvoiceId) {
            this.stripeInvoiceId = stripeInvoiceId.isNull() ? null : (stripeInvoiceId.isEmpty() ? Optional.empty() : Optional.of(stripeInvoiceId.get()));
            return this;
        }

        @Override
        public _FinalStage stripeInvoiceId(String stripeInvoiceId) {
            this.stripeInvoiceId = Optional.ofNullable(stripeInvoiceId);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_invoice_id", nulls=Nulls.SKIP)
        public _FinalStage stripeInvoiceId(Optional<String> stripeInvoiceId) {
            this.stripeInvoiceId = stripeInvoiceId;
            return this;
        }

        @Override
        public _FinalStage status(StatementStatusEnum1 status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<StatementStatusEnum1> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage paymentDestinationDriverId(Nullable<String> paymentDestinationDriverId) {
            this.paymentDestinationDriverId = paymentDestinationDriverId.isNull() ? null : (paymentDestinationDriverId.isEmpty() ? Optional.empty() : Optional.of(paymentDestinationDriverId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentDestinationDriverId(String paymentDestinationDriverId) {
            this.paymentDestinationDriverId = Optional.ofNullable(paymentDestinationDriverId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_destination_driver_id", nulls=Nulls.SKIP)
        public _FinalStage paymentDestinationDriverId(Optional<String> paymentDestinationDriverId) {
            this.paymentDestinationDriverId = paymentDestinationDriverId;
            return this;
        }

        @Override
        public _FinalStage paymentDestinationOrgId(Nullable<String> paymentDestinationOrgId) {
            this.paymentDestinationOrgId = paymentDestinationOrgId.isNull() ? null : (paymentDestinationOrgId.isEmpty() ? Optional.empty() : Optional.of(paymentDestinationOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentDestinationOrgId(String paymentDestinationOrgId) {
            this.paymentDestinationOrgId = Optional.ofNullable(paymentDestinationOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_destination_org_id", nulls=Nulls.SKIP)
        public _FinalStage paymentDestinationOrgId(Optional<String> paymentDestinationOrgId) {
            this.paymentDestinationOrgId = paymentDestinationOrgId;
            return this;
        }

        @Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId.isNull() ? null : (paymentOriginOffChrtShipperOrgId.isEmpty() ? Optional.empty() : Optional.of(paymentOriginOffChrtShipperOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentOriginOffChrtShipperOrgId(String paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = Optional.ofNullable(paymentOriginOffChrtShipperOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_origin_off_chrt_shipper_org_id", nulls=Nulls.SKIP)
        public _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> paymentOriginOffChrtShipperOrgId) {
            this.paymentOriginOffChrtShipperOrgId = paymentOriginOffChrtShipperOrgId;
            return this;
        }

        @Override
        public _FinalStage paymentOriginOrgId(Nullable<String> paymentOriginOrgId) {
            this.paymentOriginOrgId = paymentOriginOrgId.isNull() ? null : (paymentOriginOrgId.isEmpty() ? Optional.empty() : Optional.of(paymentOriginOrgId.get()));
            return this;
        }

        @Override
        public _FinalStage paymentOriginOrgId(String paymentOriginOrgId) {
            this.paymentOriginOrgId = Optional.ofNullable(paymentOriginOrgId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_origin_org_id", nulls=Nulls.SKIP)
        public _FinalStage paymentOriginOrgId(Optional<String> paymentOriginOrgId) {
            this.paymentOriginOrgId = paymentOriginOrgId;
            return this;
        }

        @Override
        public _FinalStage stagedByUserId(Nullable<String> stagedByUserId) {
            this.stagedByUserId = stagedByUserId.isNull() ? null : (stagedByUserId.isEmpty() ? Optional.empty() : Optional.of(stagedByUserId.get()));
            return this;
        }

        @Override
        public _FinalStage stagedByUserId(String stagedByUserId) {
            this.stagedByUserId = Optional.ofNullable(stagedByUserId);
            return this;
        }

        @Override
        @JsonSetter(value="staged_by_user_id", nulls=Nulls.SKIP)
        public _FinalStage stagedByUserId(Optional<String> stagedByUserId) {
            this.stagedByUserId = stagedByUserId;
            return this;
        }

        @Override
        public _FinalStage units(UnitsEnum units) {
            this.units = Optional.ofNullable(units);
            return this;
        }

        @Override
        @JsonSetter(value="units", nulls=Nulls.SKIP)
        public _FinalStage units(Optional<UnitsEnum> units) {
            this.units = units;
            return this;
        }

        @Override
        public _FinalStage lineItemGroupIds(List<String> lineItemGroupIds) {
            this.lineItemGroupIds = Optional.ofNullable(lineItemGroupIds);
            return this;
        }

        @Override
        @JsonSetter(value="line_item_group_ids", nulls=Nulls.SKIP)
        public _FinalStage lineItemGroupIds(Optional<List<String>> lineItemGroupIds) {
            this.lineItemGroupIds = lineItemGroupIds;
            return this;
        }

        @Override
        public Statement1 build() {
            return new Statement1(this.schemaVersion, this.id, this.lineItemGroupIds, this.amount, this.units, this.stagedByUserId, this.settlementType, this.ownedByOrgId, this.paymentVectorType, this.paymentOriginOrgId, this.paymentOriginOffChrtShipperOrgId, this.paymentDestinationOrgId, this.paymentDestinationDriverId, this.status, this.stripeInvoiceId, this.stripeInvoiceUrl, this.stripeInvoiceCreatedByUserId, this.stripeInvoiceStatus, this.stagedAtTimestamp, this.openedAtTimestamp, this.paidAtTimestamp, this.uncollectibleAtTimestamp, this.markedOpenByUserId, this.markedPaidByUserId, this.markedUncollectibleByUserId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Statement1 build();

        public _FinalStage lineItemGroupIds(Optional<List<String>> var1);

        public _FinalStage lineItemGroupIds(List<String> var1);

        public _FinalStage units(Optional<UnitsEnum> var1);

        public _FinalStage units(UnitsEnum var1);

        public _FinalStage stagedByUserId(Optional<String> var1);

        public _FinalStage stagedByUserId(String var1);

        public _FinalStage stagedByUserId(Nullable<String> var1);

        public _FinalStage paymentOriginOrgId(Optional<String> var1);

        public _FinalStage paymentOriginOrgId(String var1);

        public _FinalStage paymentOriginOrgId(Nullable<String> var1);

        public _FinalStage paymentOriginOffChrtShipperOrgId(Optional<String> var1);

        public _FinalStage paymentOriginOffChrtShipperOrgId(String var1);

        public _FinalStage paymentOriginOffChrtShipperOrgId(Nullable<String> var1);

        public _FinalStage paymentDestinationOrgId(Optional<String> var1);

        public _FinalStage paymentDestinationOrgId(String var1);

        public _FinalStage paymentDestinationOrgId(Nullable<String> var1);

        public _FinalStage paymentDestinationDriverId(Optional<String> var1);

        public _FinalStage paymentDestinationDriverId(String var1);

        public _FinalStage paymentDestinationDriverId(Nullable<String> var1);

        public _FinalStage status(Optional<StatementStatusEnum1> var1);

        public _FinalStage status(StatementStatusEnum1 var1);

        public _FinalStage stripeInvoiceId(Optional<String> var1);

        public _FinalStage stripeInvoiceId(String var1);

        public _FinalStage stripeInvoiceId(Nullable<String> var1);

        public _FinalStage stripeInvoiceUrl(Optional<String> var1);

        public _FinalStage stripeInvoiceUrl(String var1);

        public _FinalStage stripeInvoiceUrl(Nullable<String> var1);

        public _FinalStage stripeInvoiceCreatedByUserId(Optional<String> var1);

        public _FinalStage stripeInvoiceCreatedByUserId(String var1);

        public _FinalStage stripeInvoiceCreatedByUserId(Nullable<String> var1);

        public _FinalStage stripeInvoiceStatus(Optional<StripeConnectInvoiceStatusEnum> var1);

        public _FinalStage stripeInvoiceStatus(StripeConnectInvoiceStatusEnum var1);

        public _FinalStage stripeInvoiceStatus(Nullable<StripeConnectInvoiceStatusEnum> var1);

        public _FinalStage stagedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage stagedAtTimestamp(OffsetDateTime var1);

        public _FinalStage stagedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage openedAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage openedAtTimestamp(OffsetDateTime var1);

        public _FinalStage openedAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage paidAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage paidAtTimestamp(OffsetDateTime var1);

        public _FinalStage paidAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage uncollectibleAtTimestamp(Optional<OffsetDateTime> var1);

        public _FinalStage uncollectibleAtTimestamp(OffsetDateTime var1);

        public _FinalStage uncollectibleAtTimestamp(Nullable<OffsetDateTime> var1);

        public _FinalStage markedOpenByUserId(Optional<String> var1);

        public _FinalStage markedOpenByUserId(String var1);

        public _FinalStage markedOpenByUserId(Nullable<String> var1);

        public _FinalStage markedPaidByUserId(Optional<String> var1);

        public _FinalStage markedPaidByUserId(String var1);

        public _FinalStage markedPaidByUserId(Nullable<String> var1);

        public _FinalStage markedUncollectibleByUserId(Optional<String> var1);

        public _FinalStage markedUncollectibleByUserId(String var1);

        public _FinalStage markedUncollectibleByUserId(Nullable<String> var1);
    }

    public static interface PaymentVectorTypeStage {
        public _FinalStage paymentVectorType(@NotNull PaymentVectorTypeEnum1 var1);
    }

    public static interface OwnedByOrgIdStage {
        public PaymentVectorTypeStage ownedByOrgId(@NotNull String var1);
    }

    public static interface SettlementTypeStage {
        public OwnedByOrgIdStage settlementType(@NotNull SettlementTypeEnum1 var1);
    }

    public static interface AmountStage {
        public SettlementTypeStage amount(int var1);
    }

    public static interface IdStage {
        public AmountStage id(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public IdStage schemaVersion(int var1);

        public Builder from(Statement1 var1);
    }
}

