/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LineItemGroup1;
import com.chrt.api.types.Statement1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StatementExpandedRes {
    private final Statement1 statement;
    private final List<LineItemGroup1> lineItemGroups;
    private final Map<String, Object> additionalProperties;

    private StatementExpandedRes(Statement1 statement, List<LineItemGroup1> lineItemGroups, Map<String, Object> additionalProperties) {
        this.statement = statement;
        this.lineItemGroups = lineItemGroups;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="statement")
    public Statement1 getStatement() {
        return this.statement;
    }

    @JsonProperty(value="line_item_groups")
    public List<LineItemGroup1> getLineItemGroups() {
        return this.lineItemGroups;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StatementExpandedRes && this.equalTo((StatementExpandedRes)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StatementExpandedRes other) {
        return this.statement.equals(other.statement) && this.lineItemGroups.equals(other.lineItemGroups);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.lineItemGroups);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StatementStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StatementStage,
    _FinalStage {
        private Statement1 statement;
        private List<LineItemGroup1> lineItemGroups = new ArrayList<LineItemGroup1>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(StatementExpandedRes other) {
            this.statement(other.getStatement());
            this.lineItemGroups(other.getLineItemGroups());
            return this;
        }

        @Override
        @JsonSetter(value="statement")
        public _FinalStage statement(@NotNull Statement1 statement) {
            this.statement = Objects.requireNonNull(statement, "statement must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllLineItemGroups(List<LineItemGroup1> lineItemGroups) {
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @Override
        public _FinalStage addLineItemGroups(LineItemGroup1 lineItemGroups) {
            this.lineItemGroups.add(lineItemGroups);
            return this;
        }

        @Override
        @JsonSetter(value="line_item_groups", nulls=Nulls.SKIP)
        public _FinalStage lineItemGroups(List<LineItemGroup1> lineItemGroups) {
            this.lineItemGroups.clear();
            if (lineItemGroups != null) {
                this.lineItemGroups.addAll(lineItemGroups);
            }
            return this;
        }

        @Override
        public StatementExpandedRes build() {
            return new StatementExpandedRes(this.statement, this.lineItemGroups, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public StatementExpandedRes build();

        public _FinalStage lineItemGroups(List<LineItemGroup1> var1);

        public _FinalStage addLineItemGroups(LineItemGroup1 var1);

        public _FinalStage addAllLineItemGroups(List<LineItemGroup1> var1);
    }

    public static interface StatementStage {
        public _FinalStage statement(@NotNull Statement1 var1);

        public Builder from(StatementExpandedRes var1);
    }
}

