/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.Statement1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StatementsListRes {
    private final List<Statement1> statements;
    private final int totalCount;
    private final Map<String, Object> additionalProperties;

    private StatementsListRes(List<Statement1> statements, int totalCount, Map<String, Object> additionalProperties) {
        this.statements = statements;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="statements")
    public List<Statement1> getStatements() {
        return this.statements;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StatementsListRes && this.equalTo((StatementsListRes)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StatementsListRes other) {
        return this.statements.equals(other.statements) && this.totalCount == other.totalCount;
    }

    public int hashCode() {
        return Objects.hash(this.statements, this.totalCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private List<Statement1> statements = new ArrayList<Statement1>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(StatementsListRes other) {
            this.statements(other.getStatements());
            this.totalCount(other.getTotalCount());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllStatements(List<Statement1> statements) {
            if (statements != null) {
                this.statements.addAll(statements);
            }
            return this;
        }

        @Override
        public _FinalStage addStatements(Statement1 statements) {
            this.statements.add(statements);
            return this;
        }

        @Override
        @JsonSetter(value="statements", nulls=Nulls.SKIP)
        public _FinalStage statements(List<Statement1> statements) {
            this.statements.clear();
            if (statements != null) {
                this.statements.addAll(statements);
            }
            return this;
        }

        @Override
        public StatementsListRes build() {
            return new StatementsListRes(this.statements, this.totalCount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public StatementsListRes build();

        public _FinalStage statements(List<Statement1> var1);

        public _FinalStage addStatements(Statement1 var1);

        public _FinalStage addAllStatements(List<Statement1> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(StatementsListRes var1);
    }
}

