/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.Action;
import com.chrt.api.types.LocationFeature;
import com.chrt.api.types.TimeWindow1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaskClientUpdate1 {
    private final Optional<LocationFeature> location;
    private final Optional<Action> action;
    private final Optional<List<TimeWindow1>> timeWindows;
    private final Optional<List<String>> shipperContactIds;
    private final Map<String, Object> additionalProperties;

    private TaskClientUpdate1(Optional<LocationFeature> location, Optional<Action> action, Optional<List<TimeWindow1>> timeWindows, Optional<List<String>> shipperContactIds, Map<String, Object> additionalProperties) {
        this.location = location;
        this.action = action;
        this.timeWindows = timeWindows;
        this.shipperContactIds = shipperContactIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<LocationFeature> getLocation() {
        if (this.location == null) {
            return Optional.empty();
        }
        return this.location;
    }

    @JsonIgnore
    public Optional<Action> getAction() {
        if (this.action == null) {
            return Optional.empty();
        }
        return this.action;
    }

    @JsonProperty(value="time_windows")
    public Optional<List<TimeWindow1>> getTimeWindows() {
        return this.timeWindows;
    }

    @JsonProperty(value="shipper_contact_ids")
    public Optional<List<String>> getShipperContactIds() {
        return this.shipperContactIds;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="location")
    private Optional<LocationFeature> _getLocation() {
        return this.location;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="action")
    private Optional<Action> _getAction() {
        return this.action;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskClientUpdate1 && this.equalTo((TaskClientUpdate1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskClientUpdate1 other) {
        return this.location.equals(other.location) && this.action.equals(other.action) && this.timeWindows.equals(other.timeWindows) && this.shipperContactIds.equals(other.shipperContactIds);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.action, this.timeWindows, this.shipperContactIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<LocationFeature> location = Optional.empty();
        private Optional<Action> action = Optional.empty();
        private Optional<List<TimeWindow1>> timeWindows = Optional.empty();
        private Optional<List<String>> shipperContactIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TaskClientUpdate1 other) {
            this.location(other.getLocation());
            this.action(other.getAction());
            this.timeWindows(other.getTimeWindows());
            this.shipperContactIds(other.getShipperContactIds());
            return this;
        }

        @JsonSetter(value="location", nulls=Nulls.SKIP)
        public Builder location(Optional<LocationFeature> location) {
            this.location = location;
            return this;
        }

        public Builder location(LocationFeature location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        public Builder location(Nullable<LocationFeature> location) {
            this.location = location.isNull() ? null : (location.isEmpty() ? Optional.empty() : Optional.of(location.get()));
            return this;
        }

        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public Builder action(Optional<Action> action) {
            this.action = action;
            return this;
        }

        public Builder action(Action action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        public Builder action(Nullable<Action> action) {
            this.action = action.isNull() ? null : (action.isEmpty() ? Optional.empty() : Optional.of(action.get()));
            return this;
        }

        @JsonSetter(value="time_windows", nulls=Nulls.SKIP)
        public Builder timeWindows(Optional<List<TimeWindow1>> timeWindows) {
            this.timeWindows = timeWindows;
            return this;
        }

        public Builder timeWindows(List<TimeWindow1> timeWindows) {
            this.timeWindows = Optional.ofNullable(timeWindows);
            return this;
        }

        @JsonSetter(value="shipper_contact_ids", nulls=Nulls.SKIP)
        public Builder shipperContactIds(Optional<List<String>> shipperContactIds) {
            this.shipperContactIds = shipperContactIds;
            return this;
        }

        public Builder shipperContactIds(List<String> shipperContactIds) {
            this.shipperContactIds = Optional.ofNullable(shipperContactIds);
            return this;
        }

        public TaskClientUpdate1 build() {
            return new TaskClientUpdate1(this.location, this.action, this.timeWindows, this.shipperContactIds, this.additionalProperties);
        }
    }
}

