/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.Cargo1;
import com.chrt.api.types.ShipperContact1;
import com.chrt.api.types.Task1;
import com.chrt.api.types.TaskArtifact1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaskExpanded {
    private final Task1 task;
    private final Optional<List<Cargo1>> cargos;
    private final Optional<List<TaskArtifact1>> taskArtifacts;
    private final Optional<List<ShipperContact1>> shipperContacts;
    private final Map<String, Object> additionalProperties;

    private TaskExpanded(Task1 task, Optional<List<Cargo1>> cargos, Optional<List<TaskArtifact1>> taskArtifacts, Optional<List<ShipperContact1>> shipperContacts, Map<String, Object> additionalProperties) {
        this.task = task;
        this.cargos = cargos;
        this.taskArtifacts = taskArtifacts;
        this.shipperContacts = shipperContacts;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="task")
    public Task1 getTask() {
        return this.task;
    }

    @JsonIgnore
    public Optional<List<Cargo1>> getCargos() {
        if (this.cargos == null) {
            return Optional.empty();
        }
        return this.cargos;
    }

    @JsonIgnore
    public Optional<List<TaskArtifact1>> getTaskArtifacts() {
        if (this.taskArtifacts == null) {
            return Optional.empty();
        }
        return this.taskArtifacts;
    }

    @JsonIgnore
    public Optional<List<ShipperContact1>> getShipperContacts() {
        if (this.shipperContacts == null) {
            return Optional.empty();
        }
        return this.shipperContacts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cargos")
    private Optional<List<Cargo1>> _getCargos() {
        return this.cargos;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="task_artifacts")
    private Optional<List<TaskArtifact1>> _getTaskArtifacts() {
        return this.taskArtifacts;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="shipper_contacts")
    private Optional<List<ShipperContact1>> _getShipperContacts() {
        return this.shipperContacts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskExpanded && this.equalTo((TaskExpanded)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskExpanded other) {
        return this.task.equals(other.task) && this.cargos.equals(other.cargos) && this.taskArtifacts.equals(other.taskArtifacts) && this.shipperContacts.equals(other.shipperContacts);
    }

    public int hashCode() {
        return Objects.hash(this.task, this.cargos, this.taskArtifacts, this.shipperContacts);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TaskStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TaskStage,
    _FinalStage {
        private Task1 task;
        private Optional<List<ShipperContact1>> shipperContacts = Optional.empty();
        private Optional<List<TaskArtifact1>> taskArtifacts = Optional.empty();
        private Optional<List<Cargo1>> cargos = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TaskExpanded other) {
            this.task(other.getTask());
            this.cargos(other.getCargos());
            this.taskArtifacts(other.getTaskArtifacts());
            this.shipperContacts(other.getShipperContacts());
            return this;
        }

        @Override
        @JsonSetter(value="task")
        public _FinalStage task(@NotNull Task1 task) {
            this.task = Objects.requireNonNull(task, "task must not be null");
            return this;
        }

        @Override
        public _FinalStage shipperContacts(Nullable<List<ShipperContact1>> shipperContacts) {
            this.shipperContacts = shipperContacts.isNull() ? null : (shipperContacts.isEmpty() ? Optional.empty() : Optional.of(shipperContacts.get()));
            return this;
        }

        @Override
        public _FinalStage shipperContacts(List<ShipperContact1> shipperContacts) {
            this.shipperContacts = Optional.ofNullable(shipperContacts);
            return this;
        }

        @Override
        @JsonSetter(value="shipper_contacts", nulls=Nulls.SKIP)
        public _FinalStage shipperContacts(Optional<List<ShipperContact1>> shipperContacts) {
            this.shipperContacts = shipperContacts;
            return this;
        }

        @Override
        public _FinalStage taskArtifacts(Nullable<List<TaskArtifact1>> taskArtifacts) {
            this.taskArtifacts = taskArtifacts.isNull() ? null : (taskArtifacts.isEmpty() ? Optional.empty() : Optional.of(taskArtifacts.get()));
            return this;
        }

        @Override
        public _FinalStage taskArtifacts(List<TaskArtifact1> taskArtifacts) {
            this.taskArtifacts = Optional.ofNullable(taskArtifacts);
            return this;
        }

        @Override
        @JsonSetter(value="task_artifacts", nulls=Nulls.SKIP)
        public _FinalStage taskArtifacts(Optional<List<TaskArtifact1>> taskArtifacts) {
            this.taskArtifacts = taskArtifacts;
            return this;
        }

        @Override
        public _FinalStage cargos(Nullable<List<Cargo1>> cargos) {
            this.cargos = cargos.isNull() ? null : (cargos.isEmpty() ? Optional.empty() : Optional.of(cargos.get()));
            return this;
        }

        @Override
        public _FinalStage cargos(List<Cargo1> cargos) {
            this.cargos = Optional.ofNullable(cargos);
            return this;
        }

        @Override
        @JsonSetter(value="cargos", nulls=Nulls.SKIP)
        public _FinalStage cargos(Optional<List<Cargo1>> cargos) {
            this.cargos = cargos;
            return this;
        }

        @Override
        public TaskExpanded build() {
            return new TaskExpanded(this.task, this.cargos, this.taskArtifacts, this.shipperContacts, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TaskExpanded build();

        public _FinalStage cargos(Optional<List<Cargo1>> var1);

        public _FinalStage cargos(List<Cargo1> var1);

        public _FinalStage cargos(Nullable<List<Cargo1>> var1);

        public _FinalStage taskArtifacts(Optional<List<TaskArtifact1>> var1);

        public _FinalStage taskArtifacts(List<TaskArtifact1> var1);

        public _FinalStage taskArtifacts(Nullable<List<TaskArtifact1>> var1);

        public _FinalStage shipperContacts(Optional<List<ShipperContact1>> var1);

        public _FinalStage shipperContacts(List<ShipperContact1> var1);

        public _FinalStage shipperContacts(Nullable<List<ShipperContact1>> var1);
    }

    public static interface TaskStage {
        public _FinalStage task(@NotNull Task1 var1);

        public Builder from(TaskExpanded var1);
    }
}

