/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.chrt.api.types.LocationFeature;
import com.chrt.api.types.TaskGroupByDriverDataPointMetadata1;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaskGroupByDriverDataPoint1 {
    private final int schemaVersion;
    private final OffsetDateTime timestamp;
    private final TaskGroupByDriverDataPointMetadata1 metadata;
    private final LocationFeature location;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private TaskGroupByDriverDataPoint1(int schemaVersion, OffsetDateTime timestamp, TaskGroupByDriverDataPointMetadata1 metadata, LocationFeature location, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.timestamp = timestamp;
        this.metadata = metadata;
        this.location = location;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="metadata")
    public TaskGroupByDriverDataPointMetadata1 getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="location")
    public LocationFeature getLocation() {
        return this.location;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskGroupByDriverDataPoint1 && this.equalTo((TaskGroupByDriverDataPoint1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroupByDriverDataPoint1 other) {
        return this.schemaVersion == other.schemaVersion && this.timestamp.equals(other.timestamp) && this.metadata.equals(other.metadata) && this.location.equals(other.location) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.timestamp, this.metadata, this.location, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    TimestampStage,
    MetadataStage,
    LocationStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private OffsetDateTime timestamp;
        private TaskGroupByDriverDataPointMetadata1 metadata;
        private LocationFeature location;
        private String id;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TaskGroupByDriverDataPoint1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.timestamp(other.getTimestamp());
            this.metadata(other.getMetadata());
            this.location(other.getLocation());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public TimestampStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public MetadataStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="metadata")
        public LocationStage metadata(@NotNull TaskGroupByDriverDataPointMetadata1 metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="location")
        public IdStage location(@NotNull LocationFeature location) {
            this.location = Objects.requireNonNull(location, "location must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public TaskGroupByDriverDataPoint1 build() {
            return new TaskGroupByDriverDataPoint1(this.schemaVersion, this.timestamp, this.metadata, this.location, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TaskGroupByDriverDataPoint1 build();
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface LocationStage {
        public IdStage location(@NotNull LocationFeature var1);
    }

    public static interface MetadataStage {
        public LocationStage metadata(@NotNull TaskGroupByDriverDataPointMetadata1 var1);
    }

    public static interface TimestampStage {
        public MetadataStage timestamp(@NotNull OffsetDateTime var1);
    }

    public static interface SchemaVersionStage {
        public TimestampStage schemaVersion(int var1);

        public Builder from(TaskGroupByDriverDataPoint1 var1);
    }
}

