/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TaskGroupS3ObjectMetadata1 {
    private final int schemaVersion;
    private final String id;
    private final String taskGroupId;
    private final OffsetDateTime uploadedAtTimestamp;
    private final String uploadedByUserId;
    private final String uploadedByOrgId;
    private final Optional<String> s3KeyPrefix;
    private final Optional<String> blurhash;
    private final Map<String, Object> additionalProperties;

    private TaskGroupS3ObjectMetadata1(int schemaVersion, String id, String taskGroupId, OffsetDateTime uploadedAtTimestamp, String uploadedByUserId, String uploadedByOrgId, Optional<String> s3KeyPrefix, Optional<String> blurhash, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.taskGroupId = taskGroupId;
        this.uploadedAtTimestamp = uploadedAtTimestamp;
        this.uploadedByUserId = uploadedByUserId;
        this.uploadedByOrgId = uploadedByOrgId;
        this.s3KeyPrefix = s3KeyPrefix;
        this.blurhash = blurhash;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="task_group_id")
    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty(value="uploaded_at_timestamp")
    public OffsetDateTime getUploadedAtTimestamp() {
        return this.uploadedAtTimestamp;
    }

    @JsonProperty(value="uploaded_by_user_id")
    public String getUploadedByUserId() {
        return this.uploadedByUserId;
    }

    @JsonProperty(value="uploaded_by_org_id")
    public String getUploadedByOrgId() {
        return this.uploadedByOrgId;
    }

    @JsonProperty(value="s3_key_prefix")
    public Optional<String> getS3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    @JsonIgnore
    public Optional<String> getBlurhash() {
        if (this.blurhash == null) {
            return Optional.empty();
        }
        return this.blurhash;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="blurhash")
    private Optional<String> _getBlurhash() {
        return this.blurhash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskGroupS3ObjectMetadata1 && this.equalTo((TaskGroupS3ObjectMetadata1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskGroupS3ObjectMetadata1 other) {
        return this.schemaVersion == other.schemaVersion && this.id.equals(other.id) && this.taskGroupId.equals(other.taskGroupId) && this.uploadedAtTimestamp.equals(other.uploadedAtTimestamp) && this.uploadedByUserId.equals(other.uploadedByUserId) && this.uploadedByOrgId.equals(other.uploadedByOrgId) && this.s3KeyPrefix.equals(other.s3KeyPrefix) && this.blurhash.equals(other.blurhash);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.id, this.taskGroupId, this.uploadedAtTimestamp, this.uploadedByUserId, this.uploadedByOrgId, this.s3KeyPrefix, this.blurhash);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    IdStage,
    TaskGroupIdStage,
    UploadedAtTimestampStage,
    UploadedByUserIdStage,
    UploadedByOrgIdStage,
    _FinalStage {
        private int schemaVersion;
        private String id;
        private String taskGroupId;
        private OffsetDateTime uploadedAtTimestamp;
        private String uploadedByUserId;
        private String uploadedByOrgId;
        private Optional<String> blurhash = Optional.empty();
        private Optional<String> s3KeyPrefix = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TaskGroupS3ObjectMetadata1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.id(other.getId());
            this.taskGroupId(other.getTaskGroupId());
            this.uploadedAtTimestamp(other.getUploadedAtTimestamp());
            this.uploadedByUserId(other.getUploadedByUserId());
            this.uploadedByOrgId(other.getUploadedByOrgId());
            this.s3KeyPrefix(other.getS3KeyPrefix());
            this.blurhash(other.getBlurhash());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public TaskGroupIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="task_group_id")
        public UploadedAtTimestampStage taskGroupId(@NotNull String taskGroupId) {
            this.taskGroupId = Objects.requireNonNull(taskGroupId, "taskGroupId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="uploaded_at_timestamp")
        public UploadedByUserIdStage uploadedAtTimestamp(@NotNull OffsetDateTime uploadedAtTimestamp) {
            this.uploadedAtTimestamp = Objects.requireNonNull(uploadedAtTimestamp, "uploadedAtTimestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="uploaded_by_user_id")
        public UploadedByOrgIdStage uploadedByUserId(@NotNull String uploadedByUserId) {
            this.uploadedByUserId = Objects.requireNonNull(uploadedByUserId, "uploadedByUserId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="uploaded_by_org_id")
        public _FinalStage uploadedByOrgId(@NotNull String uploadedByOrgId) {
            this.uploadedByOrgId = Objects.requireNonNull(uploadedByOrgId, "uploadedByOrgId must not be null");
            return this;
        }

        @Override
        public _FinalStage blurhash(Nullable<String> blurhash) {
            this.blurhash = blurhash.isNull() ? null : (blurhash.isEmpty() ? Optional.empty() : Optional.of(blurhash.get()));
            return this;
        }

        @Override
        public _FinalStage blurhash(String blurhash) {
            this.blurhash = Optional.ofNullable(blurhash);
            return this;
        }

        @Override
        @JsonSetter(value="blurhash", nulls=Nulls.SKIP)
        public _FinalStage blurhash(Optional<String> blurhash) {
            this.blurhash = blurhash;
            return this;
        }

        @Override
        public _FinalStage s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = Optional.ofNullable(s3KeyPrefix);
            return this;
        }

        @Override
        @JsonSetter(value="s3_key_prefix", nulls=Nulls.SKIP)
        public _FinalStage s3KeyPrefix(Optional<String> s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        @Override
        public TaskGroupS3ObjectMetadata1 build() {
            return new TaskGroupS3ObjectMetadata1(this.schemaVersion, this.id, this.taskGroupId, this.uploadedAtTimestamp, this.uploadedByUserId, this.uploadedByOrgId, this.s3KeyPrefix, this.blurhash, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TaskGroupS3ObjectMetadata1 build();

        public _FinalStage s3KeyPrefix(Optional<String> var1);

        public _FinalStage s3KeyPrefix(String var1);

        public _FinalStage blurhash(Optional<String> var1);

        public _FinalStage blurhash(String var1);

        public _FinalStage blurhash(Nullable<String> var1);
    }

    public static interface UploadedByOrgIdStage {
        public _FinalStage uploadedByOrgId(@NotNull String var1);
    }

    public static interface UploadedByUserIdStage {
        public UploadedByOrgIdStage uploadedByUserId(@NotNull String var1);
    }

    public static interface UploadedAtTimestampStage {
        public UploadedByUserIdStage uploadedAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface TaskGroupIdStage {
        public UploadedAtTimestampStage taskGroupId(@NotNull String var1);
    }

    public static interface IdStage {
        public TaskGroupIdStage id(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public IdStage schemaVersion(int var1);

        public Builder from(TaskGroupS3ObjectMetadata1 var1);
    }
}

