/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TemplateRes {
    private final String message;
    private final int number;
    private final OffsetDateTime timestamp;
    private final Map<String, Object> additionalProperties;

    private TemplateRes(String message, int number, OffsetDateTime timestamp, Map<String, Object> additionalProperties) {
        this.message = message;
        this.number = number;
        this.timestamp = timestamp;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="number")
    public int getNumber() {
        return this.number;
    }

    @JsonProperty(value="timestamp")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TemplateRes && this.equalTo((TemplateRes)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TemplateRes other) {
        return this.message.equals(other.message) && this.number == other.number && this.timestamp.equals(other.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.number, this.timestamp);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MessageStage,
    NumberStage,
    TimestampStage,
    _FinalStage {
        private String message;
        private int number;
        private OffsetDateTime timestamp;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TemplateRes other) {
            this.message(other.getMessage());
            this.number(other.getNumber());
            this.timestamp(other.getTimestamp());
            return this;
        }

        @Override
        @JsonSetter(value="message")
        public NumberStage message(@NotNull String message) {
            this.message = Objects.requireNonNull(message, "message must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="number")
        public TimestampStage number(int number) {
            this.number = number;
            return this;
        }

        @Override
        @JsonSetter(value="timestamp")
        public _FinalStage timestamp(@NotNull OffsetDateTime timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
            return this;
        }

        @Override
        public TemplateRes build() {
            return new TemplateRes(this.message, this.number, this.timestamp, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TemplateRes build();
    }

    public static interface TimestampStage {
        public _FinalStage timestamp(@NotNull OffsetDateTime var1);
    }

    public static interface NumberStage {
        public TimestampStage number(int var1);
    }

    public static interface MessageStage {
        public NumberStage message(@NotNull String var1);

        public Builder from(TemplateRes var1);
    }
}

