/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TimezoneResponse {
    private final String timezone;
    private final double lat;
    private final double lng;
    private final String method;
    private final Map<String, Object> additionalProperties;

    private TimezoneResponse(String timezone, double lat, double lng, String method, Map<String, Object> additionalProperties) {
        this.timezone = timezone;
        this.lat = lat;
        this.lng = lng;
        this.method = method;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="timezone")
    public String getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="lat")
    public double getLat() {
        return this.lat;
    }

    @JsonProperty(value="lng")
    public double getLng() {
        return this.lng;
    }

    @JsonProperty(value="method")
    public String getMethod() {
        return this.method;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TimezoneResponse && this.equalTo((TimezoneResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TimezoneResponse other) {
        return this.timezone.equals(other.timezone) && this.lat == other.lat && this.lng == other.lng && this.method.equals(other.method);
    }

    public int hashCode() {
        return Objects.hash(this.timezone, this.lat, this.lng, this.method);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TimezoneStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TimezoneStage,
    LatStage,
    LngStage,
    MethodStage,
    _FinalStage {
        private String timezone;
        private double lat;
        private double lng;
        private String method;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TimezoneResponse other) {
            this.timezone(other.getTimezone());
            this.lat(other.getLat());
            this.lng(other.getLng());
            this.method(other.getMethod());
            return this;
        }

        @Override
        @JsonSetter(value="timezone")
        public LatStage timezone(@NotNull String timezone) {
            this.timezone = Objects.requireNonNull(timezone, "timezone must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="lat")
        public LngStage lat(double lat) {
            this.lat = lat;
            return this;
        }

        @Override
        @JsonSetter(value="lng")
        public MethodStage lng(double lng) {
            this.lng = lng;
            return this;
        }

        @Override
        @JsonSetter(value="method")
        public _FinalStage method(@NotNull String method) {
            this.method = Objects.requireNonNull(method, "method must not be null");
            return this;
        }

        @Override
        public TimezoneResponse build() {
            return new TimezoneResponse(this.timezone, this.lat, this.lng, this.method, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TimezoneResponse build();
    }

    public static interface MethodStage {
        public _FinalStage method(@NotNull String var1);
    }

    public static interface LngStage {
        public MethodStage lng(double var1);
    }

    public static interface LatStage {
        public LngStage lat(double var1);
    }

    public static interface TimezoneStage {
        public LatStage timezone(@NotNull String var1);

        public Builder from(TimezoneResponse var1);
    }
}

