/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.Nullable;
import com.chrt.api.core.NullableNonemptyFilter;
import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UserPublicData1 {
    private final int schemaVersion;
    private final OffsetDateTime createdAtTimestamp;
    private final Optional<String> primaryEmailAddress;
    private final String userId;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private UserPublicData1(int schemaVersion, OffsetDateTime createdAtTimestamp, Optional<String> primaryEmailAddress, String userId, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.createdAtTimestamp = createdAtTimestamp;
        this.primaryEmailAddress = primaryEmailAddress;
        this.userId = userId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="created_at_timestamp")
    public OffsetDateTime getCreatedAtTimestamp() {
        return this.createdAtTimestamp;
    }

    @JsonIgnore
    public Optional<String> getPrimaryEmailAddress() {
        if (this.primaryEmailAddress == null) {
            return Optional.empty();
        }
        return this.primaryEmailAddress;
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="primary_email_address")
    private Optional<String> _getPrimaryEmailAddress() {
        return this.primaryEmailAddress;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UserPublicData1 && this.equalTo((UserPublicData1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UserPublicData1 other) {
        return this.schemaVersion == other.schemaVersion && this.createdAtTimestamp.equals(other.createdAtTimestamp) && this.primaryEmailAddress.equals(other.primaryEmailAddress) && this.userId.equals(other.userId) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.createdAtTimestamp, this.primaryEmailAddress, this.userId, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    CreatedAtTimestampStage,
    UserIdStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private OffsetDateTime createdAtTimestamp;
        private String userId;
        private String id;
        private Optional<String> primaryEmailAddress = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UserPublicData1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.createdAtTimestamp(other.getCreatedAtTimestamp());
            this.primaryEmailAddress(other.getPrimaryEmailAddress());
            this.userId(other.getUserId());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public CreatedAtTimestampStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="created_at_timestamp")
        public UserIdStage createdAtTimestamp(@NotNull OffsetDateTime createdAtTimestamp) {
            this.createdAtTimestamp = Objects.requireNonNull(createdAtTimestamp, "createdAtTimestamp must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public IdStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage primaryEmailAddress(Nullable<String> primaryEmailAddress) {
            this.primaryEmailAddress = primaryEmailAddress.isNull() ? null : (primaryEmailAddress.isEmpty() ? Optional.empty() : Optional.of(primaryEmailAddress.get()));
            return this;
        }

        @Override
        public _FinalStage primaryEmailAddress(String primaryEmailAddress) {
            this.primaryEmailAddress = Optional.ofNullable(primaryEmailAddress);
            return this;
        }

        @Override
        @JsonSetter(value="primary_email_address", nulls=Nulls.SKIP)
        public _FinalStage primaryEmailAddress(Optional<String> primaryEmailAddress) {
            this.primaryEmailAddress = primaryEmailAddress;
            return this;
        }

        @Override
        public UserPublicData1 build() {
            return new UserPublicData1(this.schemaVersion, this.createdAtTimestamp, this.primaryEmailAddress, this.userId, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UserPublicData1 build();

        public _FinalStage primaryEmailAddress(Optional<String> var1);

        public _FinalStage primaryEmailAddress(String var1);

        public _FinalStage primaryEmailAddress(Nullable<String> var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface UserIdStage {
        public IdStage userId(@NotNull String var1);
    }

    public static interface CreatedAtTimestampStage {
        public UserIdStage createdAtTimestamp(@NotNull OffsetDateTime var1);
    }

    public static interface SchemaVersionStage {
        public CreatedAtTimestampStage schemaVersion(int var1);

        public Builder from(UserPublicData1 var1);
    }
}

