/*
 * Decompiled with CFR 0.152.
 */
package com.chrt.api.types;

import com.chrt.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Vehicle1 {
    private final int schemaVersion;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private Vehicle1(int schemaVersion, String id, Map<String, Object> additionalProperties) {
        this.schemaVersion = schemaVersion;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema_version")
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Vehicle1 && this.equalTo((Vehicle1)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Vehicle1 other) {
        return this.schemaVersion == other.schemaVersion && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchemaVersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchemaVersionStage,
    IdStage,
    _FinalStage {
        private int schemaVersion;
        private String id;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Vehicle1 other) {
            this.schemaVersion(other.getSchemaVersion());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="schema_version")
        public IdStage schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        @JsonSetter(value="_id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public Vehicle1 build() {
            return new Vehicle1(this.schemaVersion, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Vehicle1 build();
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface SchemaVersionStage {
        public IdStage schemaVersion(int var1);

        public Builder from(Vehicle1 var1);
    }
}

