/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.code.generator;

import com.cloudimpl.code.generator.Reflector;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="CodeGenerator", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresOnline=false, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=false)
public class CodeGenerator
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File projectBuildDir;
    @Parameter(defaultValue="${project.basedir}/", required=true)
    protected File projectBaseDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected String projectTargetDirectory;
    private Map<Class, Reflector> providers = new HashMap<Class, Reflector>();
    private List<String> runtimeClasspathElements;

    public static void main(String[] args) {
        new CodeGenerator().init();
    }

    private void init() {
        if (this.project != null) {
            try {
                String regexPath = ".*(com).*(cloudimpl).*(codegen-lib).*";
                this.runtimeClasspathElements = this.project.getRuntimeClasspathElements();
                this.runtimeClasspathElements.addAll(this.project.getCompileClasspathElements());
                ClassLoader classLoader = this.getClassLoader();
                this.project.getProperties().entrySet().forEach(e -> {
                    if (e.getKey().equals("com.cloudimpl.codegen.provider")) {
                        this.getLog().info((CharSequence)("provider :" + e.getValue() + " loaded"));
                        Class providerClass = this.getRuntimeClass(classLoader, (String)e.getValue());
                        Reflector ref = new Reflector(providerClass);
                        this.providers.put(providerClass, ref);
                    }
                });
                this.runtimeClasspathElements.forEach(s -> this.providers.values().forEach(prv -> prv.addDependacyPath((String)s, true)));
                this.project.getArtifacts().stream().map(s -> {
                    System.out.println("xxxx : " + s.getFile().getAbsolutePath());
                    return s.getFile().getAbsolutePath();
                }).forEach(p -> this.providers.values().forEach(prv -> prv.addDependacyPath((String)p, false)));
                this.project.getProperties().entrySet().forEach(e -> this.providers.values().forEach(p -> p.addProperty(e.getKey().toString(), e.getValue().toString())));
                this.providers.values().forEach(p -> p.setProject(this.projectBaseDirectory.getAbsolutePath(), this.projectBuildDir.getAbsolutePath(), this.projectTargetDirectory));
            }
            catch (DependencyResolutionRequiredException ex) {
                Logger.getLogger(CodeGenerator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.providers.entrySet().forEach(e -> {
            if (!((Reflector)e.getValue()).getCodeGenFolder().exists() && !((Reflector)e.getValue()).getCodeGenFolder().mkdirs()) {
                this.getLog().error((CharSequence)(((Class)e.getKey()).getName() + ":Could not create error directory!"));
            }
            this.cleanGeneratedCodes(((Reflector)e.getValue()).getCodeGenFolder());
        });
    }

    private void cleanGeneratedCodes(File directory) {
        File[] files;
        for (File f : files = directory.listFiles()) {
            if (f.isDirectory()) {
                this.cleanGeneratedCodes(f);
                continue;
            }
            f.delete();
        }
    }

    private ClassLoader getClassLoader() {
        URL[] runtimeUrls = new URL[this.runtimeClasspathElements.size()];
        for (int i = 0; i < this.runtimeClasspathElements.size(); ++i) {
            try {
                String element = this.runtimeClasspathElements.get(i);
                runtimeUrls[i] = new File(element).toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(CodeGenerator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        URLClassLoader newLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
        return newLoader;
    }

    private void compileFiles(List<File> javaFiles) {
        if (javaFiles.size() == 0) {
            return;
        }
        this.getLog().info((CharSequence)("compiling files: " + javaFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList())));
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(javaFiles);
        ArrayList<String> optionList = new ArrayList<String>();
        File targetDir = new File(this.projectTargetDirectory);
        targetDir.mkdir();
        optionList.addAll(Arrays.asList("-d", this.projectTargetDirectory));
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, optionList, null, compilationUnits);
        try {
            boolean ok = task.call();
            this.getLog().info((CharSequence)("files compile status " + ok));
            diagnostics.getDiagnostics().stream().forEach(System.out::println);
            if (!ok) {
                throw new RuntimeException("error compiling file");
            }
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
        }
    }

    private <T> Class<T> getRuntimeClass(ClassLoader classLoader, String classFullName) {
        boolean i = false;
        try {
            if (classLoader == null) {
                classLoader = this.getClassLoader();
            }
            return classLoader.loadClass(classFullName);
        }
        catch (ClassNotFoundException ex) {
            this.getLog().error((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.init();
            this.providers.values().forEach(p -> p.execute());
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
            throw ex;
        }
    }
}

