/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.code.generator;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class Reflector {
    private Class<?> provider;
    private Object instance;
    private Method addProperty;
    private Method setProject;
    private Method getCodeGenFolder;
    private Method execute;
    private Method addDependacyPath;

    public Reflector(Class<?> provider) {
        this.provider = provider;
        try {
            this.addProperty = this.findMethod(provider, "addProperty", false);
            this.setProject = this.findMethod(provider, "setProject", false);
            this.getCodeGenFolder = this.findMethod(provider, "getCodeGenFolder", false);
            this.execute = this.findMethod(provider, "execute", false);
            this.addDependacyPath = this.findMethod(provider, "addDependacyPath", false);
            this.instance = this.provider.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public void addProperty(String key, String value) {
        try {
            this.addProperty.invoke(this.instance, key, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public void addDependacyPath(String path, boolean runtime) {
        try {
            this.addDependacyPath.invoke(this.instance, path, runtime);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public void execute() {
        try {
            this.execute.invoke(this.instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public File getCodeGenFolder() {
        try {
            return new File((String)this.getCodeGenFolder.invoke(this.instance, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public void setProject(String baseDir, String buildDir, String buildTargetDir) {
        try {
            this.setProject.invoke(this.instance, baseDir, buildDir, buildTargetDir);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    private Method findMethod(Class cls, String methodName, boolean isStatic) {
        do {
            Method method;
            if ((method = (Method)Arrays.asList(cls.getDeclaredMethods()).stream().filter(m -> m.getName().equals(methodName)).filter(m -> Modifier.isStatic(m.getModifiers()) == isStatic).findFirst().orElse(null)) == null) continue;
            method.setAccessible(true);
            return method;
        } while ((cls = cls.getSuperclass()) != Object.class);
        throw new ReflectorException("method : " + methodName + " not found in " + cls.getName());
    }

    public static final class ReflectorException
    extends RuntimeException {
        public ReflectorException(Throwable thr) {
            super(thr);
        }

        public ReflectorException(String msg) {
            super(msg);
        }
    }
}

