/*
 * Decompiled with CFR 0.152.
 */
package com.cludimpl.errorcode.generator;

import com.cloudimpl.codegen4j.AccessLevel;
import com.cloudimpl.codegen4j.ClassBlock;
import com.cloudimpl.codegen4j.ClassBuilder;
import com.cloudimpl.codegen4j.ConstructorBlock;
import com.cloudimpl.codegen4j.EnumBlock;
import com.cloudimpl.codegen4j.Var;
import com.cludimpl.errorcode.generator.ErrorCodeProcessor;
import com.cludimpl.errorcode.generator.Reflector;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="ErrorCodeGenerator", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresOnline=false, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=false)
public class ErrorCodeGenerator
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    protected MavenProject project;
    @Parameter(property="cloudImpl.errorCode.errorFileName", required=true, defaultValue="${project.artifactId}")
    protected String errorFileName;
    @Parameter(property="cloudImpl.errorCode.package", required=true, defaultValue="com.cloudimpl.error")
    protected String errorPackage;
    @Parameter(property="cloudImpl.errorCode.enable", required=true, defaultValue="false")
    protected boolean enableErrorCode;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/errorcodes", required=true)
    protected File errorOutputFolder;
    @Parameter(defaultValue="${project.basedir}/src/main/java", required=true)
    protected File projectSourceDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected String projectTargetDirectory;
    private File errorFile;
    private Optional<String> errLibPath;
    private List<String> runtimeClasspathElements;

    public static void main(String[] args) {
        new ErrorCodeGenerator().init();
    }

    private void init() {
        if (this.project != null) {
            try {
                String regexPath = ".*(com).*(cloudimpl).*(error-lib).*";
                this.project.addCompileSourceRoot(this.errorOutputFolder.getAbsolutePath());
                this.runtimeClasspathElements = this.project.getRuntimeClasspathElements();
                this.runtimeClasspathElements.addAll(this.project.getCompileClasspathElements());
                this.errLibPath = this.project.getArtifacts().stream().map(s -> s.getFile().getAbsolutePath()).filter(s -> s.matches(regexPath)).findFirst();
                if (this.errLibPath.isPresent()) {
                    this.runtimeClasspathElements.add(this.errLibPath.get());
                }
            }
            catch (DependencyResolutionRequiredException ex) {
                Logger.getLogger(ErrorCodeGenerator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!this.errorOutputFolder.exists() && !this.errorOutputFolder.mkdirs()) {
            this.getLog().error((CharSequence)"Could not create error directory!");
        }
        this.cleanGeneratedCodes(this.errorOutputFolder);
    }

    private void cleanGeneratedCodes(File directory) {
        File[] files;
        for (File f : files = directory.listFiles()) {
            if (f.isDirectory()) {
                this.cleanGeneratedCodes(f);
                continue;
            }
            f.delete();
        }
    }

    private ClassLoader getClassLoader() {
        URL[] runtimeUrls = new URL[this.runtimeClasspathElements.size()];
        for (int i = 0; i < this.runtimeClasspathElements.size(); ++i) {
            try {
                String element = this.runtimeClasspathElements.get(i);
                runtimeUrls[i] = new File(element).toURI().toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(ErrorCodeGenerator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        URLClassLoader newLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
        return newLoader;
    }

    private void compileErrorFile() {
        File[] javaFiles = new File[]{new File(this.errorFile.getAbsolutePath())};
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(javaFiles));
        ArrayList<String> optionList = new ArrayList<String>();
        if (this.errLibPath.isPresent()) {
            optionList.addAll(Arrays.asList("-classpath", this.errLibPath.get()));
        }
        File targetDir = new File(this.projectTargetDirectory);
        targetDir.mkdir();
        optionList.addAll(Arrays.asList("-d", this.projectTargetDirectory));
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, optionList, null, compilationUnits);
        try {
            boolean ok = task.call();
            this.getLog().info((CharSequence)("error file compile status " + ok));
            diagnostics.getDiagnostics().stream().forEach(System.out::println);
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
        }
    }

    private <T> Class<T> getErrorClass() {
        this.compileErrorFile();
        ClassLoader classLoader = this.getClassLoader();
        try {
            return classLoader.loadClass(this.errorPackage + "." + this.errorFileName);
        }
        catch (ClassNotFoundException ex) {
            this.getLog().error((Throwable)ex);
            return null;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.enableErrorCode) {
            return;
        }
        try {
            T[] errorCodes;
            this.errorFileName = this.makeFirstLetterCapital(this.errorFileName);
            this.init();
            this.createErrorFileIfNotExist();
            Class errorClazz = this.getErrorClass();
            if (errorClazz == null) {
                return;
            }
            Reflector ref = new Reflector(errorClazz);
            for (Object code : errorCodes = errorClazz.getEnumConstants()) {
                System.out.println("name " + ref.getName(code));
                List<String> tags = ErrorCodeProcessor.getTags(ref.getErrorFormat(code));
                this.generateErrorBuilder(ref.getName(code), tags);
            }
            this.generateException(this.errorFileName + "Exception", Arrays.asList(errorCodes), ref);
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
            throw ex;
        }
    }

    private String makeFirstLetterCapital(String target) {
        return target.substring(0, 1).toUpperCase() + target.substring(1);
    }

    private MethodSpec createMethod(String name, String tag) {
        ParameterSpec parameterSpec = ParameterSpec.builder(Object.class, (String)tag, (Modifier[])new Modifier[0]).build();
        MethodSpec setter = MethodSpec.methodBuilder((String)("set" + this.makeFirstLetterCapital(tag))).addParameter(parameterSpec).returns((TypeName)ClassName.get((String)"", (String)name, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("withTag(\"" + tag + "\", " + tag + ");\n return this;\n", new Object[0]).build();
        return setter;
    }

    private void generateErrorBuilder(String name, List<String> tags) {
        List<MethodSpec> methods = tags.stream().map(tag -> this.createMethod(name, (String)tag)).collect(Collectors.toList());
        TypeSpec.Builder errorBuilder = TypeSpec.classBuilder((String)name).superclass((TypeName)ClassName.get((String)"com.cloudimpl.error.core", (String)"ErrorBuilder", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methods.forEach(method -> errorBuilder.addMethod(method));
        errorBuilder.addMethod(MethodSpec.constructorBuilder().addStatement(" withCode($L)", new Object[]{this.errorPackage + "." + this.errorFileName + "." + name}).build());
        JavaFile javaFile = JavaFile.builder((String)this.errorPackage, (TypeSpec)errorBuilder.build()).skipJavaLangImports(true).build();
        try {
            javaFile.writeTo(this.errorOutputFolder);
        }
        catch (IOException ex) {
            Logger.getLogger(ErrorCodeGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private MethodSpec createExceptionMethod(String exceptionName, Object errCode, Reflector ref) {
        List<String> tags = ErrorCodeProcessor.getTags(ref.getErrorFormat(errCode));
        ParameterizedTypeName paramterType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util.function", (String)"Consumer", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)ref.getName(errCode), (String[])new String[0])});
        MethodSpec setter = MethodSpec.methodBuilder((String)ref.getName(errCode)).addParameter((TypeName)paramterType, "consumer", new Modifier[0]).returns((TypeName)ClassName.get((String)"", (String)exceptionName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addCode(ref.getName(errCode) + " error = new " + ref.getName(errCode) + "();\nconsumer.accept(error);\nreturn new " + exceptionName + "(error);", new Object[0]).addJavadoc("errorNo : $L \nformat : $S \ntags : $S\n@param consumer\n@return\n", new Object[]{ref.getErrorCode(errCode), ref.getErrorFormat(errCode), tags}).build();
        return setter;
    }

    private void generateException(String exceptionName, List<Object> errCodes, Reflector ref) {
        List<MethodSpec> list = errCodes.stream().map(errCode -> this.createExceptionMethod(exceptionName, errCode, ref)).collect(Collectors.toList());
        TypeSpec.Builder exceptionBuilder = TypeSpec.classBuilder((String)exceptionName).superclass((TypeName)ClassName.get((String)"com.cloudimpl.error.core", (String)"CloudImplException", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)ClassName.get((String)"com.cloudimpl.error.core", (String)"ErrorBuilder", (String[])new String[0]), "builder", new Modifier[0]).addStatement("super(builder)", new Object[0]).build());
        list.forEach(m -> exceptionBuilder.addMethod(m));
        JavaFile javaFile = JavaFile.builder((String)this.errorPackage, (TypeSpec)exceptionBuilder.build()).skipJavaLangImports(true).build();
        try {
            javaFile.writeTo(this.errorOutputFolder);
        }
        catch (IOException ex) {
            Logger.getLogger(ErrorCodeGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void createErrorFileIfNotExist() {
        String packagePath = this.errorPackage.replaceAll("\\.", "/");
        this.errorFile = new File(this.projectSourceDirectory.getAbsolutePath() + "/" + packagePath + "/" + this.errorFileName + ".java");
        if (this.errorFile.exists()) {
            return;
        }
        ClassBuilder builder = new ClassBuilder();
        EnumBlock enumBlock = builder.createEnum(this.errorFileName);
        enumBlock.withPackageName(this.errorPackage).withAccess(AccessLevel.PUBLIC);
        enumBlock.implement(new String[]{"com.cloudimpl.error.core.ErrorCode"});
        Var erroNo = (Var)enumBlock.var("int", "errorNo").withAccess(AccessLevel.PRIVATE).withFinal().end();
        Var errFormat = (Var)enumBlock.var("String", "format").withAccess(AccessLevel.PRIVATE).withFinal().end();
        ConstructorBlock cb = enumBlock.createConstructor(new String[]{"int errorNo", "String errorFormat"});
        cb.stmt().append("this.errorNo").append("=").append2("errorNo").end();
        cb.stmt().append("this.format").append("=").append2("errorFormat").end();
        enumBlock.createGetter(erroNo).withAnnotation(Override.class.getSimpleName());
        enumBlock.createGetter(errFormat).withAnnotation(Override.class.getSimpleName());
        com.cloudimpl.codegen4j.JavaFile jFile = com.cloudimpl.codegen4j.JavaFile.wrap((ClassBlock)enumBlock);
        jFile.writeTo(this.projectSourceDirectory);
    }
}

