/*
 * Decompiled with CFR 0.152.
 */
package com.cludimpl.errorcode.generator;

import com.cludimpl.errorcode.generator.InvalidErrorFormatException;
import java.util.LinkedList;
import java.util.List;

public class ErrorCodeProcessor {
    public static List<String> getTags(String format) {
        LinkedList<String> tags = new LinkedList<String>();
        StringBuilder builder = new StringBuilder();
        boolean openBracket = false;
        block4: for (char c : format.toCharArray()) {
            switch (c) {
                case '[': {
                    if (openBracket) {
                        throw new InvalidErrorFormatException(format);
                    }
                    openBracket = true;
                    continue block4;
                }
                case ']': {
                    if (!openBracket) {
                        throw new InvalidErrorFormatException(format);
                    }
                    if (builder.toString().trim().isEmpty()) {
                        throw new InvalidErrorFormatException("empty tag not allowed.format = " + format);
                    }
                    tags.add(builder.toString().trim());
                    builder.setLength(0);
                    openBracket = false;
                    continue block4;
                }
                default: {
                    if (!openBracket) continue block4;
                    if (Character.isWhitespace(c)) {
                        throw new InvalidErrorFormatException("whitespace not allowed inside the tag.format = " + format);
                    }
                    builder.append(c);
                }
            }
        }
        return tags;
    }
}

