/*
 * Decompiled with CFR 0.152.
 */
package com.cludimpl.errorcode.generator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Reflector {
    private Method methodErrorNo;
    private Method methodErrorFormat;
    private Method methodName;

    public Reflector(Class clazz) {
        try {
            this.methodErrorNo = clazz.getDeclaredMethod("getErrorNo", new Class[0]);
            this.methodErrorFormat = clazz.getDeclaredMethod("getFormat", new Class[0]);
            this.methodName = clazz.getSuperclass().getDeclaredMethod("name", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new ReflectorException(ex);
        }
    }

    public int getErrorCode(Object object) {
        try {
            return (Integer)this.methodErrorNo.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public String getErrorFormat(Object object) {
        try {
            return (String)this.methodErrorFormat.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public String getName(Object object) {
        try {
            return (String)this.methodName.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public static final class ReflectorException
    extends RuntimeException {
        public ReflectorException(Throwable thr) {
            super(thr);
        }
    }
}

