/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.outstack.spring.test;

import com.cloudimpl.outstack.runtime.EntityCommandHandler;
import com.cloudimpl.outstack.runtime.EntityEventHandler;
import com.cloudimpl.outstack.runtime.domainspec.Command;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.HashMap;
import java.util.Map;

public class ResourceLoader {
    private ScanResult scanResult;
    private final Map<String, Class<? extends Entity>> mapEntities = new HashMap<String, Class<? extends Entity>>();
    private final Map<String, Class<? extends Event>> mapEvents = new HashMap<String, Class<? extends Event>>();
    private final Map<String, Class<? extends Command>> mapCommands = new HashMap<String, Class<? extends Command>>();
    private final Map<String, Class<? extends EntityCommandHandler>> mapCmdHandlers = new HashMap<String, Class<? extends EntityCommandHandler>>();
    private final Map<String, Class<? extends EntityEventHandler>> mapEvtHandlers = new HashMap<String, Class<? extends EntityEventHandler>>();

    public ResourceLoader() {
        this.loadEntities();
        this.loadEvents();
        this.loadCommands();
        this.loadCmdHandlers();
        this.loadEvtHandlers();
    }

    private ScanResult getScanResult() {
        if (this.scanResult == null) {
            this.scanResult = new ClassGraph().enableClassInfo().scan();
        }
        return this.scanResult;
    }

    private void loadEntities() {
        ClassInfoList controlClasses = this.getScanResult().getSubclasses(Entity.class.getName());
        for (Class type : controlClasses.loadClasses()) {
            this.mapEntities.put(type.getSimpleName(), type);
        }
    }

    private void loadEvents() {
        ClassInfoList controlClasses = this.getScanResult().getSubclasses(Event.class.getName());
        for (Class type : controlClasses.loadClasses()) {
            this.mapEvents.put(type.getSimpleName(), type);
        }
    }

    private void loadCommands() {
        ClassInfoList controlClasses = this.getScanResult().getSubclasses(Command.class.getName());
        for (Class type : controlClasses.loadClasses()) {
            this.mapCommands.put(type.getSimpleName(), type);
        }
    }

    private void loadCmdHandlers() {
        ClassInfoList controlClasses = this.getScanResult().getSubclasses(EntityCommandHandler.class.getName());
        for (Class type : controlClasses.loadClasses()) {
            this.mapCmdHandlers.put(type.getSimpleName(), type);
        }
    }

    private void loadEvtHandlers() {
        ClassInfoList controlClasses = this.getScanResult().getSubclasses(EntityEventHandler.class.getName());
        for (Class type : controlClasses.loadClasses()) {
            this.mapEvtHandlers.put(type.getSimpleName(), type);
        }
    }
}

