/*
 * Code Dx API
 * Code Dx provides a variety of REST APIs, allowing external applications and scripts to interface with core functionality. This guide documents the various REST resources provided by Code Dx.  ## Authentication  Authentication is a requirement when accessing API endpoints. There are two methods by which authentication may be performed.  ### API Keys  The primary method for authentication is passing an `API-Key` header containing a valid API key with all requests.  For example&#58;  `API-Key: 550e8400-e29b-41d4-a716-44665544000`  API keys may be generated by Code Dx admins. Once they are generated, in most cases, they behave like regular users. They will need to be assigned user roles for any projects they will be used with. Although it is possible to assign the *admin* [role](UserGuide.html#UserRolesConfiguration) to an API key, the recommendation is to avoid doing so unless absolutely necessary.  See the user guide for an overview about how to create and manage [API keys](UserGuide.html#APIKeysAdministration).  ### HTTP Basic Authentication  HTTP Basic authentication may be used to authenticate with the API as a regular user. This is accomplished by including an `Authorization` header containing a typical authorization credential.  ## Error Handling  ### Bad Requests  For API calls that accept input, invalid values will trigger an HTTP 400 Bad Request status code.  ### Server Errors  For any API call, if an unexpected error occurs, an HTTP 500 Internal Server Error status code will be returned. If an error message is available, the response will include a basic message body describing the error&#58;  ` {   \"error\": \"error message\" } `  The error property will contain a string message indicating the nature of the error.  ### Errors with Third-Party Applications  Sometimes Code Dx must communicate with third-party applications like JIRA, Git, and certain enterprise tools. Some users may have in-house versions of these with self-signed certificates which may not be \"trusted\". In these cases, the API will respond with an HTTP 502 BAD GATEWAY status. If this happens, refer to [Trusting Self-Signed Certificates](InstallGuide.html#TrustingSelfSignedCertificates) in the install guide.  ### API Unavailable  In special circumstances, particularly during the installation and update phases, the API will be unavailable. When the API is unavailable, all calls will return an HTTP 503 Service Unavailable status, and no actions or side effects will occur as a result of the calls.  ## Examples  Code Dx's API uses REST over HTTP. As such, you can use any language/utility that supports making HTTP requests to interact with the API. The examples below use <a href=\"https://curl.haxx.se/\" target=\"_blank\">curl</a>, a popular command-line utility, to do so.  First, you'll need to [generate an API Key](UserGuide.html#APIKeysAdministration). Second, while you can create projects through the API, these examples will assume that you've already created one. You'll need to know its project id number, which you can find by looking at the URL for the [Findings Page](UserGuide.html#Findings), which will end in a number.  **Note:** Many API endpoints require a JSON body in the request. Most JSON will contain double-quotes (`\"`) and spaces, which have special meaning when used on the command line. In order to ensure your JSON body is interpreted as a single argument, you must <a href=\"https://en.wikipedia.org/wiki/Escape_character\" target=\"_blank\">escape</a> it properly. For example, if you wanted to `POST` the following JSON body&#58;  ``` { \"name\": \"John Doe\" } ```  You would put a backslash (`\\`) before each double-quote (`\"`), and surround the whole thing with double-quotes&#58;  ``` \"{ \\\"name\\\": \\\"John Doe\\\" }\" ```  The outermost double-quotes tell the command-line interpreter that everything within them is to be treated as a single argument (as opposed to the usual space-separated behavior). The backslash before each inner double-quote tells the command-line interpreter that you mean the literal double-quote character, and not the end of the quoted argument.  In many *non-Windows* operating systems, you can also use a single-quote (`'`) to surround the argument, and skip the backslashes&#58;  ``` '{ \"name\": \"John Doe\" }' ```  The examples below will use the double-quotes and backslashes style, as it works on most (if not all) operating systems.  ### Running an Analysis  To start an analysis, you can run  ``` curl -F file1=@src.zip -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/analysis ```  Make sure you use your own values for the `src.zip` file, the API Key, the hostname for your Code Dx server, and the project id.  **Note:** This endpoint is not listed below due to a swagger limitation.  ### Retrieving Finding Data  There is a wide variety of data available for the findings of a project after running an analysis. Two examples are provided here.  ### Findings Table Data  You can retrieve the data that's used to populate the [findings table](UserGuide.html#FindingsTable)&#58;  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"sort\\\":{\\\"by\\\":\\\"id\\\",\\\"direction\\\":\\\"ascending\\\"},\\\"pagination\\\":{\\\"page\\\":1,\\\"perPage\\\":10}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/findings/table ```  Additional information about how to construct more useful filter and sort requests can be found in the documentation.  ### Finding Metadata  You can retrieve metadata for a finding, if you know the finding id. You can take the ID for a finding from the Findings Table&#58;  ``` curl -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/findings/<finding id> ```  ### Generating a Report  You can use the API to generate a PDF [report](UserGuide.html#GenerateReport).  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"config\\\":{\\\"summaryMode\\\":\\\"simple\\\",\\\"detailsMode\\\":\\\"simple\\\",\\\"includeResultDetails\\\":true,\\\"includeComments\\\":false}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/report/pdf ```  ## Generating a Client SDK  If you require a client SDK for Code Dx, you can generate one using [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen). Detailed instructions are available on the github page and our swagger spec can be found [here](swagger/swagger.json). 
 *
 * OpenAPI spec version: 3.5.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.codedx.client.model.ActivityEvent;
import com.codedx.client.model.Count;
import com.codedx.client.model.Finding;
import com.codedx.client.model.FindingDescription;
import com.codedx.client.model.FlowData;
import com.codedx.client.model.FlowRequest;
import com.codedx.client.model.GroupedCount;
import com.codedx.client.model.GroupedCountsRequest;
import com.codedx.client.model.Query;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FindingDataApi {
    private ApiClient apiClient;

    public FindingDataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FindingDataApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getFindingData
     * @param findingId The finding ID. (required)
     * @param expand The expand parameter is a comma seperated list. Each value included in the list has the potential to modify the response&#39;s Finding objects. The available values and their effects are&amp;#58; - &#x60;descriptions&#x60; - an additional property named &#x60;descriptions&#x60; is added to the Finding objects. It is a Description object that contains the tool/rule description for the finding - &#x60;descriptor&#x60; - adds additional content to the &#x60;descriptor&#x60; property of the Finding object. - &#x60;issue&#x60; - an additional property named &#x60;issue&#x60; is added to the Finding objects. &#x60;issue&#x60; will be an Issue object. - &#x60;triage-time&#x60; - an additional property named &#x60;triageTime&#x60; is added to the Finding objects. It is a date time that corresponds to the most recent time the status of the finding was updated. - &#x60;results&#x60; - an additional property named &#x60;results&#x60; is added to the Finding objects. It is an array of ToolResult objects that relate to the finding. - &#x60;results.descriptions&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property named &#x60;descriptions&#x60; to the ToolResult objects. This property is a Description object and will contain the tool and contextual descriptions for the result. - &#x60;results.descriptor&#x60; - does the same thing as &#x60;results&#x60; as well as adds additional properties to the ToolResults&#39; &#x60;descriptor&#x60; properties. - &#x60;results.metadata&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the ToolResult object named &#x60;metadata&#x60;. &#x60;metadata&#x60; is an object that contains key values pairs, usually some additional information reported by a tool. - &#x60;results.variants&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the the ToolResult object named &#x60;variants&#x60;. &#x60;variants&#x60; is an array of Variant objects. A Variant typically contains http/https request and response information.  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFindingDataCall(Integer findingId, List<String> expand, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/findings/{finding-id}"
            .replaceAll("\\{" + "finding-id" + "\\}", apiClient.escapeString(findingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "expand", expand));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFindingDataValidateBeforeCall(Integer findingId, List<String> expand, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'findingId' is set
        if (findingId == null) {
            throw new ApiException("Missing the required parameter 'findingId' when calling getFindingData(Async)");
        }
        

        com.squareup.okhttp.Call call = getFindingDataCall(findingId, expand, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Finding Data
     * Returns metadata for the given finding 
     * @param findingId The finding ID. (required)
     * @param expand The expand parameter is a comma seperated list. Each value included in the list has the potential to modify the response&#39;s Finding objects. The available values and their effects are&amp;#58; - &#x60;descriptions&#x60; - an additional property named &#x60;descriptions&#x60; is added to the Finding objects. It is a Description object that contains the tool/rule description for the finding - &#x60;descriptor&#x60; - adds additional content to the &#x60;descriptor&#x60; property of the Finding object. - &#x60;issue&#x60; - an additional property named &#x60;issue&#x60; is added to the Finding objects. &#x60;issue&#x60; will be an Issue object. - &#x60;triage-time&#x60; - an additional property named &#x60;triageTime&#x60; is added to the Finding objects. It is a date time that corresponds to the most recent time the status of the finding was updated. - &#x60;results&#x60; - an additional property named &#x60;results&#x60; is added to the Finding objects. It is an array of ToolResult objects that relate to the finding. - &#x60;results.descriptions&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property named &#x60;descriptions&#x60; to the ToolResult objects. This property is a Description object and will contain the tool and contextual descriptions for the result. - &#x60;results.descriptor&#x60; - does the same thing as &#x60;results&#x60; as well as adds additional properties to the ToolResults&#39; &#x60;descriptor&#x60; properties. - &#x60;results.metadata&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the ToolResult object named &#x60;metadata&#x60;. &#x60;metadata&#x60; is an object that contains key values pairs, usually some additional information reported by a tool. - &#x60;results.variants&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the the ToolResult object named &#x60;variants&#x60;. &#x60;variants&#x60; is an array of Variant objects. A Variant typically contains http/https request and response information.  (optional)
     * @return Finding
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Finding getFindingData(Integer findingId, List<String> expand) throws ApiException {
        ApiResponse<Finding> resp = getFindingDataWithHttpInfo(findingId, expand);
        return resp.getData();
    }

    /**
     * Finding Data
     * Returns metadata for the given finding 
     * @param findingId The finding ID. (required)
     * @param expand The expand parameter is a comma seperated list. Each value included in the list has the potential to modify the response&#39;s Finding objects. The available values and their effects are&amp;#58; - &#x60;descriptions&#x60; - an additional property named &#x60;descriptions&#x60; is added to the Finding objects. It is a Description object that contains the tool/rule description for the finding - &#x60;descriptor&#x60; - adds additional content to the &#x60;descriptor&#x60; property of the Finding object. - &#x60;issue&#x60; - an additional property named &#x60;issue&#x60; is added to the Finding objects. &#x60;issue&#x60; will be an Issue object. - &#x60;triage-time&#x60; - an additional property named &#x60;triageTime&#x60; is added to the Finding objects. It is a date time that corresponds to the most recent time the status of the finding was updated. - &#x60;results&#x60; - an additional property named &#x60;results&#x60; is added to the Finding objects. It is an array of ToolResult objects that relate to the finding. - &#x60;results.descriptions&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property named &#x60;descriptions&#x60; to the ToolResult objects. This property is a Description object and will contain the tool and contextual descriptions for the result. - &#x60;results.descriptor&#x60; - does the same thing as &#x60;results&#x60; as well as adds additional properties to the ToolResults&#39; &#x60;descriptor&#x60; properties. - &#x60;results.metadata&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the ToolResult object named &#x60;metadata&#x60;. &#x60;metadata&#x60; is an object that contains key values pairs, usually some additional information reported by a tool. - &#x60;results.variants&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the the ToolResult object named &#x60;variants&#x60;. &#x60;variants&#x60; is an array of Variant objects. A Variant typically contains http/https request and response information.  (optional)
     * @return ApiResponse&lt;Finding&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Finding> getFindingDataWithHttpInfo(Integer findingId, List<String> expand) throws ApiException {
        com.squareup.okhttp.Call call = getFindingDataValidateBeforeCall(findingId, expand, null, null);
        Type localVarReturnType = new TypeToken<Finding>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Finding Data (asynchronously)
     * Returns metadata for the given finding 
     * @param findingId The finding ID. (required)
     * @param expand The expand parameter is a comma seperated list. Each value included in the list has the potential to modify the response&#39;s Finding objects. The available values and their effects are&amp;#58; - &#x60;descriptions&#x60; - an additional property named &#x60;descriptions&#x60; is added to the Finding objects. It is a Description object that contains the tool/rule description for the finding - &#x60;descriptor&#x60; - adds additional content to the &#x60;descriptor&#x60; property of the Finding object. - &#x60;issue&#x60; - an additional property named &#x60;issue&#x60; is added to the Finding objects. &#x60;issue&#x60; will be an Issue object. - &#x60;triage-time&#x60; - an additional property named &#x60;triageTime&#x60; is added to the Finding objects. It is a date time that corresponds to the most recent time the status of the finding was updated. - &#x60;results&#x60; - an additional property named &#x60;results&#x60; is added to the Finding objects. It is an array of ToolResult objects that relate to the finding. - &#x60;results.descriptions&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property named &#x60;descriptions&#x60; to the ToolResult objects. This property is a Description object and will contain the tool and contextual descriptions for the result. - &#x60;results.descriptor&#x60; - does the same thing as &#x60;results&#x60; as well as adds additional properties to the ToolResults&#39; &#x60;descriptor&#x60; properties. - &#x60;results.metadata&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the ToolResult object named &#x60;metadata&#x60;. &#x60;metadata&#x60; is an object that contains key values pairs, usually some additional information reported by a tool. - &#x60;results.variants&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the the ToolResult object named &#x60;variants&#x60;. &#x60;variants&#x60; is an array of Variant objects. A Variant typically contains http/https request and response information.  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFindingDataAsync(Integer findingId, List<String> expand, final ApiCallback<Finding> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFindingDataValidateBeforeCall(findingId, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Finding>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFindingDescription
     * @param findingId The finding ID. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFindingDescriptionCall(Integer findingId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/findings/{finding-id}/description"
            .replaceAll("\\{" + "finding-id" + "\\}", apiClient.escapeString(findingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFindingDescriptionValidateBeforeCall(Integer findingId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'findingId' is set
        if (findingId == null) {
            throw new ApiException("Missing the required parameter 'findingId' when calling getFindingDescription(Async)");
        }
        

        com.squareup.okhttp.Call call = getFindingDescriptionCall(findingId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Finding Descriptions
     * Returns the descriptions for the given finding from all available sources. 
     * @param findingId The finding ID. (required)
     * @return FindingDescription
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FindingDescription getFindingDescription(Integer findingId) throws ApiException {
        ApiResponse<FindingDescription> resp = getFindingDescriptionWithHttpInfo(findingId);
        return resp.getData();
    }

    /**
     * Finding Descriptions
     * Returns the descriptions for the given finding from all available sources. 
     * @param findingId The finding ID. (required)
     * @return ApiResponse&lt;FindingDescription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FindingDescription> getFindingDescriptionWithHttpInfo(Integer findingId) throws ApiException {
        com.squareup.okhttp.Call call = getFindingDescriptionValidateBeforeCall(findingId, null, null);
        Type localVarReturnType = new TypeToken<FindingDescription>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Finding Descriptions (asynchronously)
     * Returns the descriptions for the given finding from all available sources. 
     * @param findingId The finding ID. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFindingDescriptionAsync(Integer findingId, final ApiCallback<FindingDescription> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFindingDescriptionValidateBeforeCall(findingId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FindingDescription>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFindingFlow
     * @param projectId The ID of the project. (required)
     * @param flowRequest  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFindingFlowCall(Integer projectId, FlowRequest flowRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = flowRequest;

        // create path and map variables
        String localVarPath = "/api/projects/{project-id}/findings/flow"
            .replaceAll("\\{" + "project-id" + "\\}", apiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFindingFlowValidateBeforeCall(Integer projectId, FlowRequest flowRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getFindingFlow(Async)");
        }
        

        com.squareup.okhttp.Call call = getFindingFlowCall(projectId, flowRequest, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Finding Flow Data
     * Returns filtered finding flow data. This endpoint is a candidate to be absorbed by a more generic querying API; presently it just returns the data required for the finding flow as it exists today. 
     * @param projectId The ID of the project. (required)
     * @param flowRequest  (optional)
     * @return List&lt;FlowData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<FlowData> getFindingFlow(Integer projectId, FlowRequest flowRequest) throws ApiException {
        ApiResponse<List<FlowData>> resp = getFindingFlowWithHttpInfo(projectId, flowRequest);
        return resp.getData();
    }

    /**
     * Finding Flow Data
     * Returns filtered finding flow data. This endpoint is a candidate to be absorbed by a more generic querying API; presently it just returns the data required for the finding flow as it exists today. 
     * @param projectId The ID of the project. (required)
     * @param flowRequest  (optional)
     * @return ApiResponse&lt;List&lt;FlowData&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<FlowData>> getFindingFlowWithHttpInfo(Integer projectId, FlowRequest flowRequest) throws ApiException {
        com.squareup.okhttp.Call call = getFindingFlowValidateBeforeCall(projectId, flowRequest, null, null);
        Type localVarReturnType = new TypeToken<List<FlowData>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Finding Flow Data (asynchronously)
     * Returns filtered finding flow data. This endpoint is a candidate to be absorbed by a more generic querying API; presently it just returns the data required for the finding flow as it exists today. 
     * @param projectId The ID of the project. (required)
     * @param flowRequest  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFindingFlowAsync(Integer projectId, FlowRequest flowRequest, final ApiCallback<List<FlowData>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFindingFlowValidateBeforeCall(projectId, flowRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<FlowData>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFindingHistory
     * @param findingId The finding ID. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFindingHistoryCall(Integer findingId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/findings/{finding-id}/history"
            .replaceAll("\\{" + "finding-id" + "\\}", apiClient.escapeString(findingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFindingHistoryValidateBeforeCall(Integer findingId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'findingId' is set
        if (findingId == null) {
            throw new ApiException("Missing the required parameter 'findingId' when calling getFindingHistory(Async)");
        }
        

        com.squareup.okhttp.Call call = getFindingHistoryCall(findingId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Finding History
     * Responds with an array of \&quot;activity event\&quot; objects in JSON. 
     * @param findingId The finding ID. (required)
     * @return List&lt;ActivityEvent&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<ActivityEvent> getFindingHistory(Integer findingId) throws ApiException {
        ApiResponse<List<ActivityEvent>> resp = getFindingHistoryWithHttpInfo(findingId);
        return resp.getData();
    }

    /**
     * Finding History
     * Responds with an array of \&quot;activity event\&quot; objects in JSON. 
     * @param findingId The finding ID. (required)
     * @return ApiResponse&lt;List&lt;ActivityEvent&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<ActivityEvent>> getFindingHistoryWithHttpInfo(Integer findingId) throws ApiException {
        com.squareup.okhttp.Call call = getFindingHistoryValidateBeforeCall(findingId, null, null);
        Type localVarReturnType = new TypeToken<List<ActivityEvent>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Finding History (asynchronously)
     * Responds with an array of \&quot;activity event\&quot; objects in JSON. 
     * @param findingId The finding ID. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFindingHistoryAsync(Integer findingId, final ApiCallback<List<ActivityEvent>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFindingHistoryValidateBeforeCall(findingId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ActivityEvent>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFindingsCount
     * @param projectId The ID of the project. (required)
     * @param query  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFindingsCountCall(Integer projectId, Query query, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = query;

        // create path and map variables
        String localVarPath = "/api/projects/{project-id}/findings/count"
            .replaceAll("\\{" + "project-id" + "\\}", apiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFindingsCountValidateBeforeCall(Integer projectId, Query query, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getFindingsCount(Async)");
        }
        

        com.squareup.okhttp.Call call = getFindingsCountCall(projectId, query, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Finding Count
     * Returns the count of all findings in the project matching the given filter. 
     * @param projectId The ID of the project. (required)
     * @param query  (optional)
     * @return Count
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Count getFindingsCount(Integer projectId, Query query) throws ApiException {
        ApiResponse<Count> resp = getFindingsCountWithHttpInfo(projectId, query);
        return resp.getData();
    }

    /**
     * Finding Count
     * Returns the count of all findings in the project matching the given filter. 
     * @param projectId The ID of the project. (required)
     * @param query  (optional)
     * @return ApiResponse&lt;Count&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Count> getFindingsCountWithHttpInfo(Integer projectId, Query query) throws ApiException {
        com.squareup.okhttp.Call call = getFindingsCountValidateBeforeCall(projectId, query, null, null);
        Type localVarReturnType = new TypeToken<Count>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Finding Count (asynchronously)
     * Returns the count of all findings in the project matching the given filter. 
     * @param projectId The ID of the project. (required)
     * @param query  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFindingsCountAsync(Integer projectId, Query query, final ApiCallback<Count> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFindingsCountValidateBeforeCall(projectId, query, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Count>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFindingsGroupCount
     * @param projectId The ID of the project. (required)
     * @param groupedCountRequest  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFindingsGroupCountCall(Integer projectId, GroupedCountsRequest groupedCountRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = groupedCountRequest;

        // create path and map variables
        String localVarPath = "/api/projects/{project-id}/findings/grouped-counts"
            .replaceAll("\\{" + "project-id" + "\\}", apiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFindingsGroupCountValidateBeforeCall(Integer projectId, GroupedCountsRequest groupedCountRequest, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getFindingsGroupCount(Async)");
        }
        

        com.squareup.okhttp.Call call = getFindingsGroupCountCall(projectId, groupedCountRequest, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Findings Grouped Count
     * Returns filtered finding counts, grouped by the specified field. 
     * @param projectId The ID of the project. (required)
     * @param groupedCountRequest  (optional)
     * @return List&lt;GroupedCount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<GroupedCount> getFindingsGroupCount(Integer projectId, GroupedCountsRequest groupedCountRequest) throws ApiException {
        ApiResponse<List<GroupedCount>> resp = getFindingsGroupCountWithHttpInfo(projectId, groupedCountRequest);
        return resp.getData();
    }

    /**
     * Findings Grouped Count
     * Returns filtered finding counts, grouped by the specified field. 
     * @param projectId The ID of the project. (required)
     * @param groupedCountRequest  (optional)
     * @return ApiResponse&lt;List&lt;GroupedCount&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<GroupedCount>> getFindingsGroupCountWithHttpInfo(Integer projectId, GroupedCountsRequest groupedCountRequest) throws ApiException {
        com.squareup.okhttp.Call call = getFindingsGroupCountValidateBeforeCall(projectId, groupedCountRequest, null, null);
        Type localVarReturnType = new TypeToken<List<GroupedCount>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Findings Grouped Count (asynchronously)
     * Returns filtered finding counts, grouped by the specified field. 
     * @param projectId The ID of the project. (required)
     * @param groupedCountRequest  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFindingsGroupCountAsync(Integer projectId, GroupedCountsRequest groupedCountRequest, final ApiCallback<List<GroupedCount>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFindingsGroupCountValidateBeforeCall(projectId, groupedCountRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<GroupedCount>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFindingsTable
     * @param projectId The ID of the project. (required)
     * @param query  (optional)
     * @param expand The expand parameter is a comma seperated list. Each value included in the list has the potential to modify the response&#39;s Finding objects. The available values and their effects are&amp;#58; - &#x60;descriptions&#x60; - an additional property named &#x60;descriptions&#x60; is added to the Finding objects. It is a Description object that contains the tool/rule description for the finding - &#x60;descriptor&#x60; - adds additional content to the &#x60;descriptor&#x60; property of the Finding object. - &#x60;issue&#x60; - an additional property named &#x60;issue&#x60; is added to the Finding objects. &#x60;issue&#x60; will be an Issue object. - &#x60;triage-time&#x60; - an additional property named &#x60;triageTime&#x60; is added to the Finding objects. It is a date time that corresponds to the most recent time the status of the finding was updated. - &#x60;results&#x60; - an additional property named &#x60;results&#x60; is added to the Finding objects. It is an array of ToolResult objects that relate to the finding. - &#x60;results.descriptions&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property named &#x60;descriptions&#x60; to the ToolResult objects. This property is a Description object and will contain the tool and contextual descriptions for the result. - &#x60;results.descriptor&#x60; - does the same thing as &#x60;results&#x60; as well as adds additional properties to the ToolResults&#39; &#x60;descriptor&#x60; properties. - &#x60;results.metadata&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the ToolResult object named &#x60;metadata&#x60;. &#x60;metadata&#x60; is an object that contains key values pairs, usually some additional information reported by a tool. - &#x60;results.variants&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the the ToolResult object named &#x60;variants&#x60;. &#x60;variants&#x60; is an array of Variant objects. A Variant typically contains http/https request and response information.  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFindingsTableCall(Integer projectId, Query query, List<String> expand, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = query;

        // create path and map variables
        String localVarPath = "/api/projects/{project-id}/findings/table"
            .replaceAll("\\{" + "project-id" + "\\}", apiClient.escapeString(projectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expand != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "expand", expand));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFindingsTableValidateBeforeCall(Integer projectId, Query query, List<String> expand, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getFindingsTable(Async)");
        }
        

        com.squareup.okhttp.Call call = getFindingsTableCall(projectId, query, expand, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Finding Table Data
     * Returns filtered finding table data. This endpoint is a candidate to become a more generic querying API; presently it just returns the data required for the findings table as it exists today. 
     * @param projectId The ID of the project. (required)
     * @param query  (optional)
     * @param expand The expand parameter is a comma seperated list. Each value included in the list has the potential to modify the response&#39;s Finding objects. The available values and their effects are&amp;#58; - &#x60;descriptions&#x60; - an additional property named &#x60;descriptions&#x60; is added to the Finding objects. It is a Description object that contains the tool/rule description for the finding - &#x60;descriptor&#x60; - adds additional content to the &#x60;descriptor&#x60; property of the Finding object. - &#x60;issue&#x60; - an additional property named &#x60;issue&#x60; is added to the Finding objects. &#x60;issue&#x60; will be an Issue object. - &#x60;triage-time&#x60; - an additional property named &#x60;triageTime&#x60; is added to the Finding objects. It is a date time that corresponds to the most recent time the status of the finding was updated. - &#x60;results&#x60; - an additional property named &#x60;results&#x60; is added to the Finding objects. It is an array of ToolResult objects that relate to the finding. - &#x60;results.descriptions&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property named &#x60;descriptions&#x60; to the ToolResult objects. This property is a Description object and will contain the tool and contextual descriptions for the result. - &#x60;results.descriptor&#x60; - does the same thing as &#x60;results&#x60; as well as adds additional properties to the ToolResults&#39; &#x60;descriptor&#x60; properties. - &#x60;results.metadata&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the ToolResult object named &#x60;metadata&#x60;. &#x60;metadata&#x60; is an object that contains key values pairs, usually some additional information reported by a tool. - &#x60;results.variants&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the the ToolResult object named &#x60;variants&#x60;. &#x60;variants&#x60; is an array of Variant objects. A Variant typically contains http/https request and response information.  (optional)
     * @return List&lt;Finding&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<Finding> getFindingsTable(Integer projectId, Query query, List<String> expand) throws ApiException {
        ApiResponse<List<Finding>> resp = getFindingsTableWithHttpInfo(projectId, query, expand);
        return resp.getData();
    }

    /**
     * Finding Table Data
     * Returns filtered finding table data. This endpoint is a candidate to become a more generic querying API; presently it just returns the data required for the findings table as it exists today. 
     * @param projectId The ID of the project. (required)
     * @param query  (optional)
     * @param expand The expand parameter is a comma seperated list. Each value included in the list has the potential to modify the response&#39;s Finding objects. The available values and their effects are&amp;#58; - &#x60;descriptions&#x60; - an additional property named &#x60;descriptions&#x60; is added to the Finding objects. It is a Description object that contains the tool/rule description for the finding - &#x60;descriptor&#x60; - adds additional content to the &#x60;descriptor&#x60; property of the Finding object. - &#x60;issue&#x60; - an additional property named &#x60;issue&#x60; is added to the Finding objects. &#x60;issue&#x60; will be an Issue object. - &#x60;triage-time&#x60; - an additional property named &#x60;triageTime&#x60; is added to the Finding objects. It is a date time that corresponds to the most recent time the status of the finding was updated. - &#x60;results&#x60; - an additional property named &#x60;results&#x60; is added to the Finding objects. It is an array of ToolResult objects that relate to the finding. - &#x60;results.descriptions&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property named &#x60;descriptions&#x60; to the ToolResult objects. This property is a Description object and will contain the tool and contextual descriptions for the result. - &#x60;results.descriptor&#x60; - does the same thing as &#x60;results&#x60; as well as adds additional properties to the ToolResults&#39; &#x60;descriptor&#x60; properties. - &#x60;results.metadata&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the ToolResult object named &#x60;metadata&#x60;. &#x60;metadata&#x60; is an object that contains key values pairs, usually some additional information reported by a tool. - &#x60;results.variants&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the the ToolResult object named &#x60;variants&#x60;. &#x60;variants&#x60; is an array of Variant objects. A Variant typically contains http/https request and response information.  (optional)
     * @return ApiResponse&lt;List&lt;Finding&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<Finding>> getFindingsTableWithHttpInfo(Integer projectId, Query query, List<String> expand) throws ApiException {
        com.squareup.okhttp.Call call = getFindingsTableValidateBeforeCall(projectId, query, expand, null, null);
        Type localVarReturnType = new TypeToken<List<Finding>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Finding Table Data (asynchronously)
     * Returns filtered finding table data. This endpoint is a candidate to become a more generic querying API; presently it just returns the data required for the findings table as it exists today. 
     * @param projectId The ID of the project. (required)
     * @param query  (optional)
     * @param expand The expand parameter is a comma seperated list. Each value included in the list has the potential to modify the response&#39;s Finding objects. The available values and their effects are&amp;#58; - &#x60;descriptions&#x60; - an additional property named &#x60;descriptions&#x60; is added to the Finding objects. It is a Description object that contains the tool/rule description for the finding - &#x60;descriptor&#x60; - adds additional content to the &#x60;descriptor&#x60; property of the Finding object. - &#x60;issue&#x60; - an additional property named &#x60;issue&#x60; is added to the Finding objects. &#x60;issue&#x60; will be an Issue object. - &#x60;triage-time&#x60; - an additional property named &#x60;triageTime&#x60; is added to the Finding objects. It is a date time that corresponds to the most recent time the status of the finding was updated. - &#x60;results&#x60; - an additional property named &#x60;results&#x60; is added to the Finding objects. It is an array of ToolResult objects that relate to the finding. - &#x60;results.descriptions&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property named &#x60;descriptions&#x60; to the ToolResult objects. This property is a Description object and will contain the tool and contextual descriptions for the result. - &#x60;results.descriptor&#x60; - does the same thing as &#x60;results&#x60; as well as adds additional properties to the ToolResults&#39; &#x60;descriptor&#x60; properties. - &#x60;results.metadata&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the ToolResult object named &#x60;metadata&#x60;. &#x60;metadata&#x60; is an object that contains key values pairs, usually some additional information reported by a tool. - &#x60;results.variants&#x60; - does the same thing as &#x60;results&#x60; as well as adds an additional property to the the ToolResult object named &#x60;variants&#x60;. &#x60;variants&#x60; is an array of Variant objects. A Variant typically contains http/https request and response information.  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFindingsTableAsync(Integer projectId, Query query, List<String> expand, final ApiCallback<List<Finding>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFindingsTableValidateBeforeCall(projectId, query, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<Finding>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getSourceFileContents
     * @param projectId The ID of the project. (required)
     * @param pathId The ID of the path (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSourceFileContentsCall(Integer projectId, Integer pathId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/projects/{project-id}/files/{path-id}"
            .replaceAll("\\{" + "project-id" + "\\}", apiClient.escapeString(projectId.toString()))
            .replaceAll("\\{" + "path-id" + "\\}", apiClient.escapeString(pathId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSourceFileContentsValidateBeforeCall(Integer projectId, Integer pathId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getSourceFileContents(Async)");
        }
        
        // verify the required parameter 'pathId' is set
        if (pathId == null) {
            throw new ApiException("Missing the required parameter 'pathId' when calling getSourceFileContents(Async)");
        }
        

        com.squareup.okhttp.Call call = getSourceFileContentsCall(projectId, pathId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Source File Contents
     * Returns the contents of a given file, as long as it is a text file. 
     * @param projectId The ID of the project. (required)
     * @param pathId The ID of the path (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public String getSourceFileContents(Integer projectId, Integer pathId) throws ApiException {
        ApiResponse<String> resp = getSourceFileContentsWithHttpInfo(projectId, pathId);
        return resp.getData();
    }

    /**
     * Source File Contents
     * Returns the contents of a given file, as long as it is a text file. 
     * @param projectId The ID of the project. (required)
     * @param pathId The ID of the path (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<String> getSourceFileContentsWithHttpInfo(Integer projectId, Integer pathId) throws ApiException {
        com.squareup.okhttp.Call call = getSourceFileContentsValidateBeforeCall(projectId, pathId, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Source File Contents (asynchronously)
     * Returns the contents of a given file, as long as it is a text file. 
     * @param projectId The ID of the project. (required)
     * @param pathId The ID of the path (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSourceFileContentsAsync(Integer projectId, Integer pathId, final ApiCallback<String> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSourceFileContentsValidateBeforeCall(projectId, pathId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getSourceFileContentsFromPath
     * @param projectId The ID of the project. (required)
     * @param path The literal path to the file (e.g., \&quot;com/foo/bar/Baz.java\&quot;) (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSourceFileContentsFromPathCall(Integer projectId, String path, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/projects/{project-id}/files/tree/{path}"
            .replaceAll("\\{" + "project-id" + "\\}", apiClient.escapeString(projectId.toString()))
            .replaceAll("\\{" + "path" + "\\}", apiClient.escapeString(path.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSourceFileContentsFromPathValidateBeforeCall(Integer projectId, String path, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getSourceFileContentsFromPath(Async)");
        }
        
        // verify the required parameter 'path' is set
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getSourceFileContentsFromPath(Async)");
        }
        

        com.squareup.okhttp.Call call = getSourceFileContentsFromPathCall(projectId, path, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Source File Contents (tree)
     * Returns the contents of a given file, as long as it is a text file. 
     * @param projectId The ID of the project. (required)
     * @param path The literal path to the file (e.g., \&quot;com/foo/bar/Baz.java\&quot;) (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public String getSourceFileContentsFromPath(Integer projectId, String path) throws ApiException {
        ApiResponse<String> resp = getSourceFileContentsFromPathWithHttpInfo(projectId, path);
        return resp.getData();
    }

    /**
     * Source File Contents (tree)
     * Returns the contents of a given file, as long as it is a text file. 
     * @param projectId The ID of the project. (required)
     * @param path The literal path to the file (e.g., \&quot;com/foo/bar/Baz.java\&quot;) (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<String> getSourceFileContentsFromPathWithHttpInfo(Integer projectId, String path) throws ApiException {
        com.squareup.okhttp.Call call = getSourceFileContentsFromPathValidateBeforeCall(projectId, path, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Source File Contents (tree) (asynchronously)
     * Returns the contents of a given file, as long as it is a text file. 
     * @param projectId The ID of the project. (required)
     * @param path The literal path to the file (e.g., \&quot;com/foo/bar/Baz.java\&quot;) (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSourceFileContentsFromPathAsync(Integer projectId, String path, final ApiCallback<String> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getSourceFileContentsFromPathValidateBeforeCall(projectId, path, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
