/*
 * Code Dx API
 * Code Dx provides a variety of REST APIs, allowing external applications and scripts to interface with core functionality. This guide documents the various REST resources provided by Code Dx.  ## Authentication  Authentication is a requirement when accessing API endpoints. There are two methods by which authentication may be performed.  ### API Keys  The primary method for authentication is passing an `API-Key` header containing a valid API key with all requests.  For example&#58;  `API-Key: 550e8400-e29b-41d4-a716-44665544000`  API keys may be generated by Code Dx admins. Once they are generated, in most cases, they behave like regular users. They will need to be assigned user roles for any projects they will be used with. Although it is possible to assign the *admin* [role](UserGuide.html#UserRolesConfiguration) to an API key, the recommendation is to avoid doing so unless absolutely necessary.  See the user guide for an overview about how to create and manage [API keys](UserGuide.html#APIKeysAdministration).  ### HTTP Basic Authentication  HTTP Basic authentication may be used to authenticate with the API as a regular user. This is accomplished by including an `Authorization` header containing a typical authorization credential.  ## Error Handling  ### Bad Requests  For API calls that accept input, invalid values will trigger an HTTP 400 Bad Request status code.  ### Server Errors  For any API call, if an unexpected error occurs, an HTTP 500 Internal Server Error status code will be returned. If an error message is available, the response will include a basic message body describing the error&#58;  ` {   \"error\": \"error message\" } `  The error property will contain a string message indicating the nature of the error.  ### Errors with Third-Party Applications  Sometimes Code Dx must communicate with third-party applications like JIRA, Git, and certain enterprise tools. Some users may have in-house versions of these with self-signed certificates which may not be \"trusted\". In these cases, the API will respond with an HTTP 502 BAD GATEWAY status. If this happens, refer to [Trusting Self-Signed Certificates](InstallGuide.html#TrustingSelfSignedCertificates) in the install guide.  ### API Unavailable  In special circumstances, particularly during the installation and update phases, the API will be unavailable. When the API is unavailable, all calls will return an HTTP 503 Service Unavailable status, and no actions or side effects will occur as a result of the calls.  ## Examples  Code Dx's API uses REST over HTTP. As such, you can use any language/utility that supports making HTTP requests to interact with the API. The examples below use <a href=\"https://curl.haxx.se/\" target=\"_blank\">curl</a>, a popular command-line utility, to do so.  First, you'll need to [generate an API Key](UserGuide.html#APIKeysAdministration). Second, while you can create projects through the API, these examples will assume that you've already created one. You'll need to know its project id number, which you can find by looking at the URL for the [Findings Page](UserGuide.html#Findings), which will end in a number.  **Note:** Many API endpoints require a JSON body in the request. Most JSON will contain double-quotes (`\"`) and spaces, which have special meaning when used on the command line. In order to ensure your JSON body is interpreted as a single argument, you must <a href=\"https://en.wikipedia.org/wiki/Escape_character\" target=\"_blank\">escape</a> it properly. For example, if you wanted to `POST` the following JSON body&#58;  ``` { \"name\": \"John Doe\" } ```  You would put a backslash (`\\`) before each double-quote (`\"`), and surround the whole thing with double-quotes&#58;  ``` \"{ \\\"name\\\": \\\"John Doe\\\" }\" ```  The outermost double-quotes tell the command-line interpreter that everything within them is to be treated as a single argument (as opposed to the usual space-separated behavior). The backslash before each inner double-quote tells the command-line interpreter that you mean the literal double-quote character, and not the end of the quoted argument.  In many *non-Windows* operating systems, you can also use a single-quote (`'`) to surround the argument, and skip the backslashes&#58;  ``` '{ \"name\": \"John Doe\" }' ```  The examples below will use the double-quotes and backslashes style, as it works on most (if not all) operating systems.  ### Running an Analysis  To start an analysis, you can run  ``` curl -F file1=@src.zip -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/analysis ```  Make sure you use your own values for the `src.zip` file, the API Key, the hostname for your Code Dx server, and the project id.  **Note:** This endpoint is not listed below due to a swagger limitation.  ### Retrieving Finding Data  There is a wide variety of data available for the findings of a project after running an analysis. Two examples are provided here.  ### Findings Table Data  You can retrieve the data that's used to populate the [findings table](UserGuide.html#FindingsTable)&#58;  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"sort\\\":{\\\"by\\\":\\\"id\\\",\\\"direction\\\":\\\"ascending\\\"},\\\"pagination\\\":{\\\"page\\\":1,\\\"perPage\\\":10}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/findings/table ```  Additional information about how to construct more useful filter and sort requests can be found in the documentation.  ### Finding Metadata  You can retrieve metadata for a finding, if you know the finding id. You can take the ID for a finding from the Findings Table&#58;  ``` curl -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/findings/<finding id> ```  ### Generating a Report  You can use the API to generate a PDF [report](UserGuide.html#GenerateReport).  ``` curl -H \"Content-Type: application/json\" -X POST -d \"{\\\"filter\\\":{},\\\"config\\\":{\\\"summaryMode\\\":\\\"simple\\\",\\\"detailsMode\\\":\\\"simple\\\",\\\"includeResultDetails\\\":true,\\\"includeComments\\\":false}}\" -H \"API-Key: 942d16d4-fb3f-4653-9cb3-a9da2e28e574\" https://<yourcodedxserver>/codedx/api/projects/<project id>/report/pdf ```  ## Generating a Client SDK  If you require a client SDK for Code Dx, you can generate one using [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen). Detailed instructions are available on the github page and our swagger spec can be found [here](swagger/swagger.json). 
 *
 * OpenAPI spec version: 3.5.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.codedx.client.model.CreateRule;
import java.io.File;
import com.codedx.client.model.ModifyRuleResponse;
import com.codedx.client.model.Rule;
import com.codedx.client.model.RuleCriteria;
import com.codedx.client.model.RuleSet;
import com.codedx.client.model.RuleSetContents;
import com.codedx.client.model.RuleSetDeleteError;
import com.codedx.client.model.RuleSetDeleteResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleSetsApi {
    private ApiClient apiClient;

    public RuleSetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RuleSetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for addRuleCriteria
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param ruleCriteria  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addRuleCriteriaCall(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ruleCriteria;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}/rule/{rule-id}/criteria"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()))
            .replaceAll("\\{" + "rule-id" + "\\}", apiClient.escapeString(ruleId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addRuleCriteriaValidateBeforeCall(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling addRuleCriteria(Async)");
        }
        
        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling addRuleCriteria(Async)");
        }
        
        // verify the required parameter 'ruleCriteria' is set
        if (ruleCriteria == null) {
            throw new ApiException("Missing the required parameter 'ruleCriteria' when calling addRuleCriteria(Async)");
        }
        

        com.squareup.okhttp.Call call = addRuleCriteriaCall(rulesetId, ruleId, ruleCriteria, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add Rule Criteria
     * Allows user to add rule criteria
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param ruleCriteria  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void addRuleCriteria(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria) throws ApiException {
        addRuleCriteriaWithHttpInfo(rulesetId, ruleId, ruleCriteria);
    }

    /**
     * Add Rule Criteria
     * Allows user to add rule criteria
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param ruleCriteria  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> addRuleCriteriaWithHttpInfo(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria) throws ApiException {
        com.squareup.okhttp.Call call = addRuleCriteriaValidateBeforeCall(rulesetId, ruleId, ruleCriteria, null, null);
        return apiClient.execute(call);
    }

    /**
     * Add Rule Criteria (asynchronously)
     * Allows user to add rule criteria
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param ruleCriteria  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addRuleCriteriaAsync(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addRuleCriteriaValidateBeforeCall(rulesetId, ruleId, ruleCriteria, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for cloneRuleSet
     * @param rulesetId  (required)
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call cloneRuleSetCall(Integer rulesetId, RuleSet ruleSet, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ruleSet;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}/clone"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call cloneRuleSetValidateBeforeCall(Integer rulesetId, RuleSet ruleSet, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling cloneRuleSet(Async)");
        }
        
        // verify the required parameter 'ruleSet' is set
        if (ruleSet == null) {
            throw new ApiException("Missing the required parameter 'ruleSet' when calling cloneRuleSet(Async)");
        }
        

        com.squareup.okhttp.Call call = cloneRuleSetCall(rulesetId, ruleSet, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Clone Rule Set
     * Allows user to clone a rule set
     * @param rulesetId  (required)
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @return RuleSet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RuleSet cloneRuleSet(Integer rulesetId, RuleSet ruleSet) throws ApiException {
        ApiResponse<RuleSet> resp = cloneRuleSetWithHttpInfo(rulesetId, ruleSet);
        return resp.getData();
    }

    /**
     * Clone Rule Set
     * Allows user to clone a rule set
     * @param rulesetId  (required)
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @return ApiResponse&lt;RuleSet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RuleSet> cloneRuleSetWithHttpInfo(Integer rulesetId, RuleSet ruleSet) throws ApiException {
        com.squareup.okhttp.Call call = cloneRuleSetValidateBeforeCall(rulesetId, ruleSet, null, null);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Clone Rule Set (asynchronously)
     * Allows user to clone a rule set
     * @param rulesetId  (required)
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call cloneRuleSetAsync(Integer rulesetId, RuleSet ruleSet, final ApiCallback<RuleSet> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = cloneRuleSetValidateBeforeCall(rulesetId, ruleSet, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for createRule
     * @param rulesetId  (required)
     * @param rule  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createRuleCall(Integer rulesetId, CreateRule rule, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = rule;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}/rule"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createRuleValidateBeforeCall(Integer rulesetId, CreateRule rule, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling createRule(Async)");
        }
        
        // verify the required parameter 'rule' is set
        if (rule == null) {
            throw new ApiException("Missing the required parameter 'rule' when calling createRule(Async)");
        }
        

        com.squareup.okhttp.Call call = createRuleCall(rulesetId, rule, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create Rule
     * Allows user to create a Rule
     * @param rulesetId  (required)
     * @param rule  (required)
     * @return Rule
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Rule createRule(Integer rulesetId, CreateRule rule) throws ApiException {
        ApiResponse<Rule> resp = createRuleWithHttpInfo(rulesetId, rule);
        return resp.getData();
    }

    /**
     * Create Rule
     * Allows user to create a Rule
     * @param rulesetId  (required)
     * @param rule  (required)
     * @return ApiResponse&lt;Rule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Rule> createRuleWithHttpInfo(Integer rulesetId, CreateRule rule) throws ApiException {
        com.squareup.okhttp.Call call = createRuleValidateBeforeCall(rulesetId, rule, null, null);
        Type localVarReturnType = new TypeToken<Rule>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create Rule (asynchronously)
     * Allows user to create a Rule
     * @param rulesetId  (required)
     * @param rule  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createRuleAsync(Integer rulesetId, CreateRule rule, final ApiCallback<Rule> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createRuleValidateBeforeCall(rulesetId, rule, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Rule>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for createRuleSet
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createRuleSetCall(RuleSet ruleSet, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ruleSet;

        // create path and map variables
        String localVarPath = "/api/ruleset";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createRuleSetValidateBeforeCall(RuleSet ruleSet, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'ruleSet' is set
        if (ruleSet == null) {
            throw new ApiException("Missing the required parameter 'ruleSet' when calling createRuleSet(Async)");
        }
        

        com.squareup.okhttp.Call call = createRuleSetCall(ruleSet, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create Rule Set
     * Creates a rule set
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @return RuleSet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RuleSet createRuleSet(RuleSet ruleSet) throws ApiException {
        ApiResponse<RuleSet> resp = createRuleSetWithHttpInfo(ruleSet);
        return resp.getData();
    }

    /**
     * Create Rule Set
     * Creates a rule set
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @return ApiResponse&lt;RuleSet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RuleSet> createRuleSetWithHttpInfo(RuleSet ruleSet) throws ApiException {
        com.squareup.okhttp.Call call = createRuleSetValidateBeforeCall(ruleSet, null, null);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create Rule Set (asynchronously)
     * Creates a rule set
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createRuleSetAsync(RuleSet ruleSet, final ApiCallback<RuleSet> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = createRuleSetValidateBeforeCall(ruleSet, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteRule
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRuleCall(Integer rulesetId, Integer ruleId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}/rule/{rule-id}"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()))
            .replaceAll("\\{" + "rule-id" + "\\}", apiClient.escapeString(ruleId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRuleValidateBeforeCall(Integer rulesetId, Integer ruleId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling deleteRule(Async)");
        }
        
        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling deleteRule(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteRuleCall(rulesetId, ruleId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete Rule
     * Allows user to delete a rule
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteRule(Integer rulesetId, Integer ruleId) throws ApiException {
        deleteRuleWithHttpInfo(rulesetId, ruleId);
    }

    /**
     * Delete Rule
     * Allows user to delete a rule
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteRuleWithHttpInfo(Integer rulesetId, Integer ruleId) throws ApiException {
        com.squareup.okhttp.Call call = deleteRuleValidateBeforeCall(rulesetId, ruleId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete Rule (asynchronously)
     * Allows user to delete a rule
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteRuleAsync(Integer rulesetId, Integer ruleId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteRuleValidateBeforeCall(rulesetId, ruleId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteRuleCriteria
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param ruleCriteria  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRuleCriteriaCall(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ruleCriteria;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}/rule/{rule-id}/criteria"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()))
            .replaceAll("\\{" + "rule-id" + "\\}", apiClient.escapeString(ruleId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRuleCriteriaValidateBeforeCall(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling deleteRuleCriteria(Async)");
        }
        
        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling deleteRuleCriteria(Async)");
        }
        
        // verify the required parameter 'ruleCriteria' is set
        if (ruleCriteria == null) {
            throw new ApiException("Missing the required parameter 'ruleCriteria' when calling deleteRuleCriteria(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteRuleCriteriaCall(rulesetId, ruleId, ruleCriteria, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete Rule Criteria
     * Allows user to delete rule criteria
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param ruleCriteria  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteRuleCriteria(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria) throws ApiException {
        deleteRuleCriteriaWithHttpInfo(rulesetId, ruleId, ruleCriteria);
    }

    /**
     * Delete Rule Criteria
     * Allows user to delete rule criteria
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param ruleCriteria  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteRuleCriteriaWithHttpInfo(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria) throws ApiException {
        com.squareup.okhttp.Call call = deleteRuleCriteriaValidateBeforeCall(rulesetId, ruleId, ruleCriteria, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete Rule Criteria (asynchronously)
     * Allows user to delete rule criteria
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param ruleCriteria  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteRuleCriteriaAsync(Integer rulesetId, Integer ruleId, RuleCriteria ruleCriteria, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteRuleCriteriaValidateBeforeCall(rulesetId, ruleId, ruleCriteria, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteRuleSet
     * @param rulesetId  (required)
     * @param force Set to true to force delete the rule set (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRuleSetCall(Integer rulesetId, Boolean force, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (force != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("force", force));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRuleSetValidateBeforeCall(Integer rulesetId, Boolean force, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling deleteRuleSet(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteRuleSetCall(rulesetId, force, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete Rule Set
     * Allows user to delete a rule set
     * @param rulesetId  (required)
     * @param force Set to true to force delete the rule set (optional)
     * @return RuleSetDeleteResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RuleSetDeleteResponse deleteRuleSet(Integer rulesetId, Boolean force) throws ApiException {
        ApiResponse<RuleSetDeleteResponse> resp = deleteRuleSetWithHttpInfo(rulesetId, force);
        return resp.getData();
    }

    /**
     * Delete Rule Set
     * Allows user to delete a rule set
     * @param rulesetId  (required)
     * @param force Set to true to force delete the rule set (optional)
     * @return ApiResponse&lt;RuleSetDeleteResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RuleSetDeleteResponse> deleteRuleSetWithHttpInfo(Integer rulesetId, Boolean force) throws ApiException {
        com.squareup.okhttp.Call call = deleteRuleSetValidateBeforeCall(rulesetId, force, null, null);
        Type localVarReturnType = new TypeToken<RuleSetDeleteResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete Rule Set (asynchronously)
     * Allows user to delete a rule set
     * @param rulesetId  (required)
     * @param force Set to true to force delete the rule set (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteRuleSetAsync(Integer rulesetId, Boolean force, final ApiCallback<RuleSetDeleteResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteRuleSetValidateBeforeCall(rulesetId, force, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleSetDeleteResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for exportRuleSet
     * @param rulesetId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call exportRuleSetCall(Integer rulesetId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}/export"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/xml"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call exportRuleSetValidateBeforeCall(Integer rulesetId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling exportRuleSet(Async)");
        }
        

        com.squareup.okhttp.Call call = exportRuleSetCall(rulesetId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Export Rule Set
     * Allows user to export a rule set as an XML file
     * @param rulesetId  (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File exportRuleSet(Integer rulesetId) throws ApiException {
        ApiResponse<File> resp = exportRuleSetWithHttpInfo(rulesetId);
        return resp.getData();
    }

    /**
     * Export Rule Set
     * Allows user to export a rule set as an XML file
     * @param rulesetId  (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> exportRuleSetWithHttpInfo(Integer rulesetId) throws ApiException {
        com.squareup.okhttp.Call call = exportRuleSetValidateBeforeCall(rulesetId, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Export Rule Set (asynchronously)
     * Allows user to export a rule set as an XML file
     * @param rulesetId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call exportRuleSetAsync(Integer rulesetId, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = exportRuleSetValidateBeforeCall(rulesetId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAllRuleSets
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAllRuleSetsCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/ruleset/all";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllRuleSetsValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getAllRuleSetsCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get Rule Sets
     * Provides a list of rule sets
     * @return List&lt;RuleSet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<RuleSet> getAllRuleSets() throws ApiException {
        ApiResponse<List<RuleSet>> resp = getAllRuleSetsWithHttpInfo();
        return resp.getData();
    }

    /**
     * Get Rule Sets
     * Provides a list of rule sets
     * @return ApiResponse&lt;List&lt;RuleSet&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<RuleSet>> getAllRuleSetsWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = getAllRuleSetsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<List<RuleSet>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Rule Sets (asynchronously)
     * Provides a list of rule sets
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAllRuleSetsAsync(final ApiCallback<List<RuleSet>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAllRuleSetsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<RuleSet>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getRuleData
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRuleDataCall(Integer rulesetId, Integer ruleId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}/rule/{rule-id}"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()))
            .replaceAll("\\{" + "rule-id" + "\\}", apiClient.escapeString(ruleId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRuleDataValidateBeforeCall(Integer rulesetId, Integer ruleId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling getRuleData(Async)");
        }
        
        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling getRuleData(Async)");
        }
        

        com.squareup.okhttp.Call call = getRuleDataCall(rulesetId, ruleId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get Rule Data
     * Allows user to view a specific rule&#39;s data
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @return Rule
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Rule getRuleData(Integer rulesetId, Integer ruleId) throws ApiException {
        ApiResponse<Rule> resp = getRuleDataWithHttpInfo(rulesetId, ruleId);
        return resp.getData();
    }

    /**
     * Get Rule Data
     * Allows user to view a specific rule&#39;s data
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @return ApiResponse&lt;Rule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Rule> getRuleDataWithHttpInfo(Integer rulesetId, Integer ruleId) throws ApiException {
        com.squareup.okhttp.Call call = getRuleDataValidateBeforeCall(rulesetId, ruleId, null, null);
        Type localVarReturnType = new TypeToken<Rule>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Rule Data (asynchronously)
     * Allows user to view a specific rule&#39;s data
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getRuleDataAsync(Integer rulesetId, Integer ruleId, final ApiCallback<Rule> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRuleDataValidateBeforeCall(rulesetId, ruleId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Rule>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getRuleSetContents
     * @param rulesetId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getRuleSetContentsCall(Integer rulesetId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getRuleSetContentsValidateBeforeCall(Integer rulesetId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling getRuleSetContents(Async)");
        }
        

        com.squareup.okhttp.Call call = getRuleSetContentsCall(rulesetId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get Rule Set Contents
     * Returns an object representing the contents of a rule set
     * @param rulesetId  (required)
     * @return RuleSetContents
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RuleSetContents getRuleSetContents(Integer rulesetId) throws ApiException {
        ApiResponse<RuleSetContents> resp = getRuleSetContentsWithHttpInfo(rulesetId);
        return resp.getData();
    }

    /**
     * Get Rule Set Contents
     * Returns an object representing the contents of a rule set
     * @param rulesetId  (required)
     * @return ApiResponse&lt;RuleSetContents&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RuleSetContents> getRuleSetContentsWithHttpInfo(Integer rulesetId) throws ApiException {
        com.squareup.okhttp.Call call = getRuleSetContentsValidateBeforeCall(rulesetId, null, null);
        Type localVarReturnType = new TypeToken<RuleSetContents>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Rule Set Contents (asynchronously)
     * Returns an object representing the contents of a rule set
     * @param rulesetId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getRuleSetContentsAsync(Integer rulesetId, final ApiCallback<RuleSetContents> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getRuleSetContentsValidateBeforeCall(rulesetId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleSetContents>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for modifyRuleData
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param rule  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call modifyRuleDataCall(Integer rulesetId, Integer ruleId, CreateRule rule, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = rule;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}/rule/{rule-id}"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()))
            .replaceAll("\\{" + "rule-id" + "\\}", apiClient.escapeString(ruleId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call modifyRuleDataValidateBeforeCall(Integer rulesetId, Integer ruleId, CreateRule rule, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling modifyRuleData(Async)");
        }
        
        // verify the required parameter 'ruleId' is set
        if (ruleId == null) {
            throw new ApiException("Missing the required parameter 'ruleId' when calling modifyRuleData(Async)");
        }
        
        // verify the required parameter 'rule' is set
        if (rule == null) {
            throw new ApiException("Missing the required parameter 'rule' when calling modifyRuleData(Async)");
        }
        

        com.squareup.okhttp.Call call = modifyRuleDataCall(rulesetId, ruleId, rule, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Modify Rule Descriptor
     * Allows user to modify a specific rule&#39;s data
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param rule  (required)
     * @return ModifyRuleResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ModifyRuleResponse modifyRuleData(Integer rulesetId, Integer ruleId, CreateRule rule) throws ApiException {
        ApiResponse<ModifyRuleResponse> resp = modifyRuleDataWithHttpInfo(rulesetId, ruleId, rule);
        return resp.getData();
    }

    /**
     * Modify Rule Descriptor
     * Allows user to modify a specific rule&#39;s data
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param rule  (required)
     * @return ApiResponse&lt;ModifyRuleResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ModifyRuleResponse> modifyRuleDataWithHttpInfo(Integer rulesetId, Integer ruleId, CreateRule rule) throws ApiException {
        com.squareup.okhttp.Call call = modifyRuleDataValidateBeforeCall(rulesetId, ruleId, rule, null, null);
        Type localVarReturnType = new TypeToken<ModifyRuleResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Modify Rule Descriptor (asynchronously)
     * Allows user to modify a specific rule&#39;s data
     * @param rulesetId  (required)
     * @param ruleId  (required)
     * @param rule  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call modifyRuleDataAsync(Integer rulesetId, Integer ruleId, CreateRule rule, final ApiCallback<ModifyRuleResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = modifyRuleDataValidateBeforeCall(rulesetId, ruleId, rule, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ModifyRuleResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for renameRuleSet
     * @param rulesetId  (required)
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call renameRuleSetCall(Integer rulesetId, RuleSet ruleSet, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ruleSet;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call renameRuleSetValidateBeforeCall(Integer rulesetId, RuleSet ruleSet, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling renameRuleSet(Async)");
        }
        
        // verify the required parameter 'ruleSet' is set
        if (ruleSet == null) {
            throw new ApiException("Missing the required parameter 'ruleSet' when calling renameRuleSet(Async)");
        }
        

        com.squareup.okhttp.Call call = renameRuleSetCall(rulesetId, ruleSet, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Rename Rule Set
     * Allows user to rename a rule set
     * @param rulesetId  (required)
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @return RuleSet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RuleSet renameRuleSet(Integer rulesetId, RuleSet ruleSet) throws ApiException {
        ApiResponse<RuleSet> resp = renameRuleSetWithHttpInfo(rulesetId, ruleSet);
        return resp.getData();
    }

    /**
     * Rename Rule Set
     * Allows user to rename a rule set
     * @param rulesetId  (required)
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @return ApiResponse&lt;RuleSet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RuleSet> renameRuleSetWithHttpInfo(Integer rulesetId, RuleSet ruleSet) throws ApiException {
        com.squareup.okhttp.Call call = renameRuleSetValidateBeforeCall(rulesetId, ruleSet, null, null);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Rename Rule Set (asynchronously)
     * Allows user to rename a rule set
     * @param rulesetId  (required)
     * @param ruleSet The values for &#x60;id&#x60; and &#x60;canEdit&#x60; will be ignored, only &#x60;name&#x60; is required (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call renameRuleSetAsync(Integer rulesetId, RuleSet ruleSet, final ApiCallback<RuleSet> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = renameRuleSetValidateBeforeCall(rulesetId, ruleSet, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updateRuleSet
     * @param ruleSetXml The xml file to be uploaded (required)
     * @param rulesetId  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateRuleSetCall(File ruleSetXml, Integer rulesetId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/ruleset/{ruleset-id}/update"
            .replaceAll("\\{" + "ruleset-id" + "\\}", apiClient.escapeString(rulesetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ruleSetXml != null)
        localVarFormParams.put("ruleSetXml", ruleSetXml);

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateRuleSetValidateBeforeCall(File ruleSetXml, Integer rulesetId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'ruleSetXml' is set
        if (ruleSetXml == null) {
            throw new ApiException("Missing the required parameter 'ruleSetXml' when calling updateRuleSet(Async)");
        }
        
        // verify the required parameter 'rulesetId' is set
        if (rulesetId == null) {
            throw new ApiException("Missing the required parameter 'rulesetId' when calling updateRuleSet(Async)");
        }
        

        com.squareup.okhttp.Call call = updateRuleSetCall(ruleSetXml, rulesetId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update Rule Set
     * Update rule set using an XML file
     * @param ruleSetXml The xml file to be uploaded (required)
     * @param rulesetId  (required)
     * @return RuleSet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RuleSet updateRuleSet(File ruleSetXml, Integer rulesetId) throws ApiException {
        ApiResponse<RuleSet> resp = updateRuleSetWithHttpInfo(ruleSetXml, rulesetId);
        return resp.getData();
    }

    /**
     * Update Rule Set
     * Update rule set using an XML file
     * @param ruleSetXml The xml file to be uploaded (required)
     * @param rulesetId  (required)
     * @return ApiResponse&lt;RuleSet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RuleSet> updateRuleSetWithHttpInfo(File ruleSetXml, Integer rulesetId) throws ApiException {
        com.squareup.okhttp.Call call = updateRuleSetValidateBeforeCall(ruleSetXml, rulesetId, null, null);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update Rule Set (asynchronously)
     * Update rule set using an XML file
     * @param ruleSetXml The xml file to be uploaded (required)
     * @param rulesetId  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateRuleSetAsync(File ruleSetXml, Integer rulesetId, final ApiCallback<RuleSet> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateRuleSetValidateBeforeCall(ruleSetXml, rulesetId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for uploadRuleSet
     * @param ruleSetXml The xml file to be uploaded (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call uploadRuleSetCall(File ruleSetXml, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/ruleset/import";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ruleSetXml != null)
        localVarFormParams.put("ruleSetXml", ruleSetXml);

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "APIKeyHeader", "basicAuth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call uploadRuleSetValidateBeforeCall(File ruleSetXml, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'ruleSetXml' is set
        if (ruleSetXml == null) {
            throw new ApiException("Missing the required parameter 'ruleSetXml' when calling uploadRuleSet(Async)");
        }
        

        com.squareup.okhttp.Call call = uploadRuleSetCall(ruleSetXml, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Import Rule Set
     * Import rule set using an XML file
     * @param ruleSetXml The xml file to be uploaded (required)
     * @return RuleSet
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RuleSet uploadRuleSet(File ruleSetXml) throws ApiException {
        ApiResponse<RuleSet> resp = uploadRuleSetWithHttpInfo(ruleSetXml);
        return resp.getData();
    }

    /**
     * Import Rule Set
     * Import rule set using an XML file
     * @param ruleSetXml The xml file to be uploaded (required)
     * @return ApiResponse&lt;RuleSet&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RuleSet> uploadRuleSetWithHttpInfo(File ruleSetXml) throws ApiException {
        com.squareup.okhttp.Call call = uploadRuleSetValidateBeforeCall(ruleSetXml, null, null);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Import Rule Set (asynchronously)
     * Import rule set using an XML file
     * @param ruleSetXml The xml file to be uploaded (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call uploadRuleSetAsync(File ruleSetXml, final ApiCallback<RuleSet> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = uploadRuleSetValidateBeforeCall(ruleSetXml, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RuleSet>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
