/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;
import com.codedx.client.model.DetectionMethod;
import com.codedx.client.model.ManualResultRequest;
import com.codedx.client.model.ManualResultResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ResultsApi {
    private ApiClient apiClient;

    public ResultsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResultsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createDetectionMethodCall(DetectionMethod detectionMethod, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DetectionMethod detectionMethod2 = detectionMethod;
        String string = "/api/detection-methods";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, detectionMethod2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createDetectionMethodValidateBeforeCall(DetectionMethod detectionMethod, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (detectionMethod == null) {
            throw new ApiException("Missing the required parameter 'detectionMethod' when calling createDetectionMethod(Async)");
        }
        Call call = this.createDetectionMethodCall(detectionMethod, progressListener, progressRequestListener);
        return call;
    }

    public DetectionMethod createDetectionMethod(DetectionMethod detectionMethod) throws ApiException {
        ApiResponse<DetectionMethod> apiResponse = this.createDetectionMethodWithHttpInfo(detectionMethod);
        return apiResponse.getData();
    }

    public ApiResponse<DetectionMethod> createDetectionMethodWithHttpInfo(DetectionMethod detectionMethod) throws ApiException {
        Call call = this.createDetectionMethodValidateBeforeCall(detectionMethod, null, null);
        Type type = new TypeToken<DetectionMethod>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call createDetectionMethodAsync(DetectionMethod detectionMethod, final ApiCallback<DetectionMethod> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createDetectionMethodValidateBeforeCall(detectionMethod, progressListener, progressRequestListener);
        Type type = new TypeToken<DetectionMethod>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call createManualResultCall(ManualResultRequest manualResultRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ManualResultRequest manualResultRequest2 = manualResultRequest;
        String string = "/api/manual-results";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, manualResultRequest2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createManualResultValidateBeforeCall(ManualResultRequest manualResultRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (manualResultRequest == null) {
            throw new ApiException("Missing the required parameter 'manualResultRequest' when calling createManualResult(Async)");
        }
        Call call = this.createManualResultCall(manualResultRequest, progressListener, progressRequestListener);
        return call;
    }

    public ManualResultResponse createManualResult(ManualResultRequest manualResultRequest) throws ApiException {
        ApiResponse<ManualResultResponse> apiResponse = this.createManualResultWithHttpInfo(manualResultRequest);
        return apiResponse.getData();
    }

    public ApiResponse<ManualResultResponse> createManualResultWithHttpInfo(ManualResultRequest manualResultRequest) throws ApiException {
        Call call = this.createManualResultValidateBeforeCall(manualResultRequest, null, null);
        Type type = new TypeToken<ManualResultResponse>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call createManualResultAsync(ManualResultRequest manualResultRequest, final ApiCallback<ManualResultResponse> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createManualResultValidateBeforeCall(manualResultRequest, progressListener, progressRequestListener);
        Type type = new TypeToken<ManualResultResponse>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call deleteDetectionMethodCall(Integer n, Integer n2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string = "/api/detection-methods/{detection-method-id}".replaceAll("\\{detection-method-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        if (n2 != null) {
            arrayList.addAll(this.apiClient.parameterToPair("replacement", n2));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "DELETE", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call deleteDetectionMethodValidateBeforeCall(Integer n, Integer n2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'detectionMethodId' when calling deleteDetectionMethod(Async)");
        }
        Call call = this.deleteDetectionMethodCall(n, n2, progressListener, progressRequestListener);
        return call;
    }

    public void deleteDetectionMethod(Integer n, Integer n2) throws ApiException {
        this.deleteDetectionMethodWithHttpInfo(n, n2);
    }

    public ApiResponse<Void> deleteDetectionMethodWithHttpInfo(Integer n, Integer n2) throws ApiException {
        Call call = this.deleteDetectionMethodValidateBeforeCall(n, n2, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteDetectionMethodAsync(Integer n, Integer n2, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.deleteDetectionMethodValidateBeforeCall(n, n2, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call deleteManualResultCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/manual-results/{result-id}".replaceAll("\\{result-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "DELETE", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call deleteManualResultValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling deleteManualResult(Async)");
        }
        Call call = this.deleteManualResultCall(n, progressListener, progressRequestListener);
        return call;
    }

    public void deleteManualResult(Integer n) throws ApiException {
        this.deleteManualResultWithHttpInfo(n);
    }

    public ApiResponse<Void> deleteManualResultWithHttpInfo(Integer n) throws ApiException {
        Call call = this.deleteManualResultValidateBeforeCall(n, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteManualResultAsync(Integer n, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.deleteManualResultValidateBeforeCall(n, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call getAllDetectionMethodsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var3_3 = null;
        String string = "/api/detection-methods";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var3_3, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getAllDetectionMethodsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAllDetectionMethodsCall(progressListener, progressRequestListener);
        return call;
    }

    public List<DetectionMethod> getAllDetectionMethods() throws ApiException {
        ApiResponse<List<DetectionMethod>> apiResponse = this.getAllDetectionMethodsWithHttpInfo();
        return apiResponse.getData();
    }

    public ApiResponse<List<DetectionMethod>> getAllDetectionMethodsWithHttpInfo() throws ApiException {
        Call call = this.getAllDetectionMethodsValidateBeforeCall(null, null);
        Type type = new TypeToken<List<DetectionMethod>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getAllDetectionMethodsAsync(final ApiCallback<List<DetectionMethod>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getAllDetectionMethodsValidateBeforeCall(progressListener, progressRequestListener);
        Type type = new TypeToken<List<DetectionMethod>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getManualResultAllowedToolsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var3_3 = null;
        String string = "/api/manual-results/allowed-tools";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var3_3, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getManualResultAllowedToolsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getManualResultAllowedToolsCall(progressListener, progressRequestListener);
        return call;
    }

    public List<String> getManualResultAllowedTools() throws ApiException {
        ApiResponse<List<String>> apiResponse = this.getManualResultAllowedToolsWithHttpInfo();
        return apiResponse.getData();
    }

    public ApiResponse<List<String>> getManualResultAllowedToolsWithHttpInfo() throws ApiException {
        Call call = this.getManualResultAllowedToolsValidateBeforeCall(null, null);
        Type type = new TypeToken<List<String>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getManualResultAllowedToolsAsync(final ApiCallback<List<String>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getManualResultAllowedToolsValidateBeforeCall(progressListener, progressRequestListener);
        Type type = new TypeToken<List<String>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call modifyManualResultAllowedToolCall(String string, Boolean bl, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string2 = "/api/manual-results/allowed-tools";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        if (string != null) {
            arrayList.addAll(this.apiClient.parameterToPair("tool", string));
        }
        if (bl != null) {
            arrayList.addAll(this.apiClient.parameterToPair("allowed", bl));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string3 = this.apiClient.selectHeaderAccept(stringArray);
        if (string3 != null) {
            hashMap.put("Accept", string3);
        }
        String[] stringArray2 = new String[]{};
        String string4 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string4);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string2, "POST", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call modifyManualResultAllowedToolValidateBeforeCall(String string, Boolean bl, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.modifyManualResultAllowedToolCall(string, bl, progressListener, progressRequestListener);
        return call;
    }

    public void modifyManualResultAllowedTool(String string, Boolean bl) throws ApiException {
        this.modifyManualResultAllowedToolWithHttpInfo(string, bl);
    }

    public ApiResponse<Void> modifyManualResultAllowedToolWithHttpInfo(String string, Boolean bl) throws ApiException {
        Call call = this.modifyManualResultAllowedToolValidateBeforeCall(string, bl, null, null);
        return this.apiClient.execute(call);
    }

    public Call modifyManualResultAllowedToolAsync(String string, Boolean bl, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.modifyManualResultAllowedToolValidateBeforeCall(string, bl, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call renameDetectionMethodCall(Integer n, DetectionMethod detectionMethod, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DetectionMethod detectionMethod2 = detectionMethod;
        String string = "/api/detection-methods/{detection-method-id}".replaceAll("\\{detection-method-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "PUT", arrayList, arrayList2, detectionMethod2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call renameDetectionMethodValidateBeforeCall(Integer n, DetectionMethod detectionMethod, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'detectionMethodId' when calling renameDetectionMethod(Async)");
        }
        if (detectionMethod == null) {
            throw new ApiException("Missing the required parameter 'detectionMethod' when calling renameDetectionMethod(Async)");
        }
        Call call = this.renameDetectionMethodCall(n, detectionMethod, progressListener, progressRequestListener);
        return call;
    }

    public DetectionMethod renameDetectionMethod(Integer n, DetectionMethod detectionMethod) throws ApiException {
        ApiResponse<DetectionMethod> apiResponse = this.renameDetectionMethodWithHttpInfo(n, detectionMethod);
        return apiResponse.getData();
    }

    public ApiResponse<DetectionMethod> renameDetectionMethodWithHttpInfo(Integer n, DetectionMethod detectionMethod) throws ApiException {
        Call call = this.renameDetectionMethodValidateBeforeCall(n, detectionMethod, null, null);
        Type type = new TypeToken<DetectionMethod>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call renameDetectionMethodAsync(Integer n, DetectionMethod detectionMethod, final ApiCallback<DetectionMethod> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.renameDetectionMethodValidateBeforeCall(n, detectionMethod, progressListener, progressRequestListener);
        Type type = new TypeToken<DetectionMethod>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call replaceManualResultCall(Integer n, ManualResultRequest manualResultRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ManualResultRequest manualResultRequest2 = manualResultRequest;
        String string = "/api/manual-results/{result-id}/replace".replaceAll("\\{result-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, manualResultRequest2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call replaceManualResultValidateBeforeCall(Integer n, ManualResultRequest manualResultRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling replaceManualResult(Async)");
        }
        if (manualResultRequest == null) {
            throw new ApiException("Missing the required parameter 'manualResultRequest' when calling replaceManualResult(Async)");
        }
        Call call = this.replaceManualResultCall(n, manualResultRequest, progressListener, progressRequestListener);
        return call;
    }

    public ManualResultResponse replaceManualResult(Integer n, ManualResultRequest manualResultRequest) throws ApiException {
        ApiResponse<ManualResultResponse> apiResponse = this.replaceManualResultWithHttpInfo(n, manualResultRequest);
        return apiResponse.getData();
    }

    public ApiResponse<ManualResultResponse> replaceManualResultWithHttpInfo(Integer n, ManualResultRequest manualResultRequest) throws ApiException {
        Call call = this.replaceManualResultValidateBeforeCall(n, manualResultRequest, null, null);
        Type type = new TypeToken<ManualResultResponse>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call replaceManualResultAsync(Integer n, ManualResultRequest manualResultRequest, final ApiCallback<ManualResultResponse> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.replaceManualResultValidateBeforeCall(n, manualResultRequest, progressListener, progressRequestListener);
        Type type = new TypeToken<ManualResultResponse>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }
}

