package com.codeupsoft.base.common.response;

/**
 * 响应接口，定义了统一的响应结构规范.
 *
 * <p>该接口用于约束服务端返回给客户端的数据格式，确保响应的一致性和可预测性. 泛型参数 T 表示响应的状态码类型，V 表示实际业务数据的类型.
 *
 * @param <T> 响应状态码的类型
 * @param <V> 实际业务数据的类型
 * @author Liu,Dongdong
 * @since 1.0.0
 */
public interface Response<T, V> {

  /**
   * 获取响应状态码.
   *
   * @return 响应状态码
   */
  T getCode();

  /**
   * 获取响应消息.
   *
   * @return 响应消息
   */
  String getMessage();

  /**
   * 获取响应数据.
   *
   * @return 响应数据
   */
  @SuppressWarnings("unused")
  V getData();
}
