package com.codeupsoft.base.common.utils;

import java.util.Calendar;
import java.util.Date;
import lombok.experimental.UtilityClass;

/**
 * 时间工具.
 *
 * @author Liu,Dongdong
 */
@SuppressWarnings("unused")
@UtilityClass
public class DateAppendUtils {
  /**
   * 给指定日期增加指定的时间.
   *
   * @param date 原始日期
   * @param amount 要增加的数量
   * @param calendarField 日历字段（如 Calendar.DAY_OF_MONTH, Calendar.HOUR 等）
   * @return 增加时间后的日期
   */
  @SuppressWarnings("all")
  private static Date addTime(Date date, int amount, int calendarField) {
    if (date == null) {
      date = new Date();
    }
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(date);
    calendar.add(calendarField, amount);
    return calendar.getTime();
  }

  /**
   * 给指定日期增加指定的天数.
   *
   * @param date 原始日期
   * @param days 要增加的天数
   * @return 增加天数后的日期
   */
  public static Date addDays(Date date, int days) {
    return addTime(date, days, Calendar.DAY_OF_MONTH);
  }

  /**
   * 给指定日期增加指定的小时数.
   *
   * @param date 原始日期
   * @param hours 要增加的小时数
   * @return 增加小时数后的日期
   */
  public static Date addHours(Date date, int hours) {
    return addTime(date, hours, Calendar.HOUR_OF_DAY);
  }

  /**
   * 给指定日期增加指定的分钟数.
   *
   * @param date 原始日期
   * @param minutes 要增加的分钟数
   * @return 增加分钟数后的日期
   */
  public static Date addMinutes(Date date, int minutes) {
    return addTime(date, minutes, Calendar.MINUTE);
  }

  /**
   * 给指定日期增加指定的秒数.
   *
   * @param date 原始日期
   * @param seconds 要增加的秒数
   * @return 增加秒数后的日期
   */
  public static Date addSeconds(Date date, int seconds) {
    return addTime(date, seconds, Calendar.SECOND);
  }
}
