package com.codeupsoft.base.common.utils;

import com.codeupsoft.base.common.exception.CodeupSoftBaseException;
import java.util.Objects;
import lombok.experimental.UtilityClass;

/**
 * 异常工具类，提供断言检查.
 *
 * @author Liu,Dongdong
 * @since 1.0.0
 */
@SuppressWarnings("unused")
@UtilityClass
public class ExUtils {

  /**
   * 断言指定的对象不为null，如果为null则抛出异常.
   *
   * @param value 待检查的对象
   * @param message 异常消息
   * @throws CodeupSoftBaseException 如果对象为null时抛出
   */
  public static void ifNull(Object value, String message) {
    if (Objects.isNull(value)) {
      throw new CodeupSoftBaseException(message);
    }
  }

  /**
   * 根据条件判断是否抛出异常.
   *
   * @param condition 判断条件，当为true时抛出异常
   * @param e 异常供应器，提供要抛出的运行时异常
   * @throws RuntimeException 条件满足时抛出的异常
   */
  public static void conditional(boolean condition, ExceptionSupplier e) {
    if (condition) {
      throw e.get();
    }
  }

  /** 异常供应器函数式接口，用于延迟异常实例化. */
  @FunctionalInterface
  public interface ExceptionSupplier {
    RuntimeException get();
  }
}
