/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.test.runner;

import com.codingapi.test.annotation.CheckMysqlData;
import com.codingapi.test.annotation.Expected;
import com.codingapi.test.annotation.TestMethod;
import com.codingapi.test.runner.IRelationalDbRunner;
import com.codingapi.test.utils.SqlUtils;
import com.codingapi.test.xml.XmlInfo;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class DefaultRelationalDbRunner
implements IRelationalDbRunner {
    private static final Logger log = LoggerFactory.getLogger(DefaultRelationalDbRunner.class);

    @Override
    public void prepare(ApplicationContext applicationContext, XmlInfo xmlInfo) throws SQLException {
        DataSource dataSource = (DataSource)applicationContext.getBean(DataSource.class);
        QueryRunner queryRunner = new QueryRunner();
        for (Object object : xmlInfo.getList()) {
            SqlUtils.SqlParam sqlParam = SqlUtils.parser(xmlInfo.getInitCmd(), object);
            Object rows = queryRunner.insert(dataSource.getConnection(), sqlParam.getSql(), (ResultSetHandler)new ScalarHandler(), sqlParam.getParams());
            log.info("relational ->{},rows:{}", (Object)sqlParam.getSql(), rows);
        }
    }

    @Override
    public void clear(ApplicationContext applicationContext, TestMethod testMethod) throws SQLException {
        String[] tableNames = testMethod.clearTableNames();
        if (tableNames != null) {
            DataSource dataSource = (DataSource)applicationContext.getBean(DataSource.class);
            QueryRunner queryRunner = new QueryRunner();
            for (String tableName : tableNames) {
                String sql = SqlUtils.createClearSql(tableName);
                queryRunner.execute(dataSource.getConnection(), sql, new Object[0]);
                log.info("relational truncate sql ->{}", (Object)sql);
            }
        }
    }

    @Override
    public void check(ApplicationContext applicationContext, TestMethod testMethod) throws Exception {
        for (CheckMysqlData checkMysqlData : testMethod.checkMysqlData()) {
            String sql = checkMysqlData.sql();
            DataSource dataSource = (DataSource)applicationContext.getBean(DataSource.class);
            QueryRunner queryRunner = new QueryRunner();
            List res = (List)queryRunner.query(dataSource.getConnection(), sql, (ResultSetHandler)new MapListHandler());
            log.info("relational - check=> sql:{},res:{}", (Object)sql, (Object)res);
            Expected[] expecteds = checkMysqlData.expected();
            this.checkVal(res, expecteds, checkMysqlData.desc());
        }
    }
}

